/* md.h
 *        Copyright (C) 2003 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_MD_H
#define CDK_MD_H

typedef struct {
    unsigned long  h0, h1, h2, h3, h4;
    unsigned long  nblocks;
    unsigned char buf[64];
    int count;
} MD_CONTEXT;


/*-- mdlib/rmd160.c --*/
void _cdk_rmd160_mixblock( char *buffer, int init );
void _cdk_rmd160_hash_buffer( char *outbuf, const char *buffer, size_t len );
    
#endif /*CDK_MD_H*/


