/*
 * Copyright 2010 Inalogic® Inc.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License, as
 * published by the  Free Software Foundation; either version 2.1 or 3.0
 * of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jaytaoko@inalogic.com>
 *
 */


#include "Colors.h"

namespace nux
{
  namespace color
  {
    const Color Transparent(0, 0, 0, 0);

    //Red colors
    const Color IndianRed(0xCD, 0x5C, 0x5C);
    const Color LightCoral(0xF0, 0x80, 0x80);
    const Color Salmon(0xFA, 0x80, 0x72);
    const Color DarkSalmon(0xE9, 0x96, 0x7A);
    const Color LightSalmon(0xFF, 0xA0, 0x7A);
    const Color Crimson(0xDC, 0x14, 0x3C);
    const Color Red(0xFF, 0x00, 0x00);
    const Color FireBrick(0xB2, 0x22, 0x22);
    const Color DarkRed(0x8B, 0x00, 0x00);

    //Pink colors
    const Color Pink(0xFF, 0xC0, 0xCB);
    const Color LightPink(0xFF, 0xB6, 0xC1);
    const Color HotPink(0xFF, 0x69, 0xB4);
    const Color DeepPink(0xFF, 0x14, 0x93);
    const Color MediumVioletRed(0xC7, 0x15, 0x85);
    const Color PaleVioletRed(0xDB, 0x70, 0x93);

    //Orange colors
    //const Color LightSalmon       = Color (0xFF/255.0f, 0xA0/255.0f, 0x7A/255.0f);// 	255     160     122
    const Color Coral(0xFF, 0x7F, 0x50);
    const Color Tomato(0xFF, 0x63, 0x47);
    const Color OrangeRed(0xFF, 0x45, 0x00);
    const Color DarkOrange(0xFF, 0x8C, 0x00);
    const Color Orange(0xFF, 0xA5, 0x00);

    //Yellow colors
    const Color Gold(0xFF, 0xD7, 0x00);
    const Color Yellow(0xFF, 0xFF, 0x00);
    const Color LightYellow(0xFF, 0xFF, 0xE0);
    const Color LemonChiffon(0xFF, 0xFA, 0xCD);
    const Color LightGoldenrodYellow(0xFA, 0xFA, 0xD2);
    const Color PapayaWhip(0xFF, 0xEF, 0xD5);
    const Color Moccasin(0xFF, 0xE4, 0xB5);
    const Color PeachPuff(0xFF, 0xDA, 0xB9);
    const Color PaleGoldenrod(0xEE, 0xE8, 0xAA);
    const Color Khaki(0xF0, 0xE6, 0x8C);
    const Color DarkKhaki(0xBD, 0xB7, 0x6B);

    //Purple colors
    const Color Lavender(0xE6, 0xE6, 0xFA);
    const Color Thistle(0xD8, 0xBF, 0xD8);
    const Color Plum(0xDD, 0xA0, 0xDD);
    const Color Violet(0xEE, 0x82, 0xEE);
    const Color Orchid(0xDA, 0x70, 0xD6);
    const Color Fuchsia(0xFF, 0x00, 0xFF);
    const Color Magenta(0xFF, 0x00, 0xFF);
    const Color MediumOrchid(0xBA, 0x55, 0xD3);
    const Color MediumPurple(0x93, 0x70, 0xDB);
    const Color BlueViolet(0x8A, 0x2B, 0xE2);
    const Color DarkViolet(0x94, 0x00, 0xD3);
    const Color DarkOrchid(0x99, 0x32, 0xCC);
    const Color DarkMagenta(0x8B, 0x00, 0x8B);
    const Color Purple(0x80, 0x00, 0x80);
    const Color Indigo(0x4B, 0x00, 0x82);
    const Color SlateBlue(0x6A, 0x5A, 0xCD);
    const Color DarkSlateBlue(0x48, 0x3D, 0x8B);

    //Green colors
    const Color GreenYellow(0xAD, 0xFF, 0x2F);
    const Color Chartreuse(0x7F, 0xFF, 0x00);
    const Color LawnGreen(0x7C, 0xFC, 0x00);
    const Color Lime(0x00, 0xFF, 0x00);
    const Color LimeGreen(0x32, 0xCD, 0x32);
    const Color PaleGreen(0x98, 0xFB, 0x98);
    const Color LightGreen(0x90, 0xEE, 0x90);
    const Color MediumSpringGreen(0x00, 0xFA, 0x9A);
    const Color SpringGreen(0x00, 0xFF, 0x7F);
    const Color MediumSeaGreen(0x3C, 0xB3, 0x71);
    const Color SeaGreen(0x2E, 0x8B, 0x57);
    const Color ForestGreen(0x22, 0x8B, 0x22);
    const Color Green(0x00, 0x80, 0x00);
    const Color DarkGreen(0x00, 0x64, 0x00);
    const Color YellowGreen(0x9A, 0xCD, 0x32);
    const Color OliveDrab(0x6B, 0x8E, 0x23);
    const Color Olive(0x80, 0x80, 0x00);
    const Color DarkOliveGreen(0x55, 0x6B, 0x2F);
    const Color MediumAquamarine(0x66, 0xCD, 0xAA);
    const Color DarkSeaGreen(0x8F, 0xBC, 0x8F);
    const Color LightSeaGreen(0x20, 0xB2, 0xAA);
    const Color DarkCyan(0x00, 0x8B, 0x8B);
    const Color Teal(0x00, 0x80, 0x80);

    //Blue colors
    const Color Aqua(0x00, 0xFF, 0xFF);
    const Color Cyan(0x00, 0xFF, 0xFF);
    const Color LightCyan(0xE0, 0xFF, 0xFF);
    const Color PaleTurquoise(0xAF, 0xEE, 0xEE);
    const Color Aquamarine(0x7F, 0xFF, 0xD4);
    const Color Turquoise(0x40, 0xE0, 0xD0);
    const Color MediumTurquoise(0x48, 0xD1, 0xCC);
    const Color DarkTurquoise(0x00, 0xCE, 0xD1);
    const Color CadetBlue(0x5F, 0x9E, 0xA0);
    const Color SteelBlue(0x46, 0x82, 0xB4);
    const Color LightSteelBlue(0xB0, 0xC4, 0xDE);
    const Color PowderBlue(0xB0, 0xE0, 0xE6);
    const Color LightBlue(0xAD, 0xD8, 0xE6);
    const Color SkyBlue(0x87, 0xCE, 0xEB);
    const Color LightSkyBlue(0x87, 0xCE, 0xFA);
    const Color DeepSkyBlue(0x00, 0xBF, 0xFF);
    const Color DodgerBlue(0x1E, 0x90, 0xFF);
    const Color CornflowerBlue(0x64, 0x95, 0xED);
    const Color MediumSlateBlue(0x7B, 0x68, 0xEE);
    const Color RoyalBlue(0x41, 0x69, 0xE1);
    const Color Blue(0x00, 0x00, 0xFF);
    const Color MediumBlue(0x00, 0x00, 0xCD);
    const Color DarkBlue(0x00, 0x00, 0x8B);
    const Color Navy(0x00, 0x00, 0x80);
    const Color MidnightBlue(0x19, 0x19, 0x70);

    //Brown colors
    const Color Cornsilk(0xFF, 0xF8, 0xDC);
    const Color BlanchedAlmond(0xFF, 0xEB, 0xCD);
    const Color Bisque(0xFF, 0xE4, 0xC4);
    const Color NavajoWhite(0xFF, 0xDE, 0xAD);
    const Color Wheat(0xF5, 0xDE, 0xB3);
    const Color BurlyWood(0xDE, 0xB8, 0x87);
    const Color Tan(0xD2, 0xB4, 0x8C);
    const Color RosyBrown(0xBC, 0x8F, 0x8F);
    const Color SandyBrown(0xF4, 0xA4, 0x60);
    const Color Goldenrod(0xDA, 0xA5, 0x20);
    const Color DarkGoldenrod(0xB8, 0x86, 0x0B);
    const Color Peru(0xCD, 0x85, 0x3F);
    const Color Chocolate(0xD2, 0x69, 0x1E);
    const Color SaddleBrown(0x8B, 0x45, 0x13);
    const Color Sienna(0xA0, 0x52, 0x2D);
    const Color Brown(0xA5, 0x2A, 0x2A);
    const Color Maroon(0x80, 0x00, 0x00);

    //White colors
    const Color White(0xFF, 0xFF, 0xFF);
    const Color Snow(0xFF, 0xFA, 0xFA);
    const Color Honeydew(0xF0, 0xFF, 0xF0);
    const Color MintCream(0xF5, 0xFF, 0xFA);
    const Color Azure(0xF0, 0xFF, 0xFF);
    const Color AliceBlue(0xF0, 0xF8, 0xFF);
    const Color GhostWhite(0xF8, 0xF8, 0xFF);
    const Color WhiteSmoke(0xF5, 0xF5, 0xF5);
    const Color Seashell(0xFF, 0xF5, 0xEE);
    const Color Beige(0xF5, 0xF5, 0xDC);
    const Color OldLace(0xFD, 0xF5, 0xE6);
    const Color FloralWhite(0xFF, 0xFA, 0xF0);
    const Color Ivory(0xFF, 0xFF, 0xF0);
    const Color AntiqueWhite(0xFA, 0xEB, 0xD7);
    const Color Linen(0xFA, 0xF0, 0xE6);
    const Color LavenderBlush(0xFF, 0xF0, 0xF5);
    const Color MistyRose(0xFF, 0xE4, 0xE1);

    //Grey colors
    const Color Gainsboro(0xDC, 0xDC, 0xDC);
    const Color LightGrey(0xD3, 0xD3, 0xD3);
    const Color Silver(0xC0, 0xC0, 0xC0);
    const Color DarkGray(0xA9, 0xA9, 0xA9);
    const Color Gray(0x80, 0x80, 0x80);
    const Color DimGray(0x69, 0x69, 0x69);
    const Color LightSlateGray(0x77, 0x88, 0x99);
    const Color SlateGray(0x70, 0x80, 0x90);
    const Color DarkSlateGray(0x2F, 0x4F, 0x4F);
    const Color Black(0x00, 0x00, 0x00);

    // More Colors
    const Color Aubergine(0x2B, 0x0B, 0x30);
  }
}
