BEGIN TRANSACTION;
    CREATE TEMPORARY TABLE instances_backup (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        internal_id INTEGER,
        user_id VARCHAR(255),
        project_id VARCHAR(255),
        image_ref VARCHAR(255),
        kernel_id VARCHAR(255),
        ramdisk_id VARCHAR(255),
        launch_index INTEGER,
        key_name VARCHAR(255),
        key_data TEXT,
        power_state INTEGER,
        vm_state VARCHAR(255),
        memory_mb INTEGER,
        vcpus INTEGER,
        hostname VARCHAR(255),
        host VARCHAR(255),
        user_data TEXT,
        reservation_id VARCHAR(255),
        scheduled_at DATETIME,
        launched_at DATETIME,
        terminated_at DATETIME,
        display_name VARCHAR(255),
        display_description VARCHAR(255),
        availability_zone VARCHAR(255),
        locked BOOLEAN,
        os_type VARCHAR(255),
        launched_on TEXT,
        instance_type_id INTEGER,
        vm_mode VARCHAR(255),
        uuid VARCHAR(36),
        architecture VARCHAR(255),
        root_device_name VARCHAR(255),
        access_ip_v4 VARCHAR(255),
        access_ip_v6 VARCHAR(255),
        config_drive VARCHAR(255),
        task_state VARCHAR(255),
        default_ephemeral_device VARCHAR(255),
        default_swap_device VARCHAR(255),
        progress INTEGER,
        auto_disk_config BOOLEAN,
        shutdown_terminate BOOLEAN,
        disable_terminate BOOLEAN,
        root_gb INTEGER,
        ephemeral_gb INTEGER,
        cell_name VARCHAR(255),
        node VARCHAR(255),
        PRIMARY KEY (id)
    );

    INSERT INTO instances_backup
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               internal_id,
               user_id,
               project_id,
               image_ref,
               kernel_id,
               ramdisk_id,
               launch_index,
               key_name,
               key_data,
               power_state,
               vm_state,
               memory_mb,
               vcpus,
               hostname,
               host,
               user_data,
               reservation_id,
               scheduled_at,
               launched_at,
               terminated_at,
               display_name,
               display_description,
               availability_zone,
               locked,
               os_type,
               launched_on,
               instance_type_id,
               vm_mode,
               uuid,
               architecture,
               root_device_name,
               access_ip_v4,
               access_ip_v6,
               config_drive,
               task_state,
               default_ephemeral_device,
               default_swap_device,
               progress,
               auto_disk_config,
               shutdown_terminate,
               disable_terminate,
               root_gb,
               ephemeral_gb,
               cell_name,
               node
        FROM instances;

    DROP TABLE instances;

    CREATE TABLE instances (
        created_at DATETIME,
        updated_at DATETIME,
        deleted_at DATETIME,
        deleted BOOLEAN,
        id INTEGER NOT NULL,
        internal_id INTEGER,
        user_id VARCHAR(255),
        project_id VARCHAR(255),
        image_ref VARCHAR(255),
        kernel_id VARCHAR(255),
        ramdisk_id VARCHAR(255),
        server_name VARCHAR(255),
        launch_index INTEGER,
        key_name VARCHAR(255),
        key_data TEXT,
        power_state INTEGER,
        vm_state VARCHAR(255),
        memory_mb INTEGER,
        vcpus INTEGER,
        hostname VARCHAR(255),
        host VARCHAR(255),
        user_data TEXT,
        reservation_id VARCHAR(255),
        scheduled_at DATETIME,
        launched_at DATETIME,
        terminated_at DATETIME,
        display_name VARCHAR(255),
        display_description VARCHAR(255),
        availability_zone VARCHAR(255),
        locked BOOLEAN,
        os_type VARCHAR(255),
        launched_on TEXT,
        instance_type_id INTEGER,
        vm_mode VARCHAR(255),
        uuid VARCHAR(36),
        architecture VARCHAR(255),
        root_device_name VARCHAR(255),
        access_ip_v4 VARCHAR(255),
        access_ip_v6 VARCHAR(255),
        config_drive VARCHAR(255),
        task_state VARCHAR(255),
        default_ephemeral_device VARCHAR(255),
        default_swap_device VARCHAR(255),
        progress INTEGER,
        auto_disk_config BOOLEAN,
        shutdown_terminate BOOLEAN,
        disable_terminate BOOLEAN,
        root_gb INTEGER,
        ephemeral_gb INTEGER,
        cell_name VARCHAR(255),
        node VARCHAR(255),
        PRIMARY KEY (id)
    );

    CREATE INDEX instances_host_node_deleted_idx
        ON instances (host, node, deleted);

    CREATE INDEX instances_host_deleted_idx
        ON instances (host, deleted);

    CREATE INDEX instances_reservation_id_idx
        ON instances (reservation_id);

    CREATE INDEX instances_terminated_at_launched_at_idx
        ON instances (terminated_at, launched_at);

    CREATE INDEX instances_uuid_deleted_idx
        ON instances (uuid, deleted);

    CREATE INDEX instances_task_state_updated_at_idx
        ON instances (task_state, updated_at);

    INSERT INTO instances
        SELECT created_at,
               updated_at,
               deleted_at,
               deleted,
               id,
               internal_id,
               user_id,
               project_id,
               image_ref,
               kernel_id,
               ramdisk_id,
               hostname,
               launch_index,
               key_name,
               key_data,
               power_state,
               vm_state,
               memory_mb,
               vcpus,
               hostname,
               host,
               user_data,
               reservation_id,
               scheduled_at,
               launched_at,
               terminated_at,
               display_name,
               display_description,
               availability_zone,
               locked,
               os_type,
               launched_on,
               instance_type_id,
               vm_mode,
               uuid,
               architecture,
               root_device_name,
               access_ip_v4,
               access_ip_v6,
               config_drive,
               task_state,
               default_ephemeral_device,
               default_swap_device,
               progress,
               auto_disk_config,
               shutdown_terminate,
               disable_terminate,
               root_gb,
               ephemeral_gb,
               cell_name,
               node
        FROM instances_backup;

    DROP TABLE instances_backup;
COMMIT;
