/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_PLACES_MANAGER_H_
#define _NL_PLACES_MANAGER_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <netbook-launcher/nl-shell.h>

#define NL_TYPE_PLACES_MANAGER (nl_places_manager_get_type ())

#define NL_PLACES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_PLACES_MANAGER, NlPlacesManager))

#define NL_PLACES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_PLACES_MANAGER, NlPlacesManagerClass))

#define NL_IS_PLACES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_PLACES_MANAGER))

#define NL_IS_PLACES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_PLACES_MANAGER))

#define NL_PLACES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_PLACES_MANAGER, NlPlacesManagerClass))

typedef struct _NlPlacesManager        NlPlacesManager;
typedef struct _NlPlacesManagerClass   NlPlacesManagerClass;
typedef struct _NlPlacesManagerPrivate NlPlacesManagerPrivate;
 
struct _NlPlacesManager
{
  GObject        parent;	

  NlPlacesManagerPrivate *priv;
};

struct _NlPlacesManagerClass
{
  GObjectClass   parent_class;
};

GType                   nl_places_manager_get_type   (void) G_GNUC_CONST;

NlPlacesManager * nl_places_manager_new        (NlShell *s);

void nl_places_manager_append_source (NlPlacesManager *manager,
                                            ClutterActor          *source);

#endif /* _NL_PLACES_MANAGER_H_ */

