/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_CONTENT_VIEW_H_
#define _NL_CONTENT_VIEW_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/clutk.h>

#define NL_TYPE_CONTENT_VIEW (nl_content_view_get_type ())

#define NL_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_CONTENT_VIEW, NlContentView))

#define NL_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_CONTENT_VIEW, NlContentViewClass))

#define NL_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_CONTENT_VIEW))

#define NL_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_CONTENT_VIEW))

#define NL_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_CONTENT_VIEW, NlContentViewClass))

typedef struct _NlContentView        NlContentView;
typedef struct _NlContentViewClass   NlContentViewClass;
typedef struct _NlContentViewPrivate NlContentViewPrivate;
 
struct _NlContentView
{
  CtkBin        parent;	

  NlContentViewPrivate *priv;
};

struct _NlContentViewClass
{
  CtkBinClass   parent_class;

  /*< signals />*/
  void (*changed) (NlContentView *view, ClutterActor *new_child);
};

GType          nl_content_view_get_type   (void) G_GNUC_CONST;

ClutterActor * nl_content_view_new        (void);

void           nl_content_view_set_child (NlContentView *view,
                                                ClutterActor        *child);
ClutterActor * nl_content_view_get_child (NlContentView *view);

#endif /* _NL_CONTENT_VIEW_H_ */

