#TRUSTED 66ed52268cb3fdc00fe9f0208d166e2ee7bf2d787d2eafdaf408e66cfa5066b388cee524009f2af244a1af28ba9b60f59febae346377066e46ea98883e35f83da6d4d7231f7f9e8d57d5a06ba1d7ab0a45c2a6228b2dd4f4cc90484dd266e18797e7fa214c50b23de27ad54a6f3b212ffb826109b952b4d08274e00cb9ac1f6b0c3fee1807c946dcb75cee3541f778e18fd3e4e526f219e23f3ce7b8dcc7795df19e1117137b27b459b085921c20b1bbc38687155be76284eaf5ebff4b332b623638f80e6539ad81fb5493a20b95855efbbb549f643dc1447ea6944041c8356da5a8f9ed696b4806606d6ddff2eb3ca723cbfe74125aee179a3a9d7519539d41494f59a32288f65083b5103ac10df3c6169380756668eeb70ab834b6edc328a27481c8fa13ebe0bc06628fed5806b73e6f8fd9f06960a5ff3d8c0de43abc21fd0573c8e24320bdeea40f54170a80dcc2396f195c8a4ca6b98f84962f7dc9080fa1cf126c81f9da8c0e2cf765834e720f853b07040365987ad53051392e64b49a76836f0f61ddc902fff7030bc097b68d98c8d748d84776beb61707c2d917cf3a87fce542f8e29d65759f2af91b6b2b8b451f82d1bfdded4054cdfc7b5f552aac0b3f900dcf6789d7a79b5eb5aa8a5f5f48b8aa56879e1f451fdcd66b7fc9db916b4af328d73edb8668bafca8bced81d32f2fc67e32d7bbf9aecd4e99cce375fc
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15880);
 script_version ("1.2");
 name["english"] = "Hydra: PCNFS";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find PCNFS accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force PCNFS authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_udp_ports(640);
 script_dependencies("hydra_options.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = 640;
if (! get_udp_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "pcnfs";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*)? password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/pcnfs/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following PC-NFS accounts:\n' + report);
