#TRUSTED 810db6fc9b8d07559c5156b2530f8ed7a63b80aa9cc0280f26d3f0f40158814acdb2916925f24dcd13d84078311b9af59a3878400375eb3b706daab4c7460341e3aae673b905383767a35885a522370cc4be92a8e194aa4f12fb3b3379868319f44e27b9fcdb3b013e070665bce37eaed328ceb48ad360850ffd231eb81bf11a42bd9a6ea80d29b636df76c9b5773fab17bed93ee97bdcb57432f7b687bee7292d9a50e8d4d992aef071a705d7351c68935f862017e1b455e10283501993dbdceabea10ae92e47d745613bf1b012e5c148551e99729d0919e978a76786d16a350914ed9c8ef3f8dc4e89b8b79c698f88edc398c1ac70f994d7f601586c36b9b78be3fa14eaf9241b8b27eab610f3cfa4e70d618507ab94f42a82c59e3406d761d8005bb19ab5d3e4ed3953a569517d92981d62c060a25668dd3c9452f50e761d6ddd5f455def1fef23325dd469d5466972c7279e8c5c4b7aac844621f888ae31388fc17382f775723fc190664c1cbd7a72e32a1fba201fb2f991139869a812bd36d3319319cf5239c870f236f5b7dc42b21ddb79e51b2a5b6971c5d3012a956543bf4ea78d8b66b7dc8038e8085ef0395966b477399a34aab4e7aab13f72110fb7bd962fc5e0b88f8eb1da8d2f71bba4c6a6415eb52ee40781ab98bc7e84573dcb87730cb71645cd9392c5c049865aed4f6aae349e8df0724dbcf5777e8bb674
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15878);
 script_version ("1.2");
 name["english"] = "Hydra: MS SQL";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find MS SQL passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force MS SQL authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/mssql", 1433);
 script_dependencies("hydra_options.nasl", "find_service.nes", "mssqlserver_detect.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/mssql");
if (! port) port = 1433;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "mssql";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/mssql/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following MS SQL accounts:\n' + report);
