#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# It is released under the GNU Public Licence.
#
#

if(description)
{
 script_id(14772);
 script_version ("$Revision: 1.9 $");
 
 name["english"] = "Try very hard to identify what runs on common ports";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin is a complement of find_service.nes
It tries to identify common services that were missed 
because of a network glitch

Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Identifies common services (second chance)";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO); 
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Service detection";

 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "find_service_3digits.nasl", 
  "apache_SSL_complain.nasl");
 exit(0);
}

include("misc_func.inc");
include("global_settings.inc");
# This script may be too slow: currently, we enable it only in "experimental"
# or "thorough" modes
if (! experimental_scripts && ! thorough_tests) exit(0);

# Should I add 280 (http-mgmt)?

ports = make_list(4, 19, 21, 22, 23, 25, 37, 70, 79, 80, 81, 88, 98, 
109, 110, 113, 119, 143, 220, 221, 593, 873, 901, 1080,  1085, 1109, 
1381, 2309, 2401, 3128, 3306, 5000, 5432, 8000, 8080, 8081, 
8090, 8383, 9090);
sslports = make_list(261, 443, 448, 465, 563, 585, 614, 636, 684, 902, 989, 
990, 992, 993, 994, 995, 1241, 2381, 2478, 2479, 2482, 2484, 2679, 3077, 
3078, 3269, 3471, 5007, 7135, 8443, 9443, 10000, 19201);

probes = make_list("", 'GET / HTTP/1.0\r\n\r\n', 'HELP\r\n\r\n');

foreach p (sslports)
{
  if (get_port_state(p))
  {
    k = "Transports/TCP/" + p;
    t = get_kb_item(k);
    if (t <= 1)
    {
      debug_print('Testing ', p, ' for SSL/TLS\n');
      for (t = ENCAPS_SSLv2; t <= ENCAPS_TLSv1; t ++)
      {
        s = open_sock_tcp(p, transport: t);
        if (s)
        {
          debug_print('Found SSL port: ', p, '\tT: ', t, '\n');
          if (defined_func("replace_kb_item"))
            replace_kb_item(name: k, value: t);
          else
            replace_kb_item(name: k, value: t);
          close(s);
          break;
        }
      }
    }
  }
}

foreach p (make_list(ports, sslports))
{
 if (get_port_state(p) && service_is_unknown(port: p))
 {
  debug_print("Testing ", p, "\n");
  b = get_unknown_banner(port: p, dontfetch: 1);
  if (! b)
  {
   foreach d (probes)
   {
    s = open_sock_tcp(p);
    if (s)
    {
     if (d) send(socket: s, data: d);
     b = recv(socket: s, length: 4096);
     close(s);
    }
    if (b) break;
   }
  }
  if (b)
  {
    if (d == '') 
     replace_or_set_kb_item(name: 'FindService/tcp/'+port+'/spontaneous', value: b);
    else if ('GET' >< d)
     replace_or_set_kb_item(name: 'FindService/tcp/'+port+'/get_http', value: b);
    else
     replace_or_set_kb_item(name: 'FindService/tcp/'+port+'/help', value: b);

    bl = tolower(b);

    if (b =~ "^[0-9]{3}[ -]")
    {
     if ("SMTP" >< b || "mail " >< bl)
      report_service(port: p, svc: "smtp", banner: b);
     else if ("ftp" >< bl)
      report_service(port: p, svc: "ftp", banner: b);
     else
      register_service(port: p, proto: "three_digits");
    }

    if (b[0] == '0xFF' && ord(b[1]) >= 251 && ord(b[1]) <= 254)
     report_service(port: p, svc: "telnet", banner: b);
    else if (b =~ "^HTTP/1\.[01] [0-9]{3}")
    {
     report_service(port: p, svc: "www", banner: b);
     if ("HTTP/1.1 502" >< b || egrep(string: b, pattern: "^Via:"))
      report_service(port: p, svc: "proxy", banner: b);
    }

    if (substr(b, 0, 2) == "+OK")
     report_service(port: p, svc: "pop3", banner: b);

    if (substr(bl, 0, 7) == "finger:")
     report_service(port: p, svc: "finger", banner: b);

    if (service_is_unknown(port: p))
    {
      register_service(port: p, proto: 'unknown');
      set_unknown_banner(port: p, banner: b);
    }
  }
 }
}
