#TRUSTED 227f749c10c5c37e7110ff02cfd3d3f119ac71e4416dcff622f58343372515f537c664f537aa3c017ff67f72936abda3d684502830b22b73e8b56f88f39627d8895de2ab9c2e5b2e7a65c3981c14af7e52ab8aae4ff77df7e6790b326e14e5045b3e353bbe0b1f1987e5b3b21a2ae8beed73f34281b17b56daa54088964d24d50a5789f5c2387dda3c8b3b3c61ed13a1b27ee3595e66818c72c71bc7debc28754be8e789dbdd56b9df45f2fbbb9a635b119dfa4d4b52d6bf65cd4e7d6ed3f2c69be6ea62d0a60f1d81ea353125cd5c57f31b300066f441c3338c78c23c43c1db79e67a4cf6eeca152809438f6296c23038de2d49324ef3b4f7a20eb7f53526e4c451159e8b9ea5f3bc473037427e2bb9da629d9d19843d698d70a533a3a68c2d1b9dea6f979052b87a174f766d478ed5718a4358da166ff2ce4688af7b52e39c5cb760f6f8b9d1a94869194a48970f084abce0442c720a510e020da82678e9f1f687dd6554d7ae21c5648f8d92ea8d0c0075e987d6296b40a126436fd290b67087857b2434657fb30b08cab999e386742baf6d05fe4cc755059893614e3bef0d47410f5c8c40cbe5875c8e08155a7f04a4af094bd7c7560c46fce543af0ef405b6c8a3260702256f71020716cb62f14de6d805e3780250fade30c2e2ad8ee88a4725e4f6e823262e6de363d0c28d0893e14465eec8160ce3a972df08faca5862
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15877);
 script_version ("1.1");
 name["english"] = "Hydra: LDAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find LDAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force LDAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "DN : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ldap", 389);
 # find_service does not detect LDAP yet, so we rely upon amap
 # However find_services will detect the SSL layer for LDAPS
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "amap.nasl", "external_svc_ident.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ldap");
if (! port) port = 389;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

dn = script_get_preference("DN : ");
if (! dn) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ldap";
argv[i++] = dn;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ldap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the LDAP server:\n' + report);
