#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  This script is released under the GNU GPL v2

if(description)
{
 script_id(14771);
 script_version("$Revision: 1.2 $");
 
 name["english"] = "Apache <= 1.3.31 htpasswd local overflow";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host appears to be running a version of Apache which is older 
than 1.3.32.

There is a local buffer overflow in htpasswd command in this version, 
which may allow a local user to gain the privileges of the httpd process.

*** Note that Nessus solely relied on the version number
*** of the remote server to issue this warning. This might
*** be a false positive

See also : http://xforce.iss.net/xforce/xfdb/17413
Solution : Upgrade to Apache 1.3.32 when available
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of Apache";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 
 family["english"] = "Misc.";
 family["francais"] = "Divers";
 script_family(english:family["english"], francais:family["francais"]);
 if ( ! defined_func("bn_random") )
	script_dependencie("http_version.nasl");
 else
 	script_dependencie("http_version.nasl", "macosx_version.nasl");
 script_require_keys("www/apache");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("backport.inc");

port = get_http_port(default:80);

if(get_port_state(port))
{
banner = get_http_banner(port: port);
if(!banner)exit(0);
banner = get_backport_banner(banner:banner);
 
serv = strstr(banner, "Server:");
if(!serv)exit(0);

if(ereg(pattern:"^Server:.*Apache(-AdvancedExtranetServer)?/(1\.([0-2]\.[0-9]|3\.([0-9][^0-9]|[0-1][0-9]|2[0-9]|3[0-1])))", string:serv))
 {
   security_hole(port);
 } 
}
