#
# (C) Tenable Network Security
#
if(description)
{
 script_id(11989);
 script_version("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0904");
 script_bugtraq_id(9409);
 name["english"] = "Exchange Privilege Escalation (832759)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an unpatched version of Microsoft Exchange which
may allow an attacker with a valid Exchange account to access another user's
mailbox using Outlook for Web Access

Solution : http://www.microsoft.com/technet/security/bulletin/ms04-002.asp
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for MS Hotfix Q832759";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_full_access.nasl",
		     "smb_reg_service_pack_W2K.nasl","smtpserver_detect.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/registry_full_access","SMB/WindowsVersion",
		     "SMTP/microsoft_esmtp_5");

 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");

#check for server:
key = "SYSTEM\CurrentControlSet\Control\ProductOptions";
item = "ProductType";

value = registry_get_sz(key:key, item:item);

if( (value == "LanmanNT") || (value == "ServerNT"))
{

 access = get_kb_item("SMB/registry_full_access");
 if(!access)exit(0);


 key = "SOFTWARE\Microsoft\Exchange\Setup";
 item = "ServicePackBuild";

 value = registry_get_dword(key:key, item:item);
 if(!value) exit(0);

 key = "SOFTWARE\Microsoft\Updates\Exchange Server 2003\SP1\Q832759";
 item = "Comments";
 value = registry_get_sz(key:key, item:item);
 if(!value)security_hole(kb_smb_transport());
}

