/*
 * Copyright (c) 2015, 2016 Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _NGS_TIME_SOCKET_EVENTS_H_
#define _NGS_TIME_SOCKET_EVENTS_H_

#include <vector>
#include <list>
#include <ngs/thread.h>

// Surpressing numerous warnings generated by libevent on Windows.
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable: 4005)
#endif // WIN32
#include <event.h> // libevent
#ifdef WIN32
#pragma warning(pop)
#endif // WIN32

namespace ngs
{

class Connection_acceptor_interface;

class Time_and_socket_events
{
public:
  Time_and_socket_events();
  ~Time_and_socket_events();

  bool listen(my_socket s, boost::function<void (Connection_acceptor_interface &)> callback);

  void add_timer(const std::size_t delay_ms, boost::function<bool ()> callback);
  void loop();
  void break_loop();

private:
  static void timeout_call(int sock, short which, void *arg);
  static void socket_data_avaiable(int sock, short which, void *arg);

  struct Timer_data;
  struct Socket_data;
  struct event_base *m_evbase;
  std::vector<Socket_data *> m_socket_events;
  std::vector<Timer_data*> m_timer_events;
  Mutex m_timers_mutex;
};

} // namespace ngs

#endif // _NGS_TIME_SOCKET_EVENTS_H_
