/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import logformat.slog2.TraceName;

public class ConvertorConst {
    public static final String CLOG2_TO_SLOG2 = "  CLOG-2  -->  SLOG-2  ";
    public static final String CLOG_TO_SLOG2 = "  CLOG    -->  SLOG-2  ";
    public static final String RLOG_TO_SLOG2 = "  RLOG    -->  SLOG-2  ";
    public static final String UTE_TO_SLOG2 = "  UTE     -->  SLOG-2  ";
    private static final String CLOG2_TO_SLOG2_JAR = "clog2TOslog2.jar";
    private static final String CLOG_TO_SLOG2_JAR = "clogTOslog2.jar";
    private static final String RLOG_TO_SLOG2_JAR = "traceTOslog2.jar";
    private static final String UTE_TO_SLOG2_JAR = "traceTOslog2.jar";
    private static String FileSeparator = "/";
    private static String PathSeparator = ":";
    private static String JavaHome = null;
    private static String ClassPath = null;
    private static final String JVM = "java";
    private static String CLOG2_TraceLibPath = "";
    private static String CLOG_TraceLibPath = "";
    private static String RLOG_TraceLibPath = ".:../trace_rlog/lib";
    private static String UTE_TraceLibPath = ".:/usr/lpp/ppe.perf/lib";

    public static String getDefaultConvertor(String string) {
        String string2 = TraceName.getLogFormatExtension(string);
        if (string2.equals(".clog2")) {
            return CLOG2_TO_SLOG2;
        }
        if (string2.equals(".clog")) {
            return CLOG_TO_SLOG2;
        }
        if (string2.equals(".rlog")) {
            return RLOG_TO_SLOG2;
        }
        if (string2.equals(".ute")) {
            return UTE_TO_SLOG2;
        }
        return "";
    }

    public static String getDefaultSLOG2Name(String string) {
        return TraceName.getDefaultSLOG2Name(string);
    }

    public static String getDefaultJarName(String string) {
        if (string.equals(CLOG2_TO_SLOG2)) {
            return CLOG2_TO_SLOG2_JAR;
        }
        if (string.equals(CLOG_TO_SLOG2)) {
            return CLOG_TO_SLOG2_JAR;
        }
        if (string.equals(RLOG_TO_SLOG2)) {
            return "traceTOslog2.jar";
        }
        if (string.equals(UTE_TO_SLOG2)) {
            return "traceTOslog2.jar";
        }
        return "";
    }

    public static String getDefaultJarPath(String string, String string2) {
        if (string != null && string.length() > 0) {
            return string + FileSeparator + ConvertorConst.getDefaultJarName(string2);
        }
        return ConvertorConst.getDefaultJarName(string2);
    }

    public static String getDefaultTraceLibPath(String string, String string2) {
        if (string.equals(CLOG2_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(string2, CLOG2_TraceLibPath);
        }
        if (string.equals(CLOG_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(string2, CLOG_TraceLibPath);
        }
        if (string.equals(RLOG_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(string2, RLOG_TraceLibPath);
        }
        if (string.equals(UTE_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(string2, UTE_TraceLibPath);
        }
        return ".";
    }

    private static boolean replaceCharOfTraceLibPaths(char c, char c2) {
        if (c != c2) {
            if (CLOG2_TraceLibPath != null) {
                CLOG2_TraceLibPath = CLOG2_TraceLibPath.replace(c, c2);
            }
            if (CLOG_TraceLibPath != null) {
                CLOG_TraceLibPath = CLOG_TraceLibPath.replace(c, c2);
            }
            if (RLOG_TraceLibPath != null) {
                RLOG_TraceLibPath = RLOG_TraceLibPath.replace(c, c2);
            }
            if (UTE_TraceLibPath != null) {
                UTE_TraceLibPath = UTE_TraceLibPath.replace(c, c2);
            }
            return true;
        }
        return false;
    }

    public static void initializeSystemProperties() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("file.separator");
        if (ConvertorConst.replaceCharOfTraceLibPaths(FileSeparator.charAt(0), string.charAt(0))) {
            FileSeparator = string;
        }
        string = properties.getProperty("path.separator");
        if (ConvertorConst.replaceCharOfTraceLibPaths(PathSeparator.charAt(0), string.charAt(0))) {
            PathSeparator = string;
        }
        JavaHome = properties.getProperty("java.home");
        ClassPath = properties.getProperty("java.class.path");
    }

    public static String getDefaultPathToJVM() {
        String string = JavaHome + FileSeparator + "bin" + FileSeparator + JVM;
        File file = new File(string);
        if (!FileSeparator.equals("/") && !string.endsWith(".exe")) {
            string = string + ".exe";
            file = new File(string);
        }
        if (!file.exists()) {
            string = JVM;
        }
        return string;
    }

    public static String getDefaultPathToJarDir() {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(ClassPath, PathSeparator);
        while (stringTokenizer.hasMoreTokens() && string == null) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.lastIndexOf(FileSeparator);
            if (n < 0) continue;
            string = string2.substring(0, n);
        }
        return string;
    }

    private static String updateLibraryPath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, PathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (new File(string3).isAbsolute()) {
                stringBuffer.append(string3);
            } else if (string3.equals(".")) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string + FileSeparator + string3);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(PathSeparator);
        }
        return stringBuffer.toString();
    }
}

