#!/bin/sh
#
# Script to generate 50pl-locale file for mozilla-firefox-locale-pl
# (should be run by hand every time new upsrteam version is released).
#
# Robert Luberda <robert@debian.org>, 2004
# 


set -e

[ ! -d debian ] && [ -d ../debian ] && cd ..

CURDIR=`pwd`;

loc_file="$CURDIR/debian/50pl-locale.new"  # generated file
UPDDIR="$CURDIR/debian/update-50pl-locale" # temporary directory

rm -rf "$UPDDIR" "$loc_file"
mkdir -p "$UPDDIR"
find "$CURDIR" -type f -iname '*.xpi' -maxdepth 1  -exec unzip "{}" -d "$UPDDIR" \;

for jar in pl-PL; do
	echo "Processing $jar ..."
	cd "$UPDDIR/chrome"
	mkdir unzipped
	unzip -d unzipped "$jar.jar" > /dev/null
	cd unzipped
	[ -d content ] && d=2 || d=3
	find ./ -mindepth "$d" -maxdepth "$d" -type d -print | while read LINE ; do
		echo `echo "$LINE" | sed -e 's/^\.\/\([^\/]*\)\(.*\)/\1,install,url,jar:resource:\/chrome\/'"$jar.jar"'!\/\1\2\//g'` >> "$loc_file"
	done
	cd .. && rm -rf unzipped
done

rm -rf "$UPDDIR" 

