/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from wayland.xml
 * To regenerate, run the “refresh-wayland-wrapper” target.
 */

#include "wayland_wrapper.h"

#include <boost/throw_exception.hpp>
#include <boost/exception/diagnostic_information.hpp>

#include <wayland-server-core.h>

#include "mir/log.h"

namespace mir
{
namespace frontend
{
namespace wayland
{
extern struct wl_interface const wl_buffer_interface_data;
extern struct wl_interface const wl_callback_interface_data;
extern struct wl_interface const wl_compositor_interface_data;
extern struct wl_interface const wl_data_device_interface_data;
extern struct wl_interface const wl_data_device_manager_interface_data;
extern struct wl_interface const wl_data_offer_interface_data;
extern struct wl_interface const wl_data_source_interface_data;
extern struct wl_interface const wl_keyboard_interface_data;
extern struct wl_interface const wl_output_interface_data;
extern struct wl_interface const wl_pointer_interface_data;
extern struct wl_interface const wl_region_interface_data;
extern struct wl_interface const wl_seat_interface_data;
extern struct wl_interface const wl_shell_interface_data;
extern struct wl_interface const wl_shell_surface_interface_data;
extern struct wl_interface const wl_shm_interface_data;
extern struct wl_interface const wl_shm_pool_interface_data;
extern struct wl_interface const wl_subcompositor_interface_data;
extern struct wl_interface const wl_subsurface_interface_data;
extern struct wl_interface const wl_surface_interface_data;
extern struct wl_interface const wl_touch_interface_data;
}
}
}

namespace mfw = mir::frontend::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// Callback

mfw::Callback* mfw::Callback::from(struct wl_resource* resource)
{
    return static_cast<Callback*>(wl_resource_get_user_data(resource));
}

struct mfw::Callback::Thunks
{
    static struct wl_message const event_messages[];
};

mfw::Callback::Callback(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_callback_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
}

void mfw::Callback::send_done_event(uint32_t callback_data) const
{
    wl_resource_post_event(resource, Opcode::done, callback_data);
}

void mfw::Callback::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mfw::Callback::Thunks::event_messages[] {
    {"done", "u", all_null_types}};

// Compositor

mfw::Compositor* mfw::Compositor::from(struct wl_resource* resource)
{
    return static_cast<Compositor*>(wl_resource_get_user_data(resource));
}

struct mfw::Compositor::Thunks
{
    static void create_surface_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id)
    {
        auto me = static_cast<Compositor*>(wl_resource_get_user_data(resource));
        try
        {
            me->create_surface(client, resource, id);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Compositor::create_surface() request");
        }
    }

    static void create_region_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id)
    {
        auto me = static_cast<Compositor*>(wl_resource_get_user_data(resource));
        try
        {
            me->create_region(client, resource, id);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Compositor::create_region() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Compositor*>(data);
        auto resource = wl_resource_create(client, &wl_compositor_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Compositor::bind() request");
        }
    }

    static struct wl_interface const* create_surface_types[];
    static struct wl_interface const* create_region_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::Compositor::Compositor(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_compositor_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_compositor interface"}));
    }
}

mfw::Compositor::~Compositor()
{
    wl_global_destroy(global);
}

void mfw::Compositor::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Compositor::Thunks::create_surface_types[] {
    &wl_surface_interface_data};

struct wl_interface const* mfw::Compositor::Thunks::create_region_types[] {
    &wl_region_interface_data};

struct wl_message const mfw::Compositor::Thunks::request_messages[] {
    {"create_surface", "n", create_surface_types},
    {"create_region", "n", create_region_types}};

void const* mfw::Compositor::Thunks::request_vtable[] {
    (void*)Thunks::create_surface_thunk,
    (void*)Thunks::create_region_thunk};

// ShmPool

mfw::ShmPool* mfw::ShmPool::from(struct wl_resource* resource)
{
    return static_cast<ShmPool*>(wl_resource_get_user_data(resource));
}

struct mfw::ShmPool::Thunks
{
    static void create_buffer_thunk(struct wl_client*, struct wl_resource* resource, uint32_t id, int32_t offset, int32_t width, int32_t height, int32_t stride, uint32_t format)
    {
        auto me = static_cast<ShmPool*>(wl_resource_get_user_data(resource));
        try
        {
            me->create_buffer(id, offset, width, height, stride, format);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShmPool::create_buffer() request");
        }
    }

    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<ShmPool*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShmPool::destroy() request");
        }
    }

    static void resize_thunk(struct wl_client*, struct wl_resource* resource, int32_t size)
    {
        auto me = static_cast<ShmPool*>(wl_resource_get_user_data(resource));
        try
        {
            me->resize(size);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShmPool::resize() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ShmPool*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* create_buffer_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::ShmPool::ShmPool(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_shm_pool_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::ShmPool::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::ShmPool::Thunks::create_buffer_types[] {
    &wl_buffer_interface_data,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};

struct wl_message const mfw::ShmPool::Thunks::request_messages[] {
    {"create_buffer", "niiiiu", create_buffer_types},
    {"destroy", "", all_null_types},
    {"resize", "i", all_null_types}};

void const* mfw::ShmPool::Thunks::request_vtable[] {
    (void*)Thunks::create_buffer_thunk,
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::resize_thunk};

// Shm

mfw::Shm* mfw::Shm::from(struct wl_resource* resource)
{
    return static_cast<Shm*>(wl_resource_get_user_data(resource));
}

struct mfw::Shm::Thunks
{
    static void create_pool_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, int32_t fd, int32_t size)
    {
        auto me = static_cast<Shm*>(wl_resource_get_user_data(resource));
        mir::Fd fd_resolved{fd};
        try
        {
            me->create_pool(client, resource, id, fd_resolved, size);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Shm::create_pool() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Shm*>(data);
        auto resource = wl_resource_create(client, &wl_shm_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Shm::bind() request");
        }
    }

    static struct wl_interface const* create_pool_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Shm::Shm(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_shm_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_shm interface"}));
    }
}

mfw::Shm::~Shm()
{
    wl_global_destroy(global);
}

void mfw::Shm::send_format_event(struct wl_resource* resource, uint32_t format) const
{
    wl_resource_post_event(resource, Opcode::format, format);
}

void mfw::Shm::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Shm::Thunks::create_pool_types[] {
    &wl_shm_pool_interface_data,
    nullptr,
    nullptr};

struct wl_message const mfw::Shm::Thunks::request_messages[] {
    {"create_pool", "nhi", create_pool_types}};

struct wl_message const mfw::Shm::Thunks::event_messages[] {
    {"format", "u", all_null_types}};

void const* mfw::Shm::Thunks::request_vtable[] {
    (void*)Thunks::create_pool_thunk};

// Buffer

mfw::Buffer* mfw::Buffer::from(struct wl_resource* resource)
{
    return static_cast<Buffer*>(wl_resource_get_user_data(resource));
}

struct mfw::Buffer::Thunks
{
    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Buffer*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Buffer::destroy() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Buffer*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Buffer::Buffer(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_buffer_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Buffer::send_release_event() const
{
    wl_resource_post_event(resource, Opcode::release);
}

void mfw::Buffer::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mfw::Buffer::Thunks::request_messages[] {
    {"destroy", "", all_null_types}};

struct wl_message const mfw::Buffer::Thunks::event_messages[] {
    {"release", "", all_null_types}};

void const* mfw::Buffer::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk};

// DataOffer

mfw::DataOffer* mfw::DataOffer::from(struct wl_resource* resource)
{
    return static_cast<DataOffer*>(wl_resource_get_user_data(resource));
}

struct mfw::DataOffer::Thunks
{
    static void accept_thunk(struct wl_client*, struct wl_resource* resource, uint32_t serial, char const* mime_type)
    {
        auto me = static_cast<DataOffer*>(wl_resource_get_user_data(resource));
        std::experimental::optional<std::string> mime_type_resolved;
        if (mime_type != nullptr)
        {
            mime_type_resolved = {mime_type};
        }
        try
        {
            me->accept(serial, mime_type_resolved);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataOffer::accept() request");
        }
    }

    static void receive_thunk(struct wl_client*, struct wl_resource* resource, char const* mime_type, int32_t fd)
    {
        auto me = static_cast<DataOffer*>(wl_resource_get_user_data(resource));
        mir::Fd fd_resolved{fd};
        try
        {
            me->receive(mime_type, fd_resolved);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataOffer::receive() request");
        }
    }

    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<DataOffer*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataOffer::destroy() request");
        }
    }

    static void finish_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<DataOffer*>(wl_resource_get_user_data(resource));
        try
        {
            me->finish();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataOffer::finish() request");
        }
    }

    static void set_actions_thunk(struct wl_client*, struct wl_resource* resource, uint32_t dnd_actions, uint32_t preferred_action)
    {
        auto me = static_cast<DataOffer*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_actions(dnd_actions, preferred_action);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataOffer::set_actions() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<DataOffer*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::DataOffer::DataOffer(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_data_offer_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::DataOffer::send_offer_event(std::string const& mime_type) const
{
    const char* mime_type_resolved = mime_type.c_str();
    wl_resource_post_event(resource, Opcode::offer, mime_type_resolved);
}

bool mfw::DataOffer::version_supports_source_actions()
{
    return wl_resource_get_version(resource) >= 3;
}

void mfw::DataOffer::send_source_actions_event(uint32_t source_actions) const
{
    wl_resource_post_event(resource, Opcode::source_actions, source_actions);
}

bool mfw::DataOffer::version_supports_action()
{
    return wl_resource_get_version(resource) >= 3;
}

void mfw::DataOffer::send_action_event(uint32_t dnd_action) const
{
    wl_resource_post_event(resource, Opcode::action, dnd_action);
}

void mfw::DataOffer::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mfw::DataOffer::Thunks::request_messages[] {
    {"accept", "u?s", all_null_types},
    {"receive", "sh", all_null_types},
    {"destroy", "", all_null_types},
    {"finish", "3", all_null_types},
    {"set_actions", "3uu", all_null_types}};

struct wl_message const mfw::DataOffer::Thunks::event_messages[] {
    {"offer", "s", all_null_types},
    {"source_actions", "3u", all_null_types},
    {"action", "3u", all_null_types}};

void const* mfw::DataOffer::Thunks::request_vtable[] {
    (void*)Thunks::accept_thunk,
    (void*)Thunks::receive_thunk,
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::finish_thunk,
    (void*)Thunks::set_actions_thunk};

// DataSource

mfw::DataSource* mfw::DataSource::from(struct wl_resource* resource)
{
    return static_cast<DataSource*>(wl_resource_get_user_data(resource));
}

struct mfw::DataSource::Thunks
{
    static void offer_thunk(struct wl_client*, struct wl_resource* resource, char const* mime_type)
    {
        auto me = static_cast<DataSource*>(wl_resource_get_user_data(resource));
        try
        {
            me->offer(mime_type);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataSource::offer() request");
        }
    }

    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<DataSource*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataSource::destroy() request");
        }
    }

    static void set_actions_thunk(struct wl_client*, struct wl_resource* resource, uint32_t dnd_actions)
    {
        auto me = static_cast<DataSource*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_actions(dnd_actions);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataSource::set_actions() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<DataSource*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::DataSource::DataSource(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_data_source_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::DataSource::send_target_event(std::experimental::optional<std::string> const& mime_type) const
{
    const char* mime_type_resolved = nullptr;
    if (mime_type)
    {
        mime_type_resolved = mime_type.value().c_str();
    }
    wl_resource_post_event(resource, Opcode::target, mime_type_resolved);
}

void mfw::DataSource::send_send_event(std::string const& mime_type, mir::Fd fd) const
{
    const char* mime_type_resolved = mime_type.c_str();
    int32_t fd_resolved{fd};
    wl_resource_post_event(resource, Opcode::send, mime_type_resolved, fd_resolved);
}

void mfw::DataSource::send_cancelled_event() const
{
    wl_resource_post_event(resource, Opcode::cancelled);
}

bool mfw::DataSource::version_supports_dnd_drop_performed()
{
    return wl_resource_get_version(resource) >= 3;
}

void mfw::DataSource::send_dnd_drop_performed_event() const
{
    wl_resource_post_event(resource, Opcode::dnd_drop_performed);
}

bool mfw::DataSource::version_supports_dnd_finished()
{
    return wl_resource_get_version(resource) >= 3;
}

void mfw::DataSource::send_dnd_finished_event() const
{
    wl_resource_post_event(resource, Opcode::dnd_finished);
}

bool mfw::DataSource::version_supports_action()
{
    return wl_resource_get_version(resource) >= 3;
}

void mfw::DataSource::send_action_event(uint32_t dnd_action) const
{
    wl_resource_post_event(resource, Opcode::action, dnd_action);
}

void mfw::DataSource::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mfw::DataSource::Thunks::request_messages[] {
    {"offer", "s", all_null_types},
    {"destroy", "", all_null_types},
    {"set_actions", "3u", all_null_types}};

struct wl_message const mfw::DataSource::Thunks::event_messages[] {
    {"target", "?s", all_null_types},
    {"send", "sh", all_null_types},
    {"cancelled", "", all_null_types},
    {"dnd_drop_performed", "3", all_null_types},
    {"dnd_finished", "3", all_null_types},
    {"action", "3u", all_null_types}};

void const* mfw::DataSource::Thunks::request_vtable[] {
    (void*)Thunks::offer_thunk,
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::set_actions_thunk};

// DataDevice

mfw::DataDevice* mfw::DataDevice::from(struct wl_resource* resource)
{
    return static_cast<DataDevice*>(wl_resource_get_user_data(resource));
}

struct mfw::DataDevice::Thunks
{
    static void start_drag_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* source, struct wl_resource* origin, struct wl_resource* icon, uint32_t serial)
    {
        auto me = static_cast<DataDevice*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> source_resolved;
        if (source != nullptr)
        {
            source_resolved = {source};
        }
        std::experimental::optional<struct wl_resource*> icon_resolved;
        if (icon != nullptr)
        {
            icon_resolved = {icon};
        }
        try
        {
            me->start_drag(source_resolved, origin, icon_resolved, serial);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataDevice::start_drag() request");
        }
    }

    static void set_selection_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* source, uint32_t serial)
    {
        auto me = static_cast<DataDevice*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> source_resolved;
        if (source != nullptr)
        {
            source_resolved = {source};
        }
        try
        {
            me->set_selection(source_resolved, serial);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataDevice::set_selection() request");
        }
    }

    static void release_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<DataDevice*>(wl_resource_get_user_data(resource));
        try
        {
            me->release();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataDevice::release() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<DataDevice*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* start_drag_types[];
    static struct wl_interface const* set_selection_types[];
    static struct wl_interface const* data_offer_types[];
    static struct wl_interface const* enter_types[];
    static struct wl_interface const* selection_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::DataDevice::DataDevice(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_data_device_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::DataDevice::send_data_offer_event(struct wl_resource* id) const
{
    wl_resource_post_event(resource, Opcode::data_offer, id);
}

void mfw::DataDevice::send_enter_event(uint32_t serial, struct wl_resource* surface, double x, double y, std::experimental::optional<struct wl_resource*> const& id) const
{
    wl_fixed_t x_resolved{wl_fixed_from_double(x)};
    wl_fixed_t y_resolved{wl_fixed_from_double(y)};
    struct wl_resource* id_resolved = nullptr;
    if (id)
    {
        id_resolved = id.value();
    }
    wl_resource_post_event(resource, Opcode::enter, serial, surface, x_resolved, y_resolved, id_resolved);
}

void mfw::DataDevice::send_leave_event() const
{
    wl_resource_post_event(resource, Opcode::leave);
}

void mfw::DataDevice::send_motion_event(uint32_t time, double x, double y) const
{
    wl_fixed_t x_resolved{wl_fixed_from_double(x)};
    wl_fixed_t y_resolved{wl_fixed_from_double(y)};
    wl_resource_post_event(resource, Opcode::motion, time, x_resolved, y_resolved);
}

void mfw::DataDevice::send_drop_event() const
{
    wl_resource_post_event(resource, Opcode::drop);
}

void mfw::DataDevice::send_selection_event(std::experimental::optional<struct wl_resource*> const& id) const
{
    struct wl_resource* id_resolved = nullptr;
    if (id)
    {
        id_resolved = id.value();
    }
    wl_resource_post_event(resource, Opcode::selection, id_resolved);
}

void mfw::DataDevice::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::DataDevice::Thunks::start_drag_types[] {
    &wl_data_source_interface_data,
    &wl_surface_interface_data,
    &wl_surface_interface_data,
    nullptr};

struct wl_interface const* mfw::DataDevice::Thunks::set_selection_types[] {
    &wl_data_source_interface_data,
    nullptr};

struct wl_interface const* mfw::DataDevice::Thunks::data_offer_types[] {
    &wl_data_offer_interface_data};

struct wl_interface const* mfw::DataDevice::Thunks::enter_types[] {
    nullptr,
    &wl_surface_interface_data,
    nullptr,
    nullptr,
    &wl_data_offer_interface_data};

struct wl_interface const* mfw::DataDevice::Thunks::selection_types[] {
    &wl_data_offer_interface_data};

struct wl_message const mfw::DataDevice::Thunks::request_messages[] {
    {"start_drag", "?oo?ou", start_drag_types},
    {"set_selection", "?ou", set_selection_types},
    {"release", "2", all_null_types}};

struct wl_message const mfw::DataDevice::Thunks::event_messages[] {
    {"data_offer", "n", data_offer_types},
    {"enter", "uoff?o", enter_types},
    {"leave", "", all_null_types},
    {"motion", "uff", all_null_types},
    {"drop", "", all_null_types},
    {"selection", "?o", selection_types}};

void const* mfw::DataDevice::Thunks::request_vtable[] {
    (void*)Thunks::start_drag_thunk,
    (void*)Thunks::set_selection_thunk,
    (void*)Thunks::release_thunk};

// DataDeviceManager

mfw::DataDeviceManager* mfw::DataDeviceManager::from(struct wl_resource* resource)
{
    return static_cast<DataDeviceManager*>(wl_resource_get_user_data(resource));
}

struct mfw::DataDeviceManager::Thunks
{
    static void create_data_source_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id)
    {
        auto me = static_cast<DataDeviceManager*>(wl_resource_get_user_data(resource));
        try
        {
            me->create_data_source(client, resource, id);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataDeviceManager::create_data_source() request");
        }
    }

    static void get_data_device_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* seat)
    {
        auto me = static_cast<DataDeviceManager*>(wl_resource_get_user_data(resource));
        try
        {
            me->get_data_device(client, resource, id, seat);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataDeviceManager::get_data_device() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<DataDeviceManager*>(data);
        auto resource = wl_resource_create(client, &wl_data_device_manager_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing DataDeviceManager::bind() request");
        }
    }

    static struct wl_interface const* create_data_source_types[];
    static struct wl_interface const* get_data_device_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::DataDeviceManager::DataDeviceManager(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_data_device_manager_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_data_device_manager interface"}));
    }
}

mfw::DataDeviceManager::~DataDeviceManager()
{
    wl_global_destroy(global);
}

void mfw::DataDeviceManager::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::DataDeviceManager::Thunks::create_data_source_types[] {
    &wl_data_source_interface_data};

struct wl_interface const* mfw::DataDeviceManager::Thunks::get_data_device_types[] {
    &wl_data_device_interface_data,
    &wl_seat_interface_data};

struct wl_message const mfw::DataDeviceManager::Thunks::request_messages[] {
    {"create_data_source", "n", create_data_source_types},
    {"get_data_device", "no", get_data_device_types}};

void const* mfw::DataDeviceManager::Thunks::request_vtable[] {
    (void*)Thunks::create_data_source_thunk,
    (void*)Thunks::get_data_device_thunk};

// Shell

mfw::Shell* mfw::Shell::from(struct wl_resource* resource)
{
    return static_cast<Shell*>(wl_resource_get_user_data(resource));
}

struct mfw::Shell::Thunks
{
    static void get_shell_surface_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface)
    {
        auto me = static_cast<Shell*>(wl_resource_get_user_data(resource));
        try
        {
            me->get_shell_surface(client, resource, id, surface);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Shell::get_shell_surface() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Shell*>(data);
        auto resource = wl_resource_create(client, &wl_shell_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Shell::bind() request");
        }
    }

    static struct wl_interface const* get_shell_surface_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::Shell::Shell(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_shell_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_shell interface"}));
    }
}

mfw::Shell::~Shell()
{
    wl_global_destroy(global);
}

void mfw::Shell::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Shell::Thunks::get_shell_surface_types[] {
    &wl_shell_surface_interface_data,
    &wl_surface_interface_data};

struct wl_message const mfw::Shell::Thunks::request_messages[] {
    {"get_shell_surface", "no", get_shell_surface_types}};

void const* mfw::Shell::Thunks::request_vtable[] {
    (void*)Thunks::get_shell_surface_thunk};

// ShellSurface

mfw::ShellSurface* mfw::ShellSurface::from(struct wl_resource* resource)
{
    return static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
}

struct mfw::ShellSurface::Thunks
{
    static void pong_thunk(struct wl_client*, struct wl_resource* resource, uint32_t serial)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->pong(serial);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::pong() request");
        }
    }

    static void move_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* seat, uint32_t serial)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->move(seat, serial);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::move() request");
        }
    }

    static void resize_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* seat, uint32_t serial, uint32_t edges)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->resize(seat, serial, edges);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::resize() request");
        }
    }

    static void set_toplevel_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_toplevel();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_toplevel() request");
        }
    }

    static void set_transient_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* parent, int32_t x, int32_t y, uint32_t flags)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_transient(parent, x, y, flags);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_transient() request");
        }
    }

    static void set_fullscreen_thunk(struct wl_client*, struct wl_resource* resource, uint32_t method, uint32_t framerate, struct wl_resource* output)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> output_resolved;
        if (output != nullptr)
        {
            output_resolved = {output};
        }
        try
        {
            me->set_fullscreen(method, framerate, output_resolved);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_fullscreen() request");
        }
    }

    static void set_popup_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* seat, uint32_t serial, struct wl_resource* parent, int32_t x, int32_t y, uint32_t flags)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_popup(seat, serial, parent, x, y, flags);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_popup() request");
        }
    }

    static void set_maximized_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* output)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> output_resolved;
        if (output != nullptr)
        {
            output_resolved = {output};
        }
        try
        {
            me->set_maximized(output_resolved);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_maximized() request");
        }
    }

    static void set_title_thunk(struct wl_client*, struct wl_resource* resource, char const* title)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_title(title);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_title() request");
        }
    }

    static void set_class_thunk(struct wl_client*, struct wl_resource* resource, char const* class_)
    {
        auto me = static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_class(class_);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing ShellSurface::set_class() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ShellSurface*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* move_types[];
    static struct wl_interface const* resize_types[];
    static struct wl_interface const* set_transient_types[];
    static struct wl_interface const* set_fullscreen_types[];
    static struct wl_interface const* set_popup_types[];
    static struct wl_interface const* set_maximized_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::ShellSurface::ShellSurface(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_shell_surface_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::ShellSurface::send_ping_event(uint32_t serial) const
{
    wl_resource_post_event(resource, Opcode::ping, serial);
}

void mfw::ShellSurface::send_configure_event(uint32_t edges, int32_t width, int32_t height) const
{
    wl_resource_post_event(resource, Opcode::configure, edges, width, height);
}

void mfw::ShellSurface::send_popup_done_event() const
{
    wl_resource_post_event(resource, Opcode::popup_done);
}

void mfw::ShellSurface::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::ShellSurface::Thunks::move_types[] {
    &wl_seat_interface_data,
    nullptr};

struct wl_interface const* mfw::ShellSurface::Thunks::resize_types[] {
    &wl_seat_interface_data,
    nullptr,
    nullptr};

struct wl_interface const* mfw::ShellSurface::Thunks::set_transient_types[] {
    &wl_surface_interface_data,
    nullptr,
    nullptr,
    nullptr};

struct wl_interface const* mfw::ShellSurface::Thunks::set_fullscreen_types[] {
    nullptr,
    nullptr,
    &wl_output_interface_data};

struct wl_interface const* mfw::ShellSurface::Thunks::set_popup_types[] {
    &wl_seat_interface_data,
    nullptr,
    &wl_surface_interface_data,
    nullptr,
    nullptr,
    nullptr};

struct wl_interface const* mfw::ShellSurface::Thunks::set_maximized_types[] {
    &wl_output_interface_data};

struct wl_message const mfw::ShellSurface::Thunks::request_messages[] {
    {"pong", "u", all_null_types},
    {"move", "ou", move_types},
    {"resize", "ouu", resize_types},
    {"set_toplevel", "", all_null_types},
    {"set_transient", "oiiu", set_transient_types},
    {"set_fullscreen", "uu?o", set_fullscreen_types},
    {"set_popup", "ouoiiu", set_popup_types},
    {"set_maximized", "?o", set_maximized_types},
    {"set_title", "s", all_null_types},
    {"set_class", "s", all_null_types}};

struct wl_message const mfw::ShellSurface::Thunks::event_messages[] {
    {"ping", "u", all_null_types},
    {"configure", "uii", all_null_types},
    {"popup_done", "", all_null_types}};

void const* mfw::ShellSurface::Thunks::request_vtable[] {
    (void*)Thunks::pong_thunk,
    (void*)Thunks::move_thunk,
    (void*)Thunks::resize_thunk,
    (void*)Thunks::set_toplevel_thunk,
    (void*)Thunks::set_transient_thunk,
    (void*)Thunks::set_fullscreen_thunk,
    (void*)Thunks::set_popup_thunk,
    (void*)Thunks::set_maximized_thunk,
    (void*)Thunks::set_title_thunk,
    (void*)Thunks::set_class_thunk};

// Surface

mfw::Surface* mfw::Surface::from(struct wl_resource* resource)
{
    return static_cast<Surface*>(wl_resource_get_user_data(resource));
}

struct mfw::Surface::Thunks
{
    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::destroy() request");
        }
    }

    static void attach_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* buffer, int32_t x, int32_t y)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> buffer_resolved;
        if (buffer != nullptr)
        {
            buffer_resolved = {buffer};
        }
        try
        {
            me->attach(buffer_resolved, x, y);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::attach() request");
        }
    }

    static void damage_thunk(struct wl_client*, struct wl_resource* resource, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->damage(x, y, width, height);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::damage() request");
        }
    }

    static void frame_thunk(struct wl_client*, struct wl_resource* resource, uint32_t callback)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->frame(callback);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::frame() request");
        }
    }

    static void set_opaque_region_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* region)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> region_resolved;
        if (region != nullptr)
        {
            region_resolved = {region};
        }
        try
        {
            me->set_opaque_region(region_resolved);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::set_opaque_region() request");
        }
    }

    static void set_input_region_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* region)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> region_resolved;
        if (region != nullptr)
        {
            region_resolved = {region};
        }
        try
        {
            me->set_input_region(region_resolved);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::set_input_region() request");
        }
    }

    static void commit_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->commit();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::commit() request");
        }
    }

    static void set_buffer_transform_thunk(struct wl_client*, struct wl_resource* resource, int32_t transform)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_buffer_transform(transform);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::set_buffer_transform() request");
        }
    }

    static void set_buffer_scale_thunk(struct wl_client*, struct wl_resource* resource, int32_t scale)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_buffer_scale(scale);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::set_buffer_scale() request");
        }
    }

    static void damage_buffer_thunk(struct wl_client*, struct wl_resource* resource, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        auto me = static_cast<Surface*>(wl_resource_get_user_data(resource));
        try
        {
            me->damage_buffer(x, y, width, height);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Surface::damage_buffer() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Surface*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* attach_types[];
    static struct wl_interface const* frame_types[];
    static struct wl_interface const* set_opaque_region_types[];
    static struct wl_interface const* set_input_region_types[];
    static struct wl_interface const* enter_types[];
    static struct wl_interface const* leave_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Surface::Surface(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_surface_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Surface::send_enter_event(struct wl_resource* output) const
{
    wl_resource_post_event(resource, Opcode::enter, output);
}

void mfw::Surface::send_leave_event(struct wl_resource* output) const
{
    wl_resource_post_event(resource, Opcode::leave, output);
}

void mfw::Surface::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Surface::Thunks::attach_types[] {
    &wl_buffer_interface_data,
    nullptr,
    nullptr};

struct wl_interface const* mfw::Surface::Thunks::frame_types[] {
    &wl_callback_interface_data};

struct wl_interface const* mfw::Surface::Thunks::set_opaque_region_types[] {
    &wl_region_interface_data};

struct wl_interface const* mfw::Surface::Thunks::set_input_region_types[] {
    &wl_region_interface_data};

struct wl_interface const* mfw::Surface::Thunks::enter_types[] {
    &wl_output_interface_data};

struct wl_interface const* mfw::Surface::Thunks::leave_types[] {
    &wl_output_interface_data};

struct wl_message const mfw::Surface::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"attach", "?oii", attach_types},
    {"damage", "iiii", all_null_types},
    {"frame", "n", frame_types},
    {"set_opaque_region", "?o", set_opaque_region_types},
    {"set_input_region", "?o", set_input_region_types},
    {"commit", "", all_null_types},
    {"set_buffer_transform", "2i", all_null_types},
    {"set_buffer_scale", "3i", all_null_types},
    {"damage_buffer", "4iiii", all_null_types}};

struct wl_message const mfw::Surface::Thunks::event_messages[] {
    {"enter", "o", enter_types},
    {"leave", "o", leave_types}};

void const* mfw::Surface::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::attach_thunk,
    (void*)Thunks::damage_thunk,
    (void*)Thunks::frame_thunk,
    (void*)Thunks::set_opaque_region_thunk,
    (void*)Thunks::set_input_region_thunk,
    (void*)Thunks::commit_thunk,
    (void*)Thunks::set_buffer_transform_thunk,
    (void*)Thunks::set_buffer_scale_thunk,
    (void*)Thunks::damage_buffer_thunk};

// Seat

mfw::Seat* mfw::Seat::from(struct wl_resource* resource)
{
    return static_cast<Seat*>(wl_resource_get_user_data(resource));
}

struct mfw::Seat::Thunks
{
    static void get_pointer_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id)
    {
        auto me = static_cast<Seat*>(wl_resource_get_user_data(resource));
        try
        {
            me->get_pointer(client, resource, id);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Seat::get_pointer() request");
        }
    }

    static void get_keyboard_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id)
    {
        auto me = static_cast<Seat*>(wl_resource_get_user_data(resource));
        try
        {
            me->get_keyboard(client, resource, id);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Seat::get_keyboard() request");
        }
    }

    static void get_touch_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id)
    {
        auto me = static_cast<Seat*>(wl_resource_get_user_data(resource));
        try
        {
            me->get_touch(client, resource, id);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Seat::get_touch() request");
        }
    }

    static void release_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        auto me = static_cast<Seat*>(wl_resource_get_user_data(resource));
        try
        {
            me->release(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Seat::release() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Seat*>(data);
        auto resource = wl_resource_create(client, &wl_seat_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Seat::bind() request");
        }
    }

    static struct wl_interface const* get_pointer_types[];
    static struct wl_interface const* get_keyboard_types[];
    static struct wl_interface const* get_touch_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Seat::Seat(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_seat_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_seat interface"}));
    }
}

mfw::Seat::~Seat()
{
    wl_global_destroy(global);
}

void mfw::Seat::send_capabilities_event(struct wl_resource* resource, uint32_t capabilities) const
{
    wl_resource_post_event(resource, Opcode::capabilities, capabilities);
}

bool mfw::Seat::version_supports_name(struct wl_resource* resource)
{
    return wl_resource_get_version(resource) >= 2;
}

void mfw::Seat::send_name_event(struct wl_resource* resource, std::string const& name) const
{
    const char* name_resolved = name.c_str();
    wl_resource_post_event(resource, Opcode::name, name_resolved);
}

void mfw::Seat::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Seat::Thunks::get_pointer_types[] {
    &wl_pointer_interface_data};

struct wl_interface const* mfw::Seat::Thunks::get_keyboard_types[] {
    &wl_keyboard_interface_data};

struct wl_interface const* mfw::Seat::Thunks::get_touch_types[] {
    &wl_touch_interface_data};

struct wl_message const mfw::Seat::Thunks::request_messages[] {
    {"get_pointer", "n", get_pointer_types},
    {"get_keyboard", "n", get_keyboard_types},
    {"get_touch", "n", get_touch_types},
    {"release", "5", all_null_types}};

struct wl_message const mfw::Seat::Thunks::event_messages[] {
    {"capabilities", "u", all_null_types},
    {"name", "2s", all_null_types}};

void const* mfw::Seat::Thunks::request_vtable[] {
    (void*)Thunks::get_pointer_thunk,
    (void*)Thunks::get_keyboard_thunk,
    (void*)Thunks::get_touch_thunk,
    (void*)Thunks::release_thunk};

// Pointer

mfw::Pointer* mfw::Pointer::from(struct wl_resource* resource)
{
    return static_cast<Pointer*>(wl_resource_get_user_data(resource));
}

struct mfw::Pointer::Thunks
{
    static void set_cursor_thunk(struct wl_client*, struct wl_resource* resource, uint32_t serial, struct wl_resource* surface, int32_t hotspot_x, int32_t hotspot_y)
    {
        auto me = static_cast<Pointer*>(wl_resource_get_user_data(resource));
        std::experimental::optional<struct wl_resource*> surface_resolved;
        if (surface != nullptr)
        {
            surface_resolved = {surface};
        }
        try
        {
            me->set_cursor(serial, surface_resolved, hotspot_x, hotspot_y);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Pointer::set_cursor() request");
        }
    }

    static void release_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Pointer*>(wl_resource_get_user_data(resource));
        try
        {
            me->release();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Pointer::release() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Pointer*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* set_cursor_types[];
    static struct wl_interface const* enter_types[];
    static struct wl_interface const* leave_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Pointer::Pointer(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_pointer_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Pointer::send_enter_event(uint32_t serial, struct wl_resource* surface, double surface_x, double surface_y) const
{
    wl_fixed_t surface_x_resolved{wl_fixed_from_double(surface_x)};
    wl_fixed_t surface_y_resolved{wl_fixed_from_double(surface_y)};
    wl_resource_post_event(resource, Opcode::enter, serial, surface, surface_x_resolved, surface_y_resolved);
}

void mfw::Pointer::send_leave_event(uint32_t serial, struct wl_resource* surface) const
{
    wl_resource_post_event(resource, Opcode::leave, serial, surface);
}

void mfw::Pointer::send_motion_event(uint32_t time, double surface_x, double surface_y) const
{
    wl_fixed_t surface_x_resolved{wl_fixed_from_double(surface_x)};
    wl_fixed_t surface_y_resolved{wl_fixed_from_double(surface_y)};
    wl_resource_post_event(resource, Opcode::motion, time, surface_x_resolved, surface_y_resolved);
}

void mfw::Pointer::send_button_event(uint32_t serial, uint32_t time, uint32_t button, uint32_t state) const
{
    wl_resource_post_event(resource, Opcode::button, serial, time, button, state);
}

void mfw::Pointer::send_axis_event(uint32_t time, uint32_t axis, double value) const
{
    wl_fixed_t value_resolved{wl_fixed_from_double(value)};
    wl_resource_post_event(resource, Opcode::axis, time, axis, value_resolved);
}

bool mfw::Pointer::version_supports_frame()
{
    return wl_resource_get_version(resource) >= 5;
}

void mfw::Pointer::send_frame_event() const
{
    wl_resource_post_event(resource, Opcode::frame);
}

bool mfw::Pointer::version_supports_axis_source()
{
    return wl_resource_get_version(resource) >= 5;
}

void mfw::Pointer::send_axis_source_event(uint32_t axis_source) const
{
    wl_resource_post_event(resource, Opcode::axis_source, axis_source);
}

bool mfw::Pointer::version_supports_axis_stop()
{
    return wl_resource_get_version(resource) >= 5;
}

void mfw::Pointer::send_axis_stop_event(uint32_t time, uint32_t axis) const
{
    wl_resource_post_event(resource, Opcode::axis_stop, time, axis);
}

bool mfw::Pointer::version_supports_axis_discrete()
{
    return wl_resource_get_version(resource) >= 5;
}

void mfw::Pointer::send_axis_discrete_event(uint32_t axis, int32_t discrete) const
{
    wl_resource_post_event(resource, Opcode::axis_discrete, axis, discrete);
}

void mfw::Pointer::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Pointer::Thunks::set_cursor_types[] {
    nullptr,
    &wl_surface_interface_data,
    nullptr,
    nullptr};

struct wl_interface const* mfw::Pointer::Thunks::enter_types[] {
    nullptr,
    &wl_surface_interface_data,
    nullptr,
    nullptr};

struct wl_interface const* mfw::Pointer::Thunks::leave_types[] {
    nullptr,
    &wl_surface_interface_data};

struct wl_message const mfw::Pointer::Thunks::request_messages[] {
    {"set_cursor", "u?oii", set_cursor_types},
    {"release", "3", all_null_types}};

struct wl_message const mfw::Pointer::Thunks::event_messages[] {
    {"enter", "uoff", enter_types},
    {"leave", "uo", leave_types},
    {"motion", "uff", all_null_types},
    {"button", "uuuu", all_null_types},
    {"axis", "uuf", all_null_types},
    {"frame", "5", all_null_types},
    {"axis_source", "5u", all_null_types},
    {"axis_stop", "5uu", all_null_types},
    {"axis_discrete", "5ui", all_null_types}};

void const* mfw::Pointer::Thunks::request_vtable[] {
    (void*)Thunks::set_cursor_thunk,
    (void*)Thunks::release_thunk};

// Keyboard

mfw::Keyboard* mfw::Keyboard::from(struct wl_resource* resource)
{
    return static_cast<Keyboard*>(wl_resource_get_user_data(resource));
}

struct mfw::Keyboard::Thunks
{
    static void release_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Keyboard*>(wl_resource_get_user_data(resource));
        try
        {
            me->release();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Keyboard::release() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Keyboard*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* enter_types[];
    static struct wl_interface const* leave_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Keyboard::Keyboard(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_keyboard_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Keyboard::send_keymap_event(uint32_t format, mir::Fd fd, uint32_t size) const
{
    int32_t fd_resolved{fd};
    wl_resource_post_event(resource, Opcode::keymap, format, fd_resolved, size);
}

void mfw::Keyboard::send_enter_event(uint32_t serial, struct wl_resource* surface, struct wl_array* keys) const
{
    wl_resource_post_event(resource, Opcode::enter, serial, surface, keys);
}

void mfw::Keyboard::send_leave_event(uint32_t serial, struct wl_resource* surface) const
{
    wl_resource_post_event(resource, Opcode::leave, serial, surface);
}

void mfw::Keyboard::send_key_event(uint32_t serial, uint32_t time, uint32_t key, uint32_t state) const
{
    wl_resource_post_event(resource, Opcode::key, serial, time, key, state);
}

void mfw::Keyboard::send_modifiers_event(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group) const
{
    wl_resource_post_event(resource, Opcode::modifiers, serial, mods_depressed, mods_latched, mods_locked, group);
}

bool mfw::Keyboard::version_supports_repeat_info()
{
    return wl_resource_get_version(resource) >= 4;
}

void mfw::Keyboard::send_repeat_info_event(int32_t rate, int32_t delay) const
{
    wl_resource_post_event(resource, Opcode::repeat_info, rate, delay);
}

void mfw::Keyboard::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Keyboard::Thunks::enter_types[] {
    nullptr,
    &wl_surface_interface_data,
    nullptr};

struct wl_interface const* mfw::Keyboard::Thunks::leave_types[] {
    nullptr,
    &wl_surface_interface_data};

struct wl_message const mfw::Keyboard::Thunks::request_messages[] {
    {"release", "3", all_null_types}};

struct wl_message const mfw::Keyboard::Thunks::event_messages[] {
    {"keymap", "uhu", all_null_types},
    {"enter", "uoa", enter_types},
    {"leave", "uo", leave_types},
    {"key", "uuuu", all_null_types},
    {"modifiers", "uuuuu", all_null_types},
    {"repeat_info", "4ii", all_null_types}};

void const* mfw::Keyboard::Thunks::request_vtable[] {
    (void*)Thunks::release_thunk};

// Touch

mfw::Touch* mfw::Touch::from(struct wl_resource* resource)
{
    return static_cast<Touch*>(wl_resource_get_user_data(resource));
}

struct mfw::Touch::Thunks
{
    static void release_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Touch*>(wl_resource_get_user_data(resource));
        try
        {
            me->release();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Touch::release() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Touch*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* down_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Touch::Touch(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_touch_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Touch::send_down_event(uint32_t serial, uint32_t time, struct wl_resource* surface, int32_t id, double x, double y) const
{
    wl_fixed_t x_resolved{wl_fixed_from_double(x)};
    wl_fixed_t y_resolved{wl_fixed_from_double(y)};
    wl_resource_post_event(resource, Opcode::down, serial, time, surface, id, x_resolved, y_resolved);
}

void mfw::Touch::send_up_event(uint32_t serial, uint32_t time, int32_t id) const
{
    wl_resource_post_event(resource, Opcode::up, serial, time, id);
}

void mfw::Touch::send_motion_event(uint32_t time, int32_t id, double x, double y) const
{
    wl_fixed_t x_resolved{wl_fixed_from_double(x)};
    wl_fixed_t y_resolved{wl_fixed_from_double(y)};
    wl_resource_post_event(resource, Opcode::motion, time, id, x_resolved, y_resolved);
}

void mfw::Touch::send_frame_event() const
{
    wl_resource_post_event(resource, Opcode::frame);
}

void mfw::Touch::send_cancel_event() const
{
    wl_resource_post_event(resource, Opcode::cancel);
}

bool mfw::Touch::version_supports_shape()
{
    return wl_resource_get_version(resource) >= 6;
}

void mfw::Touch::send_shape_event(int32_t id, double major, double minor) const
{
    wl_fixed_t major_resolved{wl_fixed_from_double(major)};
    wl_fixed_t minor_resolved{wl_fixed_from_double(minor)};
    wl_resource_post_event(resource, Opcode::shape, id, major_resolved, minor_resolved);
}

bool mfw::Touch::version_supports_orientation()
{
    return wl_resource_get_version(resource) >= 6;
}

void mfw::Touch::send_orientation_event(int32_t id, double orientation) const
{
    wl_fixed_t orientation_resolved{wl_fixed_from_double(orientation)};
    wl_resource_post_event(resource, Opcode::orientation, id, orientation_resolved);
}

void mfw::Touch::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Touch::Thunks::down_types[] {
    nullptr,
    nullptr,
    &wl_surface_interface_data,
    nullptr,
    nullptr,
    nullptr};

struct wl_message const mfw::Touch::Thunks::request_messages[] {
    {"release", "3", all_null_types}};

struct wl_message const mfw::Touch::Thunks::event_messages[] {
    {"down", "uuoiff", down_types},
    {"up", "uui", all_null_types},
    {"motion", "uiff", all_null_types},
    {"frame", "", all_null_types},
    {"cancel", "", all_null_types},
    {"shape", "6iff", all_null_types},
    {"orientation", "6if", all_null_types}};

void const* mfw::Touch::Thunks::request_vtable[] {
    (void*)Thunks::release_thunk};

// Output

mfw::Output* mfw::Output::from(struct wl_resource* resource)
{
    return static_cast<Output*>(wl_resource_get_user_data(resource));
}

struct mfw::Output::Thunks
{
    static void release_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        auto me = static_cast<Output*>(wl_resource_get_user_data(resource));
        try
        {
            me->release(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Output::release() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Output*>(data);
        auto resource = wl_resource_create(client, &wl_output_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Output::bind() request");
        }
    }

    static struct wl_interface const* geometry_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

mfw::Output::Output(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_output_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_output interface"}));
    }
}

mfw::Output::~Output()
{
    wl_global_destroy(global);
}

void mfw::Output::send_geometry_event(struct wl_resource* resource, int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, std::string const& make, std::string const& model, int32_t transform) const
{
    const char* make_resolved = make.c_str();
    const char* model_resolved = model.c_str();
    wl_resource_post_event(resource, Opcode::geometry, x, y, physical_width, physical_height, subpixel, make_resolved, model_resolved, transform);
}

void mfw::Output::send_mode_event(struct wl_resource* resource, uint32_t flags, int32_t width, int32_t height, int32_t refresh) const
{
    wl_resource_post_event(resource, Opcode::mode, flags, width, height, refresh);
}

bool mfw::Output::version_supports_done(struct wl_resource* resource)
{
    return wl_resource_get_version(resource) >= 2;
}

void mfw::Output::send_done_event(struct wl_resource* resource) const
{
    wl_resource_post_event(resource, Opcode::done);
}

bool mfw::Output::version_supports_scale(struct wl_resource* resource)
{
    return wl_resource_get_version(resource) >= 2;
}

void mfw::Output::send_scale_event(struct wl_resource* resource, int32_t factor) const
{
    wl_resource_post_event(resource, Opcode::scale, factor);
}

void mfw::Output::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Output::Thunks::geometry_types[] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};

struct wl_message const mfw::Output::Thunks::request_messages[] {
    {"release", "3", all_null_types}};

struct wl_message const mfw::Output::Thunks::event_messages[] {
    {"geometry", "iiiiissi", geometry_types},
    {"mode", "uiii", all_null_types},
    {"done", "2", all_null_types},
    {"scale", "2i", all_null_types}};

void const* mfw::Output::Thunks::request_vtable[] {
    (void*)Thunks::release_thunk};

// Region

mfw::Region* mfw::Region::from(struct wl_resource* resource)
{
    return static_cast<Region*>(wl_resource_get_user_data(resource));
}

struct mfw::Region::Thunks
{
    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Region*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Region::destroy() request");
        }
    }

    static void add_thunk(struct wl_client*, struct wl_resource* resource, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        auto me = static_cast<Region*>(wl_resource_get_user_data(resource));
        try
        {
            me->add(x, y, width, height);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Region::add() request");
        }
    }

    static void subtract_thunk(struct wl_client*, struct wl_resource* resource, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        auto me = static_cast<Region*>(wl_resource_get_user_data(resource));
        try
        {
            me->subtract(x, y, width, height);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Region::subtract() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Region*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::Region::Region(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_region_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Region::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mfw::Region::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"add", "iiii", all_null_types},
    {"subtract", "iiii", all_null_types}};

void const* mfw::Region::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::add_thunk,
    (void*)Thunks::subtract_thunk};

// Subcompositor

mfw::Subcompositor* mfw::Subcompositor::from(struct wl_resource* resource)
{
    return static_cast<Subcompositor*>(wl_resource_get_user_data(resource));
}

struct mfw::Subcompositor::Thunks
{
    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        auto me = static_cast<Subcompositor*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subcompositor::destroy() request");
        }
    }

    static void get_subsurface_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface, struct wl_resource* parent)
    {
        auto me = static_cast<Subcompositor*>(wl_resource_get_user_data(resource));
        try
        {
            me->get_subsurface(client, resource, id, surface, parent);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subcompositor::get_subsurface() request");
        }
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<Subcompositor*>(data);
        auto resource = wl_resource_create(client, &wl_subcompositor_interface_data,
                                           std::min(version, me->max_version), id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        wl_resource_set_implementation(resource, Thunks::request_vtable, me, nullptr);
        try
        {
            me->bind(client, resource);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subcompositor::bind() request");
        }
    }

    static struct wl_interface const* get_subsurface_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::Subcompositor::Subcompositor(struct wl_display* display, uint32_t max_version)
    : global{wl_global_create(display, &wl_subcompositor_interface_data, max_version, this, &Thunks::bind_thunk)},
      max_version{max_version}
{
    if (global == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::runtime_error{"Failed to export wl_subcompositor interface"}));
    }
}

mfw::Subcompositor::~Subcompositor()
{
    wl_global_destroy(global);
}

void mfw::Subcompositor::destroy_wayland_object(struct wl_resource* resource) const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Subcompositor::Thunks::get_subsurface_types[] {
    &wl_subsurface_interface_data,
    &wl_surface_interface_data,
    &wl_surface_interface_data};

struct wl_message const mfw::Subcompositor::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"get_subsurface", "noo", get_subsurface_types}};

void const* mfw::Subcompositor::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::get_subsurface_thunk};

// Subsurface

mfw::Subsurface* mfw::Subsurface::from(struct wl_resource* resource)
{
    return static_cast<Subsurface*>(wl_resource_get_user_data(resource));
}

struct mfw::Subsurface::Thunks
{
    static void destroy_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Subsurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subsurface::destroy() request");
        }
    }

    static void set_position_thunk(struct wl_client*, struct wl_resource* resource, int32_t x, int32_t y)
    {
        auto me = static_cast<Subsurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_position(x, y);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subsurface::set_position() request");
        }
    }

    static void place_above_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* sibling)
    {
        auto me = static_cast<Subsurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->place_above(sibling);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subsurface::place_above() request");
        }
    }

    static void place_below_thunk(struct wl_client*, struct wl_resource* resource, struct wl_resource* sibling)
    {
        auto me = static_cast<Subsurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->place_below(sibling);
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subsurface::place_below() request");
        }
    }

    static void set_sync_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Subsurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_sync();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subsurface::set_sync() request");
        }
    }

    static void set_desync_thunk(struct wl_client*, struct wl_resource* resource)
    {
        auto me = static_cast<Subsurface*>(wl_resource_get_user_data(resource));
        try
        {
            me->set_desync();
        }
        catch(...)
        {
            ::mir::log(::mir::logging::Severity::critical,
                       "frontend:Wayland",
                       std::current_exception(),
                       "Exception processing Subsurface::set_desync() request");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<Subsurface*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* place_above_types[];
    static struct wl_interface const* place_below_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

mfw::Subsurface::Subsurface(struct wl_client* client, struct wl_resource* parent, uint32_t id)
    : client{client},
      resource{wl_resource_create(client, &wl_subsurface_interface_data, wl_resource_get_version(parent), id)}
{
    if (resource == nullptr)
    {
        wl_resource_post_no_memory(parent);
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mfw::Subsurface::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_interface const* mfw::Subsurface::Thunks::place_above_types[] {
    &wl_surface_interface_data};

struct wl_interface const* mfw::Subsurface::Thunks::place_below_types[] {
    &wl_surface_interface_data};

struct wl_message const mfw::Subsurface::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"set_position", "ii", all_null_types},
    {"place_above", "o", place_above_types},
    {"place_below", "o", place_below_types},
    {"set_sync", "", all_null_types},
    {"set_desync", "", all_null_types}};

void const* mfw::Subsurface::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::set_position_thunk,
    (void*)Thunks::place_above_thunk,
    (void*)Thunks::place_below_thunk,
    (void*)Thunks::set_sync_thunk,
    (void*)Thunks::set_desync_thunk};

namespace mir
{
namespace frontend
{
namespace wayland
{

struct wl_interface const wl_callback_interface_data {
    "wl_callback", 1,
    0, nullptr,
    1, mfw::Callback::Thunks::event_messages};

struct wl_interface const wl_compositor_interface_data {
    "wl_compositor", 4,
    2, mfw::Compositor::Thunks::request_messages,
    0, nullptr};

struct wl_interface const wl_shm_pool_interface_data {
    "wl_shm_pool", 1,
    3, mfw::ShmPool::Thunks::request_messages,
    0, nullptr};

struct wl_interface const wl_shm_interface_data {
    "wl_shm", 1,
    1, mfw::Shm::Thunks::request_messages,
    1, mfw::Shm::Thunks::event_messages};

struct wl_interface const wl_buffer_interface_data {
    "wl_buffer", 1,
    1, mfw::Buffer::Thunks::request_messages,
    1, mfw::Buffer::Thunks::event_messages};

struct wl_interface const wl_data_offer_interface_data {
    "wl_data_offer", 3,
    5, mfw::DataOffer::Thunks::request_messages,
    3, mfw::DataOffer::Thunks::event_messages};

struct wl_interface const wl_data_source_interface_data {
    "wl_data_source", 3,
    3, mfw::DataSource::Thunks::request_messages,
    6, mfw::DataSource::Thunks::event_messages};

struct wl_interface const wl_data_device_interface_data {
    "wl_data_device", 3,
    3, mfw::DataDevice::Thunks::request_messages,
    6, mfw::DataDevice::Thunks::event_messages};

struct wl_interface const wl_data_device_manager_interface_data {
    "wl_data_device_manager", 3,
    2, mfw::DataDeviceManager::Thunks::request_messages,
    0, nullptr};

struct wl_interface const wl_shell_interface_data {
    "wl_shell", 1,
    1, mfw::Shell::Thunks::request_messages,
    0, nullptr};

struct wl_interface const wl_shell_surface_interface_data {
    "wl_shell_surface", 1,
    10, mfw::ShellSurface::Thunks::request_messages,
    3, mfw::ShellSurface::Thunks::event_messages};

struct wl_interface const wl_surface_interface_data {
    "wl_surface", 4,
    10, mfw::Surface::Thunks::request_messages,
    2, mfw::Surface::Thunks::event_messages};

struct wl_interface const wl_seat_interface_data {
    "wl_seat", 6,
    4, mfw::Seat::Thunks::request_messages,
    2, mfw::Seat::Thunks::event_messages};

struct wl_interface const wl_pointer_interface_data {
    "wl_pointer", 6,
    2, mfw::Pointer::Thunks::request_messages,
    9, mfw::Pointer::Thunks::event_messages};

struct wl_interface const wl_keyboard_interface_data {
    "wl_keyboard", 6,
    1, mfw::Keyboard::Thunks::request_messages,
    6, mfw::Keyboard::Thunks::event_messages};

struct wl_interface const wl_touch_interface_data {
    "wl_touch", 6,
    1, mfw::Touch::Thunks::request_messages,
    7, mfw::Touch::Thunks::event_messages};

struct wl_interface const wl_output_interface_data {
    "wl_output", 3,
    1, mfw::Output::Thunks::request_messages,
    4, mfw::Output::Thunks::event_messages};

struct wl_interface const wl_region_interface_data {
    "wl_region", 1,
    3, mfw::Region::Thunks::request_messages,
    0, nullptr};

struct wl_interface const wl_subcompositor_interface_data {
    "wl_subcompositor", 1,
    2, mfw::Subcompositor::Thunks::request_messages,
    0, nullptr};

struct wl_interface const wl_subsurface_interface_data {
    "wl_subsurface", 1,
    6, mfw::Subsurface::Thunks::request_messages,
    0, nullptr};

}
}
}
