Building the source for ARM {#building_source_for_arm}
===============================

There are a few ways to compile for a target arm device. Only armhf and arm64 
are supported at this time.

Native Compile
--------------

If you have a target device, you should be able to compile and install directly 
on the ARM device. This will be probably be slow, given the relative 
desktop/embedded CPU speeds these days. On the armhf or arm64 target device:

       $ mk-build-deps --install --tool "apt-get -y" --build-dep debian/control
       $ cmake .. -DMIR_PLATFORM=android
       $ make
       $ make install

The build-time flags -DMIR_BUILD_UNIT_TESTS=no -DMIR_BUILD_INTEGRATION_TESTS=no 
-DMIR_BUILD_ACCEPTANCE_TESTS=no can be used to avoid building the mir test suite
and save build-time.

Packaging workflow
------------------

sbuild is recommended to compile mir packages with armhf. Information on setting
sbuild up can be found here:

 * <a href="https://wiki.debian.org/sbuild"> https://wiki.debian.org/sbuild</a>
 * <a href="https://wiki.ubuntu.com/SimpleSbuild">
https://wiki.ubuntu.com/SimpleSbuild</a> 

If you do not wish to run the mir test suite during package generation, set
 DEB_BUILD_OPTIONS=nocheck to your environment

Emulated sbuild package generation
----------------------------------
This uses qemu to compile the package. Substitute <version_string> for the .dsc
file name generated by the debuild command.

       $ cd mir_source_dir
       $ debuild -S -uc -us
       $ cd .. 
       $ sbuild -d vivid --arch armhf mir_<version_string>.dsc

Cross compile sbuild package generation
---------------------------------------
This uses a cross-compile toolchain to compile the package, and generally 
should be faster than the emulated sbuild package generation.

Substitute <version_string> for the .dsc file name generated by the debuild 
command.

(Nov 2014) We are currently plagued by  
<a href="https://bugs.launchpad.net/mir/+bug/1353855">launchpad bug: 1353855</a>
which requires the sed step below as a work-around. If that bug gets resolved,
the sed step can be omitted.

       $ cd mir_source_dir
       $ sed -i '/.*g++-4.9.*$/d' debian/control
       $ debuild -S -uc -us
       $ cd .. 
       $ sbuild -d vivid --host armhf --build amd64 mir_<version_string>.dsc

Development workflow
--------------------

We have a script that can aid in the development workflow if you do not want to 
generate and install a package. The script will download a partial armhf chroot
within the mir_source_dir directory.

Make sure to have a suitable cross compile toolchain (e.g., the
`g++-arm-linux-gnueabihf` ubuntu package).

    $ sudo apt-get install g++-arm-linux-gnueabihf debootstrap
    $ cd mir_source_dir
    $ ./cross-compile-chroot.sh
    $ ls -l build-android-arm/*  # binaries to copy to your device

To speed up the process for future branches you may wish to cache the files
downloaded by setting environment variable MIR_NDK_PATH to point to a directory
that cross-compile-chroot.sh should reuse each time.

Copying the produced binaries correctly to the device requires good familiarity
with the Mir codebase. For that reason, installing using the debian packaging is
 recommended, and this compile method is mentioned for development purposes.
