############################ -*- Mode: Makefile -*- ###########################
## local.mk --- 
## Author           : Manoj Srivastava ( srivasta@glaurung.green-gryphon.com ) 
## Created On       : Sat Nov 15 10:42:10 2003
## Created On Node  : glaurung.green-gryphon.com
## Last Modified By : Manoj Srivastava
## Last Modified On : Fri Dec  9 22:12:44 2005
## Last Machine Used: glaurung.internal.golden-gryphon.com
## Update Count     : 16
## Status           : Unknown, Use with caution!
## HISTORY          : 
## Description      : 
## 
## arch-tag: b07b1015-30ba-4b46-915f-78c776a808f4
## 
###############################################################################

testdir:
	$(testdir)

CONFIG-common:: stamp-conf/make

BUILD/make:: build/make
INST/make:: install/make
BIN/make:: binary/make

BUILD/make-doc:: build/make-doc
INST/make-doc:: install/make-doc
BIN/make-doc:: binary/make-doc


CLN-common::
	$(REASON)
	-test ! -f Makefile || $(MAKE) distclean

CLEAN/make::
	-rm -rf $(TMPTOP)

CLEAN/make-doc::
	-rm -rf $(TMPTOP)

stamp-conf/make:
	$(checkdir)
	$(REASON)
	test -f stamp-conf ||                                         \
            ac_cv_lib_util_getloadavg=no ./configure                   \
               --verbose --prefix=$(PREFIX) --mandir=$(MANDIR)         \
               --infodir=$(INFODIR) --sysconfdir=/etc                  \
                  $(confflags) && touch stamp-conf

STAMPS_TO_CLEAN += stamp-conf

build/make:
	$(checkdir)
	$(REASON)
	$(MAKE) CC="$(CC)" CFLAGS="$(CFLAGS)" LDFLAGS="$(LDFLAGS)"
	touch stamp-build-make

STAMPS_TO_CLEAN += stamp-build-make


build/make-doc:
	$(checkdir)
	$(REASON)
	test -d debian/html || mkdir debian/html
	$(MAKE) -C doc html ps
	touch stamp-build-make-doc

STAMPS_TO_CLEAN += stamp-build-make-doc

install/make-doc: testroot
	$(checkdir)
	$(REASON)
	rm -rf              $(TMPTOP)
	$(make_directory)   $(TMPTOP)
	$(make_directory)   $(DOCDIR)
	$(make_directory)   $(DOCBASEDIR)
	$(make_directory)   $(LINTIANDIR)
	echo '$(package): description-synopsis-might-not-be-phrased-properly'>> \
                              $(LINTIANDIR)/$(package)
	$(install_file)      doc/make.ps       	    $(DOCDIR)
	$(install_file)      ChangeLog        	    $(DOCDIR)/changelog
	$(install_file)      NEWS             	    $(DOCDIR)/NEWS
	$(install_file)      debian/changelog 	    $(DOCDIR)/changelog.Debian
	gzip -9fqr           $(DOCDIR)/
# Make sure the copyright file is not compressed
	$(install_file)      debian/copyright        $(DOCDIR)/copyright
	$(install_file)      doc/make/*.html         $(DOCDIR)/
	$(install_file)      debian/docentry         $(DOCBASEDIR)/$(package)

install/make: testroot
	$(checkdir)
	$(REASON)
	rm -rf               $(TMPTOP)
	$(make_directory)    $(TMPTOP)
	$(make_directory)    $(BINDIR)
	$(make_directory)    $(LIBDIR)
	$(make_directory)    $(INFODIR)
	$(make_directory)    $(MAN1DIR)
	$(make_directory)    $(DOCDIR)
	$(make_directory)    $(LINTIANDIR)
	echo '$(package): description-synopsis-might-not-be-phrased-properly'>> \
                              $(LINTIANDIR)/$(package)
	$(MAKE)              $(INT_INSTALL_TARGET)  prefix=$(TMPTOP)/usr \
	                     infodir=$(INFODIR)     mandir=$(MANDIR)     \
                              INSTALL_PROGRAM="$(install_program)"
	$(install_file)      README                 $(DOCDIR)/README
	$(install_file)      debian/Explanations    $(DOCDIR)/
	$(install_file)      debian/changelog       $(DOCDIR)/changelog.Debian
	$(install_file)      ChangeLog              $(DOCDIR)/changelog
	$(install_file)      NEWS                   $(DOCDIR)/NEWS
	$(install_file)      debian/NEWS.Debian     $(DOCDIR)/
	gzip -9frq           $(DOCDIR)/
# Make sure the copyright file is not compressed
	$(install_file)      debian/copyright       $(DOCDIR)/copyright
	gzip -9fqr            $(MANDIR)/
	gzip -9fq             $(INFODIR)/$(package).info*
	-@test -g             $(BINDIR)/make && \
              echo "WARNING! WARNING! removing setgid bits from make\n\n\g"
	-test -g              $(BINDIR)/make     && chgrp root $(BINDIR)/make
	-test -g              $(BINDIR)/make     && chmod 0755 $(BINDIR)/make
	-test -e              $(INFODIR)/dir     && rm -f $(INFODIR)/dir
	-test -e              $(INFODIR)/dir.old && rm -f $(INFODIR)/dir.old
ifeq (,$(findstring nostrip,$(DEB_BUILD_OPTIONS)))
	strip --strip-unneeded --remove-section=.note --remove-section=.comment  $(BINDIR)/make 
endif

binary/make-doc: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)   $(TMPTOP)/DEBIAN
	$(install_script)    debian/doc.postinst     $(TMPTOP)/DEBIAN/postinst
	$(install_script)    debian/doc.postrm       $(TMPTOP)/DEBIAN/postrm
	$(install_script)    debian/doc.prerm        $(TMPTOP)/DEBIAN/prerm
	dpkg-gencontrol      -p$(package) -isp       -P$(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build         $(TMPTOP) ..

binary/make: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)    $(TMPTOP)/DEBIAN
	$(install_script)    debian/postinst        $(TMPTOP)/DEBIAN/postinst
	$(install_script)    debian/prerm           $(TMPTOP)/DEBIAN/prerm
	dpkg-shlibdeps       $(BINDIR)/make
	dpkg-gencontrol      -p$(package) -isp      -P$(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build         $(TMPTOP) ..
