/* libwpd
 * Copyright (C) 2002 William Lachance (william.lachance@sympatico.ca)
 * Copyright (C) 2002-2003 Marc Maurer (j.m.maurer@student.utwente.nl)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef WP6FILESTRUCTURE_H
#define WP6FILESTRUCTURE_H

// size of the fixed length functiongroups 0xF0 to 0xFF
extern int WP6_FIXED_LENGTH_FUNCTION_GROUP_SIZE[16];

/* standard sizes */
#define WP6_NUM_LIST_LEVELS 8

/* header defines */
#define WP6_HEADER_DOCUMENT_SIZE_OFFSET 20
#define WP6_HEADER_INDEX_HEADER_POINTER_OFFSET 14

#define WP6_EXPECTED_MAJOR_VERSION 2
#define WP6_DOCUMENT_FILE_TYPE 10

/* index header information */

#define WP6_INDEX_HEADER_NUM_INDICES_POSITION 2
#define WP6_INDEX_HEADER_INDICES_POSITION 14
#define WP6_INDEX_HEADER_ELEMENT_CHILD_PACKET_BIT 1
#define WP6_INDEX_HEADER_GRAPHICS_BOX_STYLE 65

#define WP6_INDEX_HEADER_GENERAL_WORDPERFECT_TEXT 0x08
#define WP6_INDEX_HEADER_PRINTER_SELECTION_DESCRIPTOR_POOL 0x23
#define WP6_INDEX_HEADER_FILL_STYLE 0x43
#define WP6_INDEX_HEADER_DESIRED_FONT_DESCRIPTOR_POOL 0x55
#define WP6_INDEX_HEADER_INITIAL_FONT 0x25
#define WP6_INDEX_HEADER_SYLE_DATA_DESCRIPTOR_POOL 0x30
#define WP6_INDEX_HEADER_PREFIX_TIME_STAMP_DESCRIPTOR_POOL 0x5E
#define WP6_INDEX_HEADER_UNDO_INFORMATION_DESCRIPTOR_POOL 0x77 /* WordPerfect 6.1 */
#define WP6_INDEX_HEADER_SHARED_PERSONAL_FILE_DATES_DESCRIPTOR_POOL 0x34
#define WP6_INDEX_HEADER_DOCUMENT_SETTINGS_DESCRIPTOR_POOL 0x02
#define WP6_INDEX_HEADER_NEXT_TOTAL_PAGE_COUNT_DESCRIPTOR_POOL 0x10
#define WP6_INDEX_HEADER_WORLD_WIDE_WEB_DESCRIPTOR_POOL 0x6D
#define WP6_INDEX_HEADER_CHECK_AS_YOU_GO_DESCRIPTOR_POOL 0x4E

#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY 0x12
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_AUTHOR 5
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_SUBJECT 46
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_PUBLISHER 33
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_CATEGORY 10
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_KEYWORDS 26
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_LANGUAGE 27
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_ABSTRACT 1
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_DESCRIPTIVE_NAME 17
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_DESCRIPTIVE_TYPE 18

#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_CREATION_DATE 0x0E
#define WP6_INDEX_HEADER_EXTENDED_DOCUMENT_SUMMARY_DATE_COMPLETED 0x0F

#define WP6_INDEX_HEADER_OUTLINE_STYLE 0x31
#define WP6_INDEX_HEADER_OUTLINE_STYLE_ARABIC_NUMBERING 0
#define WP6_INDEX_HEADER_OUTLINE_STYLE_LOWERCASE_NUMBERING 1
#define WP6_INDEX_HEADER_OUTLINE_STYLE_UPPERCASE_NUMBERING 2
#define WP6_INDEX_HEADER_OUTLINE_STYLE_LOWERCASE_ROMAN_NUMBERING 3
#define WP6_INDEX_HEADER_OUTLINE_STYLE_UPPERCASE_ROMAN_NUMBERING 4
#define WP6_NUM_LIST_LEVELS 8

#define WP6_VARIABLE_GROUP_PREFIX_ID_BIT 128 /* bit 7 */

/* Main function group list  */

#define WP6_TOP_SOFT_SPACE 0x80
#define WP6_TOP_HARD_SPACE 0x81
#define WP6_TOP_SOFT_HYPHEN_IN_LINE 0x82
#define WP6_TOP_SOFT_HYPHEN_AT_EOL 0x83
#define WP6_TOP_HARD_HYPHEN 0x84
#define WP6_TOP_AUTO_HYPHEN 0x85
#define WP6_TOP_DORMANT_HARD_RETURN 0x87

#define WP6_TOP_DELETABLE_HARD_EOP 0xB4
#define WP6_TOP_DELETABLE_HARD_EOC_AT_EOP 0xB5
#define WP6_TOP_DELETABLE_HARD_EOC 0xB6
#define WP6_TOP_DELETABLE_HARD_EOL_AT_EOC_AT_EOP 0xB7
#define WP6_TOP_DELETABLE_HARD_EOL_AT_EOC 0xB8
#define WP6_TOP_DELETABLE_HARD_EOL 0xB9
#define WP6_TOP_DELETABLE_SOFT_EOL_AT_EOC_AT_EOP 0xBA
#define WP6_TOP_DELETABLE_SOFT_EOL_AT_EOC 0xBB
#define WP6_TOP_DELETABLE_SOFT_EOL 0xBC
/*
#define WP6_TOP_TABLE_OFF_AT_EOC_AT_EOP 0xBD
#define WP6_TOP_TABLE_OFF_AT_EOC 0xBE
#define WP6_TOP_TABLE_OFF 0xBF
#define WP6_TOP_TABLE_ROW_AT_HARD_EOP 0xC0
#define WP6_TOP_TABLE_ROW_AT_HARD_EOC_AT_HARD_EOP 0xC1
#define WP6_TOP_TABLE_ROW_AT_HARD_EOC 0xC2
#define WP6_TOP_TABLE_ROW_AT_EOC_AT_EOP 0xC3
#define WP6_TOP_TABLE_ROW_AT_EOC 0xC4
#define WP6_TOP_TABLE_ROW 0xC5
#define WP6_TOP_TABLE_CELL 0xC6
*/
#define WP6_TOP_HARD_EOP 0xC7
#define WP6_TOP_HARD_EOC_AT_EOP 0xC8
#define WP6_TOP_HARD_EOC 0xC9
#define WP6_TOP_HARD_EOL_AT_EOC_AT_EOP 0xCA
#define WP6_TOP_HARD_EOL_AT_EOC 0xCB
#define WP6_TOP_HARD_EOL 0xCC
#define WP6_TOP_SOFT_EOL_AT_EOC_AT_EOP 0xCD
#define WP6_TOP_SOFT_EOL_AT_EOC 0xCE
#define WP6_TOP_SOFT_EOL 0xCF

#define WP6_TOP_EOL_GROUP 0xD0
#define WP6_TOP_PAGE_GROUP 0xD1
#define WP6_TOP_COLUMN_GROUP 0xD2
#define WP6_TOP_PARAGRAPH_GROUP 0xD3
#define WP6_TOP_CHARACTER_GROUP 0xD4
#define WP6_TOP_CROSSREFERENCE_GROUP 0xD5
#define WP6_TOP_HEADER_FOOTER_GROUP 0xD6
#define WP6_TOP_FOOTNOTE_ENDNOTE_GROUP 0xD7
#define WP6_TOP_SET_NUMBER_GROUP 0xD8
#define WP6_TOP_NUMBERING_METHOD_GROUP 0xD9
#define WP6_TOP_DISPLAY_NUMBER_REFERENCE_GROUP 0xDA
#define WP6_TOP_INCREMENT_NUMBER_GROUP 0xDB
#define WP6_TOP_DECREMENT_NUMBER_GROUP 0xDC
#define WP6_TOP_STYLE_GROUP 0xDD
#define WP6_TOP_MERGE_GROUP 0xDE
#define WP6_TOP_BOX_GROUP 0xDF
#define WP6_TOP_TAB_GROUP 0xE0
#define WP6_TOP_PLATFORM_GROUP 0xE1
#define WP6_TOP_FORMATTER_GROUP 0xE2

#define WP6_TOP_EXTENDED_CHARACTER 0xF0
#define WP6_TOP_UNDO_GROUP 0xF1
#define WP6_TOP_ATTRIBUTE_ON 0xF2
#define WP6_TOP_ATTRIBUTE_OFF 0xF3

/* Page Group */
#define WP6_PAGE_GROUP_TOP_MARGIN_SET 0x00
#define WP6_PAGE_GROUP_BOTTOM_MARGIN_SET 0x01
#define WP6_PAGE_GROUP_SUPPRESS_PAGE_CHARACTERISTICS 0x02

// breaking style here so our symbols aren't (as) ridiculously long
#define WP6_PAGE_GROUP_SUPPRESS_PAGE_NUMBER 1
#define WP6_PAGE_GROUP_SUPPRESS_CURRENT_PAGE_NUMBERING_AND_PRINT_NUMBER_AT_BOTTOM_CENTER 2
#define WP6_PAGE_GROUP_SUPPRESS_HEADER_A 4
#define WP6_PAGE_GROUP_SUPPRESS_HEADER_B 8
#define WP6_PAGE_GROUP_SUPPRESS_FOOTER_A 16
#define WP6_PAGE_GROUP_SUPPRESS_FOOTER_B 32
#define WP6_PAGE_GROUP_SUPPRESS_WATERMARK_A 64
#define WP6_PAGE_GROUP_SUPPRESS_WATERMARK_B 128

/* EOL Group */
#define WP6_EOL_GROUP_SOFT_EOL 0x01
#define WP6_EOL_GROUP_SOFT_EOC 0x02
#define WP6_EOL_GROUP_SOFT_EOC_AT_EOP 0x03
#define WP6_EOL_GROUP_HARD_EOL 0x04
#define WP6_EOL_GROUP_HARD_EOL_AT_EOC 0x05
#define WP6_EOL_GROUP_HARD_EOL_AT_EOP 0x06
#define WP6_EOL_GROUP_HARD_EOC 0x07
#define WP6_EOL_GROUP_HARD_EOC_AT_EOP 0x08
#define WP6_EOL_GROUP_HARD_EOP 0x09
#define WP6_EOL_GROUP_TABLE_CELL 0x0A
#define WP6_EOL_GROUP_TABLE_ROW_AND_CELL 0x0B
#define WP6_EOL_GROUP_TABLE_ROW_AT_EOC 0x0C
#define WP6_EOL_GROUP_TABLE_ROW_AT_EOP 0x0D
#define WP6_EOL_GROUP_TABLE_ROW_AT_HARD_EOC 0x0E
#define WP6_EOL_GROUP_TABLE_ROW_AT_HARD_EOC_AT_HARD_EOP 0x0F
#define WP6_EOL_GROUP_TABLE_ROW_AT_HARD_EOP 0x10
#define WP6_EOL_GROUP_TABLE_OFF 0x11
#define WP6_EOL_GROUP_TABLE_OFF_AT_EOC 0x12
#define WP6_EOL_GROUP_TABLE_OFF_AT_EOC_AT_EOP 0x13
#define WP6_EOL_GROUP_DELETABLE_SOFT_EOL 0x14
#define WP6_EOL_GROUP_DELETABLE_SOFT_EOC 0x15
#define WP6_EOL_GROUP_DELETABLE_SOFT_EOC_AT_EOP 0x16
#define WP6_EOL_GROUP_DELETABLE_HARD_EOL 0x17
#define WP6_EOL_GROUP_DELETABLE_HARD_EOL_AT_EOC 0x18
#define WP6_EOL_GROUP_DELETABLE_HARD_EOL_AT_EOP 0x19
#define WP6_EOL_GROUP_DELETABLE_HARD_EOC 0x1A
#define WP6_EOL_GROUP_DELETABLE_HARD_EOC_AT_EOP 0x1B
#define WP6_EOL_GROUP_DELETABLE_HARD_EOP 0x1C
#define WP6_EOL_GROUP_ROW_INFORMATION 128
#define WP6_EOL_GROUP_ROW_INFORMATION_SIZE 5
#define WP6_EOL_GROUP_CELL_FORMULA 129 // cell_formula size is variable
#define WP6_EOL_GROUP_TOP_GUTTER_SPACING 130
#define WP6_EOL_GROUP_TOP_GUTTER_SPACING_SIZE 4
#define WP6_EOL_GROUP_BOTTOM_GUTTER_SPACING 131
#define WP6_EOL_GROUP_BOTTOM_GUTTER_SPACING_SIZE 4
#define WP6_EOL_GROUP_CELL_INFORMATION 132
#define WP6_EOL_GROUP_CELL_INFORMATION_SIZE 9
#define WP6_EOL_GROUP_CELL_SPANNING_INFORMATION 133
#define WP6_EOL_GROUP_CELL_SPANNING_INFORMATION_SIZE 4
#define WP6_EOL_GROUP_CELL_FILL_COLORS 134
#define WP6_EOL_GROUP_CELL_FILL_COLORS_SIZE 10
#define WP6_EOL_GROUP_CELL_LINE_COLOR 135
#define WP6_EOL_GROUP_CELL_LINE_COLOR_SIZE 6
#define WP6_EOL_GROUP_CELL_NUMBER_TYPE 136
#define WP6_EOL_GROUP_CELL_NUMBER_TYPE_SIZE 6
#define WP6_EOL_GROUP_CELL_FLOATING_POINT_NUMBER 137
#define WP6_EOL_GROUP_CELL_FLOATING_POINT_NUMBER_SIZE 11
#define WP6_EOL_GROUP_CELL_PREFIX_FLAG 139
#define WP6_EOL_GROUP_CELL_PREFIX_FLAG_SIZE 3
#define WP6_EOL_GROUP_CELL_RECALCULATION_ERROR_NUMBER 140
#define WP6_EOL_GROUP_CELL_RECALCULATION_ERROR_NUMBER_SIZE 3
#define WP6_EOL_GROUP_DONT_END_A_PARAGRAPH_STYLE_FOR_THIS_HARD_RETURN 141
#define WP6_EOL_GROUP_DONT_END_A_PARAGRAPH_STYLE_FOR_THIS_HARD_RETURN_SIZE 1

/* Style Group */
#define WP6_STYLE_GROUP_PARASTYLE_BEGIN_ON_PART1 0x04
#define WP6_STYLE_GROUP_PARASTYLE_BEGIN_OFF_PART1 0x05
#define WP6_STYLE_GROUP_PARASTYLE_BEGIN_ON_PART2 0x06
#define WP6_STYLE_GROUP_PARASTYLE_BEGIN_OFF_PART2 0x07
#define WP6_STYLE_GROUP_PARASTYLE_END_ON 0x08
#define WP6_STYLE_GROUP_PARASTYLE_END_OFF 0x09
#define WP6_STYLE_GROUP_GLOBAL_ON 0x0A
#define WP6_STYLE_GROUP_GLOBAL_OFF 0x0B

#define WP6_SYSTEM_STYLE_FOOTNOTE 36
#define WP6_SYSTEM_STYLE_ENDNOTE 37

/* Paragraph Group */
#define WP6_PARAGRAPH_GROUP_LINE_SPACING 0x01
#define WP6_PARAGRAPH_GROUP_JUSTIFICATION 0x05
#define WP6_PARAGRAPH_GROUP_LEFT_MARGIN_ADJUSTMENT 0x0C
#define WP6_PARAGRAPH_GROUP_RIGHT_MARGIN_ADJUSTMENT 0x0D
#define WP6_PARAGRAPH_GROUP_OUTLINE_DEFINE 0x0E
#define WP6_PARAGRAPH_GROUP_OUTLINE_DEFINE_BULLETED_NUMBERING 0
#define WP6_PARAGRAPH_GROUP_OUTLINE_DEFINE_ARABIC_NUMBERING 256
#define WP6_PARAGRAPH_GROUP_OUTLINE_DEFINE_LOWERCASE_NUMBERING 3
#define WP6_PARAGRAPH_GROUP_OUTLINE_DEFINE_LOWERCASE_ROMAN_NUMBERING 769

#define WP6_PARAGRAPH_JUSTIFICATION_LEFT 0x00
#define WP6_PARAGRAPH_JUSTIFICATION_FULL 0x01
#define WP6_PARAGRAPH_JUSTIFICATION_CENTER 0x02
#define WP6_PARAGRAPH_JUSTIFICATION_RIGHT 0x03
#define WP6_PARAGRAPH_JUSTIFICATION_FULL_ALL_LINES 0x04
#define WP6_PARAGRAPH_JUSTIFICATION_RESERVED 0x05

/* Display Number Reference Group */
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_USER_DEFINED_ON 0x00
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_USER_DEFINED_OFF 0x01
//#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_CHAPTER_ON 0x08
//#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_CHAPTER_OFF 0x09
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_PARAGRAPH_NUMBER_ON 0x0C
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_PARAGRAPH_NUMBER_OFF 0x0D
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_FOOTNOTE_NUMBER_ON 0x0E
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_FOOTNOTE_NUMBER_OFF 0x0F
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_ENDNOTE_NUMBER_ON 0x10
#define WP6_DISPLAY_NUMBER_REFERENCE_GROUP_ENDNOTE_NUMBER_OFF 0x11

/* Character Group */
#define WP6_CHARACTER_GROUP_FONT_FACE_CHANGE 0x1A
#define WP6_CHARACTER_GROUP_FONT_SIZE_CHANGE 0x1B
#define WP6_CHARACTER_GROUP_PARAGRAPH_NUMBER_ON 0x32
#define WP6_CHARACTER_GROUP_PARAGRAPH_NUMBER_OFF 0x33
#define WP6_CHARACTER_GROUP_TABLE_DEFINITION_ON 0x2A
#define WP6_CHARACTER_GROUP_TABLE_DEFINITION_OFF 0x2B
#define WP6_CHARACTER_GROUP_TABLE_COLUMN 0x2C

/* Footnote/endnote Group */
#define WP6_FOOTNOTE_ENDNOTE_GROUP_FOOTNOTE_ON 0x00
#define WP6_FOOTNOTE_ENDNOTE_GROUP_ENDNOTE_ON 0x02
#define WP6_FOOTNOTE_ENDNOTE_GROUP_FOOTNOTE_OFF 0x01
#define WP6_FOOTNOTE_ENDNOTE_GROUP_ENDNOTE_OFF 0x03

/* Header/footer Group */
#define WP6_NUM_HEADER_FOOTER_TYPES 6
#define WP6_HEADER_FOOTER_GROUP_HEADER_A 0x00
#define WP6_HEADER_FOOTER_GROUP_HEADER_B 0x01
#define WP6_HEADER_FOOTER_GROUP_FOOTER_A 0x02
#define WP6_HEADER_FOOTER_GROUP_FOOTER_B 0x03
#define WP6_HEADER_FOOTER_GROUP_WATERMARK_A 0x04
#define WP6_HEADER_FOOTER_GROUP_WATERMARK_B 0x05

#define WP6_HEADER_FOOTER_GROUP_ODD_BIT 0x01
#define WP6_HEADER_FOOTER_GROUP_EVEN_BIT 0x02

/* Column Group */
#define WP6_COLUMN_GROUP_LEFT_MARGIN_SET 0
#define WP6_COLUMN_GROUP_RIGHT_MARGIN_SET 1

#define WP6_COLUMN_TYPE_NEWSPAPER 0x00
#define WP6_COLUMN_TYPE_NEWSPAPER_VERTICAL_BALANCE 0x01
#define WP6_COLUMN_TYPE_PARALLEL 0x02
#define WP6_COLUMN_TYPE_PARALLEL_PROTECT 0x03

/* Attribute Group */
#define WP6_ATTRIBUTE_SUPERSCRIPT 5
#define WP6_ATTRIBUTE_SUBSCRIPT 6
#define WP6_ATTRIBUTE_OUTLINE 7
#define WP6_ATTRIBUTE_ITALICS 8
#define WP6_ATTRIBUTE_SHADOW 9
#define WP6_ATTRIBUTE_REDLINE 10
#define WP6_ATTRIBUTE_DOUBLE_UNDERLINE 11
#define WP6_ATTRIBUTE_BOLD 12
#define WP6_ATTRIBUTE_STRIKE_OUT 13
#define WP6_ATTRIBUTE_UNDERLINE 14
#define WP6_ATTRIBUTE_SMALL_CAPS 15
#define WP6_ATTRIBUTE_BLINK 16

/* Tab Group */
// these elements are defined in terms of bits 3-8 of the tab group
#define WP6_TAB_GROUP_CENTER_ON_MARGINS 0x08
#define WP6_TAB_GROUP_CENTER_ON_CURRENT_POSITION 0x09
#define WP6_TAB_GROUP_CENTER_TAB 0x0A
#define WP6_TAB_GROUP_FLUSH_RIGHT 0x10
#define WP6_TAB_GROUP_RIGHT_TAB 0x12

/* Extended Character */
#define WP6_MULTINATIONAL_CHARACTER_SET 1
#define WP6_PHONETIC_SYMBOL_CHARACTER_SET 2
#define WP6_BOX_DRAWING_CHARACTER_SET 3
#define WP6_TYPOGRAPHIC_SYMBOL_CHARACTER_SET 4
#define WP6_ICONIC_SYMBOL_CHARACTER_SET 5
#define WP6_MATH_SCIENTIFIC_CHARACTER_SET 6
#define WP6_MATH_SCIENTIFIC_EXTENDED_CHARACTER_SET 7
#define WP6_GREEK_CHARACTER_SET 8
#define WP6_HEBREW_CHARACTER_SET 9
#define WP6_CYRILLIC_CHARACTER_SET 10
#define WP6_JAPANESE_CHARACTER_SET 11
#define WP6_TIBETAN_CHARACTER_SET 12

#define WP6_NUM_MULTINATIONAL_CHARACTERS 242
#define WP6_NUM_PHONETIC_CHARACTERS 145
#define WP6_NUM_BOX_DRAWING_CHARACTERS 88
#define WP6_NUM_TYPOGRAPHIC_CHARACTERS 102
#define WP6_NUM_ICONIC_CHARACTERS 255
#define WP6_NUM_MATH_SCIENTIFIC_CHARACTERS 238
#define WP6_NUM_MATH_SCIENTIFIC_EXTENDED_CHARACTERS 200
#define WP6_NUM_GREEK_CHARACTERS 219
#define WP6_NUM_HEBREW_CHARACTERS 115
#define WP6_NUM_CYRILLIC_CHARACTERS 250
#define WP6_NUM_JAPANESE_CHARACTERS 63

/* Undo Group */
#define WP6_UNDO_GROUP_INVALID_TEXT_START 0
#define WP6_UNDO_GROUP_INVALID_TEXT_END 1
#define WP6_UNDO_GROUP_VALID_TEXT_START 2
#define WP6_UNDO_GROUP_VALID_TEXT_END 3

#endif /* WP6FILESTRUCTURE_H */
