/* unity-internal.vapi generated by valac 0.14.2, do not modify. */

namespace Unity {
	namespace IO {
		[CCode (cheader_filename = "unity-internal.h")]
		internal static string[] system_data_dirs;
		[CCode (cheader_filename = "unity-internal.h")]
		public static async void read_stream_async (GLib.InputStream input, int io_priority = GLib.Priority.LOW, GLib.Cancellable? cancellable = null, out uint8[] data, out size_t size) throws GLib.IOError;
		[CCode (cheader_filename = "unity-internal.h")]
		public static async GLib.FileInputStream? open_from_dirs (string filename, string[] dirs) throws GLib.Error;
		[CCode (cheader_filename = "unity-internal.h")]
		public static async GLib.FileInputStream? open_from_data_dirs (string filename) throws GLib.Error;
		[CCode (cheader_filename = "unity-internal.h")]
		public static string[] get_system_data_dirs ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class StringArrayWrapper {
		public string[] strings;
		public void take_strings (owned string[] str_arr);
		public StringArrayWrapper ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class AppInfoManager : GLib.Object {
		[Deprecated (replacement = "AppInfoManager.get_default")]
		public static Unity.AppInfoManager get_instance ();
		public static Unity.AppInfoManager get_default ();
		public GLib.AppInfo? lookup (string id);
		public unowned string[]? get_categories (string id);
		public unowned string[]? get_keywords (string id);
		public string? get_path (string id);
		public async GLib.AppInfo? lookup_async (string id) throws GLib.Error;
		public void clear ();
		public signal void changed (string id, GLib.AppInfo? new_appinfo);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class Inspector : GLib.Object {
		public static unowned Unity.Inspector get_default ();
		public bool unity_running { get; }
		public string? unity_bus_name { get; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "com.canonical.Unity.LauncherEntry")]
	internal class LauncherEntryDBusImpl : GLib.Object {
		public weak Unity.LauncherEntry? owner;
		public LauncherEntryDBusImpl (GLib.DBusConnection conn, GLib.ObjectPath object_path, Unity.LauncherEntry owner);
		public GLib.HashTable<string,GLib.Variant> query ();
		public signal void update (string app_uri, GLib.HashTable<string,GLib.Variant> properties);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class LauncherEntry : Dee.Serializable, GLib.Object {
		internal GLib.ObjectPath _object_path;
		public static Unity.LauncherEntry get_for_app_uri (string app_uri);
		public static Unity.LauncherEntry get_for_desktop_id (string desktop_id);
		public static Unity.LauncherEntry get_for_desktop_file (string desktop_file);
		public string app_uri { get; set construct; }
		public int64 count { get; set; }
		public bool count_visible { get; set; }
		public double progress { get; set; }
		public bool progress_visible { get; set; }
		public bool urgent { get; set; }
		public Dbusmenu.Menuitem? quicklist { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class LauncherFavorites : GLib.Object {
		public static unowned Unity.LauncherFavorites get_default ();
		public bool has_app_info (GLib.AppInfo appinfo);
		public bool has_app_id (string app_id);
		public GLib.AppInfo? lookup (string app_id);
		public string[] enumerate_ids ();
		public GLib.AppInfo[] enumerate_app_infos ();
		public signal void changed ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class Lens : GLib.Object {
		internal const string SOURCES_FILTER_ID;
		public Lens (string dbus_path_, string id_);
		public void export () throws GLib.IOError;
		public void add_local_scope (Unity.Scope scope);
		internal void set_active_internal (bool is_active);
		internal unowned Unity.OptionsFilter get_sources_internal ();
		internal unowned Dee.Model get_model_internal (int index);
		public bool active { get; private set; }
		public bool visible { get; set; }
		public bool searching { get; private set; }
		public bool exported { get; private set; }
		public bool search_in_global { get; set; }
		public string id { get; construct; }
		public string dbus_path { get; construct; }
		public string search_hint { get; set; }
		public GLib.List<Unity.Filter> filters { get; set; }
		public GLib.List<Unity.Category> categories { get; set; }
		public Unity.MergeStrategy merge_strategy { get; set; }
		public Unity.MergeStrategy global_merge_strategy { get; set; }
		public string sources_display_name { get; set construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class ActivationResponse : GLib.InitiallyUnowned {
		public ActivationResponse (Unity.HandledType handled, string goto_uri = "");
		internal GLib.HashTable<string,GLib.Variant> get_hints ();
		public Unity.HandledType handled { get; construct; }
		public string goto_uri { get; set construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class Category : GLib.Object {
		public Category (string name, GLib.Icon icon_hint, Unity.CategoryRenderer renderer = CategoryRenderer.VERTICAL_TILE);
		public string name { get; construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public Unity.CategoryRenderer default_renderer { get; construct; }
		internal string renderer { get; }
		internal GLib.HashTable<string,GLib.Variant> hints { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public abstract class Filter : GLib.Object {
		internal void set_model_and_iter (Dee.Model model, Dee.ModelIter iter);
		internal abstract GLib.HashTable<string,GLib.Variant> get_hints ();
		internal abstract void update (GLib.Variant properties);
		internal static unowned string get_renderer_name (Unity.FilterRenderer renderer);
		internal static Unity.FilterRenderer renderer_for_name (string renderer_name);
		public Filter ();
		public string id { get; construct; }
		public string display_name { get; internal set construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public Unity.FilterRenderer renderer { get; construct; }
		public bool visible { get; set construct; }
		public bool collapsed { get; construct; }
		public bool filtering { get; internal set construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class FilterOption : GLib.Object {
		public FilterOption (string id, string display_name, GLib.Icon? icon_hint = null, bool active = false);
		public string id { get; construct; }
		public string display_name { get; construct; }
		public GLib.Icon icon_hint { get; construct; }
		public bool active { get; internal set construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class OptionsFilter : Unity.Filter {
		public enum SortType {
			MANUAL,
			DISPLAY_NAME,
			ID
		}
		public GLib.List<Unity.FilterOption> options;
		public Unity.FilterOption add_option (string id, string display_name, GLib.Icon? icon_hint = null);
		public Unity.FilterOption? get_option (string id);
		public bool remove_option (string id);
		internal override void update (GLib.Variant properties);
		internal void load_or_update_options (GLib.Variant array);
		internal void find_and_update_option (string id, string name, string icon_hint_s, bool active);
		internal override GLib.HashTable<string,GLib.Variant> get_hints ();
		public OptionsFilter ();
		public Unity.OptionsFilter.SortType sort_type { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class RadioOptionFilter : Unity.OptionsFilter {
		public RadioOptionFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public Unity.FilterOption? get_active_option ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class CheckOptionFilter : Unity.OptionsFilter {
		public CheckOptionFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class CheckOptionFilterCompact : Unity.OptionsFilter {
		public CheckOptionFilterCompact (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class RatingsFilter : Unity.Filter {
		public RatingsFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		internal override void update (GLib.Variant properties);
		internal override GLib.HashTable<string,GLib.Variant> get_hints ();
		public float rating { get; internal set construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class MultiRangeFilter : Unity.OptionsFilter {
		public MultiRangeFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public Unity.FilterOption? get_first_active ();
		public Unity.FilterOption? get_last_active ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public abstract class Preview : GLib.InitiallyUnowned {
		internal abstract string get_renderer_name ();
		internal abstract GLib.HashTable<string,GLib.Variant> get_properties ();
		public Preview ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class NoPreview : Unity.Preview {
		public NoPreview ();
		internal override string get_renderer_name ();
		internal override GLib.HashTable<string,GLib.Variant> get_properties ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class GenericPreview : Unity.Preview {
		public GenericPreview (string name, uint date_modified, uint size, string type, string description, string large_icon_hint, string primary_action_name, string primary_action_icon_hint, string primary_action_uri, string secondary_action_name = "", string secondary_action_icon_hint = "", string secondary_action_uri = "", string tertiary_action_name = "", string tertiary_action_icon_hint = "", string tertiary_action_uri = "");
		internal override string get_renderer_name ();
		internal override GLib.HashTable<string,GLib.Variant> get_properties ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class ApplicationPreview : Unity.Preview {
		public ApplicationPreview (string name, string version, string size, string license, string last_updated, float rating, uint n_ratings, string description, string icon_hint, string screenshot_icon_hint, string primary_action_name, string primary_action_icon_hint, string primary_action_uri);
		internal override string get_renderer_name ();
		internal override GLib.HashTable<string,GLib.Variant> get_properties ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class TrackPreview : Unity.Preview {
		public TrackPreview (uint number, string title, string artist, string album, uint length, string[] genres, string album_cover, string primary_action_name, string primary_action_icon_hint, string primary_action_uri, string play_action_uri, string pause_action_uri);
		internal override string get_renderer_name ();
		internal override GLib.HashTable<string,GLib.Variant> get_properties ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class AlbumPreview : Unity.Preview {
		public AlbumPreview (string name, string artist, string year, string[] genres, string album_cover, string primary_action_name, string primary_action_icon_hint, string primary_action_uri);
		internal override string get_renderer_name ();
		internal override GLib.HashTable<string,GLib.Variant> get_properties ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class LensImpl : GLib.Object, Unity.LensService {
		public LensImpl (Unity.Lens owner);
		public void export () throws GLib.IOError;
		public void load_categories (GLib.List<Unity.Category> categories);
		public void load_filters (GLib.List<Unity.Filter> filters);
		public void add_local_scope (Unity.Scope scope);
		public unowned Unity.OptionsFilter get_sources ();
		public unowned Dee.Model? get_model (int index);
		protected async void update_active_sources (Gee.Set<string> updated_scope_uids);
		public Unity.ResultsSynchronizer results_sync { get; }
		public Unity.ResultsSynchronizer global_results_sync { get; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class LensSearch : GLib.InitiallyUnowned {
		[CCode (cname = "unity_lens_search_finished")]
		public void emit_finished ();
		public LensSearch (string search_string, GLib.HashTable<string,GLib.Variant> hints, Dee.SerializableModel results_model);
		internal bool was_finished ();
		public bool equals (Unity.LensSearch? other);
		public void set_reply_hint (string key, GLib.Variant variant);
		internal GLib.HashTable<string,GLib.Variant>? get_reply_hints ();
		public string search_string { get; construct; }
		public GLib.HashTable<string,GLib.Variant> hints { get; construct; }
		public Dee.SerializableModel results_model { get; construct; }
		[Signal (action = true)]
		public signal void finished ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class Tools {
		public static GLib.Variant hash_table_to_asv (GLib.HashTable<string,GLib.Variant> hash);
		public Tools ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class FiltersSynchronizer : GLib.Object {
		public FiltersSynchronizer (Dee.Model provider);
		public void add_receiver (Dee.Model receiver);
		public void remove_receiver (Dee.Model receiver);
		public Dee.Model provider { get; construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class ResultsSynchronizer : Unity.MergeStrategy, GLib.Object {
		public ResultsSynchronizer (Dee.Model receiver);
		public void add_provider (Dee.Model provider, string uid);
		public Dee.Model receiver { get; construct; }
		public Unity.MergeStrategy merge_strategy { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class Scope : GLib.Object {
		internal GLib.List<Unity.Filter> _filters;
		public Scope (string dbus_path_);
		public void export () throws GLib.IOError;
		public Unity.Filter? get_filter (string id);
		public void queue_search_changed (Unity.SearchType search_type);
		public void invalidate_search (Unity.SearchType search_type);
		internal unowned Unity.LensSearch? get_last_search (Unity.SearchType search_type);
		internal void set_last_search (Unity.LensSearch search, Unity.SearchType search_type);
		internal void set_view_type_internal (Unity.ViewType view_type);
		internal void set_active_sources_internal (string[] active_sources_);
		internal void set_local (bool is_local_);
		internal unowned Dee.SerializableModel get_filter_model ();
		internal async Unity.ActivationReplyRaw activate (string uri, uint action_type);
		internal async GLib.HashTable<string,GLib.Variant> search (string search_string, GLib.HashTable<string,GLib.Variant> hints) throws GLib.Error;
		internal async GLib.HashTable<string,GLib.Variant> global_search (string search_string, GLib.HashTable<string,GLib.Variant> hints) throws GLib.Error;
		internal async Unity.PreviewReplyRaw preview (string uri);
		public bool active { get; set; }
		public bool exported { get; private set; }
		public bool search_in_global { get; set; }
		public string dbus_path { get; construct; }
		public Unity.OptionsFilter sources { get; internal set; }
		public GLib.List<Unity.Filter> filters { get; }
		public Dee.SerializableModel results_model { get; }
		public Dee.SerializableModel global_results_model { get; }
		public signal Unity.ActivationResponse? activate_uri (string uri);
		public signal Unity.Preview? preview_uri (string uri);
		public signal void filters_changed ();
		public signal void active_sources_changed (string[] active_ids);
		public signal void search_changed (Unity.LensSearch search, Unity.SearchType search_type, GLib.Cancellable cancellable);
		[Signal (detailed = true)]
		public signal string generate_search_key (Unity.LensSearch search);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class ScopeFactory : GLib.Object {
		public Gee.ArrayList<Unity.ScopeProxy> scopes;
		public ScopeFactory (string lens_id_, string lenses_directory_ = "");
		public void add_local_scope (Unity.Scope scope);
		public string lens_id { get; construct; }
		public string lenses_directory { get; construct; }
		public signal void scope_added (Unity.ScopeProxy scope);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class ScopeImpl : GLib.Object, Unity.ScopeService {
		public Dee.SerializableModel _results_model;
		public Dee.SerializableModel _global_results_model;
		public Dee.SerializableModel _filters_model;
		public ScopeImpl (Unity.Scope owner);
		public void export () throws GLib.IOError;
		public async void schedule_search_changed (Unity.LensSearch search, Unity.SearchType search_type, bool wait_for_view);
		public void update_search_key (Unity.LensSearch ls, Unity.SearchType search_type);
		public void invalidate_search (Unity.SearchType search_type);
		public Unity.ViewType view_type { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class ScopeProxyLocal : GLib.Object, Unity.ScopeProxy {
		public ScopeProxyLocal (Unity.Scope scope);
		public Unity.Scope scope { get; construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class ScopeProxyRemote : GLib.Object, Unity.ScopeProxy {
		public ScopeProxyRemote (string dbus_name_, string dbus_path_);
		public async void set_view_type (Unity.ViewType view_type);
		public void on_changed (Unity.ScopeInfo scope_info);
		public string dbus_name { get; construct; }
		public string dbus_path { get; construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class TrackMetadata : GLib.Object {
		public TrackMetadata ();
		public string artist { get; set; }
		public string title { get; set; }
		public string album { get; set; }
		public GLib.File art_location { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class Playlist : GLib.Object {
		public Playlist (string id);
		public string id { get; construct; }
		public string name { get; set; }
		public GLib.Icon icon { get; set; }
		public GLib.DateTime creation_date { get; set; }
		public GLib.DateTime modification_date { get; set; }
		public GLib.DateTime last_play_date { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public class MusicPlayer : GLib.Object {
		public MusicPlayer (string desktop);
		public void export ();
		public void unexport ();
		public bool add_playlist (Unity.Playlist p);
		public bool remove_playlist (Unity.Playlist p);
		public Unity.Playlist[] get_playlists ();
		public void edit_playlist_name (string id, string name);
		public GLib.AppInfo app_info { get; construct; }
		public string desktop_file_name { get; construct; }
		public bool is_blacklisted { get; set; }
		public string title { get; set; }
		public bool can_go_next { get; set; }
		public bool can_go_previous { get; set; }
		public bool can_play { get; set; }
		public bool can_pause { get; set; }
		public Unity.TrackMetadata current_track { get; set; }
		public Unity.PlaybackState playback_state { get; set; }
		public Unity.Playlist current_playlist { get; set; }
		public Dbusmenu.Menuitem? track_menu { get; set; }
		public Dbusmenu.Menuitem? player_menu { get; set; }
		public signal void raise ();
		public signal void play_pause ();
		public signal void previous ();
		public signal void next ();
		public signal void activate_playlist (GLib.ObjectPath playlist_id);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class MPRISGateway : GLib.Object {
		public MPRISGateway (Unity.MusicPlayer client);
		public void export ();
		public void unexport ();
		public void ensure_playlist_interface_is_raised ();
		public Unity.MusicPlayer consumer { get; construct; }
		public Unity.Playlist edited_playlist { get; set; }
		public int playlist_count { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class SpecificItemManager : GLib.Object {
		internal GLib.ObjectPath _player_specific_object_path;
		internal GLib.ObjectPath _track_specific_object_path;
		public SpecificItemManager (Unity.MusicPlayer client);
		public Unity.MusicPlayer consumer { get; construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class PropertyUpdateManager : GLib.Object {
		public PropertyUpdateManager (GLib.DBusConnection conn);
		public void queue_property_update (string prop_name, GLib.Variant update, string interface_name);
		public void emit_dbus_signal (string interface_name, string signal_name, GLib.Variant payload);
		public GLib.DBusConnection connection { get; construct; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal class BlacklistManager : GLib.Object {
		public BlacklistManager (Unity.MusicPlayer client);
		public bool check_presence ();
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "org.mpris.MediaPlayer2")]
	internal class MprisRoot : GLib.Object {
		public MprisRoot (Unity.MusicPlayer client, Unity.PropertyUpdateManager prop_mgr);
		public async void raise () throws GLib.IOError;
		public bool has_tracklist { get; }
		public bool can_quit { get; }
		public bool can_raise { get; }
		public string identity { get; }
		public string desktop_entry { get; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "org.mpris.MediaPlayer2.Player")]
	internal class MprisPlayer : GLib.Object {
		public MprisPlayer (Unity.MusicPlayer client, Unity.PropertyUpdateManager prop_mgr);
		protected void on_metadata_update (GLib.ParamSpec pspec);
		public async void play_pause () throws GLib.IOError;
		public async void next () throws GLib.IOError;
		public async void previous () throws GLib.IOError;
		public GLib.HashTable<string,GLib.Variant> metadata { get; }
		public string playback_status { get; }
		public bool can_control { get; }
		public bool can_go_next { get; }
		public bool can_go_previous { get; }
		public bool can_play { get; }
		public bool can_pause { get; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "org.mpris.MediaPlayer2.Playlists")]
	internal class MprisPlaylists : GLib.Object {
		public MprisPlaylists (Unity.MusicPlayer consumer, Unity.PropertyUpdateManager prop_mgr, Unity.MPRISGateway gw);
		public async void activate_playlist (GLib.ObjectPath playlist_id) throws GLib.IOError;
		public async Unity.PlaylistDetails[] get_playlists (uint32 index, uint32 max_count, string order, bool reverse_order) throws GLib.IOError;
		public string[] orderings { owned get; }
		public uint32 playlist_count { get; }
		public Unity.ActivePlaylistContainer active_playlist { owned get; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "com.canonical.Unity.Lens")]
	internal interface LensService : GLib.Object {
		public abstract async void info_request () throws GLib.IOError;
		public abstract async Unity.ActivationReplyRaw activate (string uri, uint action_type) throws GLib.IOError;
		public abstract async GLib.HashTable<string,GLib.Variant> search (string search_string, GLib.HashTable<string,GLib.Variant> hints) throws GLib.IOError;
		public abstract async GLib.HashTable<string,GLib.Variant> global_search (string search_string, GLib.HashTable<string,GLib.Variant> hints) throws GLib.IOError;
		public abstract async Unity.PreviewReplyRaw preview (string uri) throws GLib.IOError;
		public abstract async void update_filter (string filter_name, GLib.HashTable<string,GLib.Variant> properties) throws GLib.IOError;
		public abstract async void set_view_type (uint view_type) throws GLib.IOError;
		public signal void changed (Unity.LensInfo lens_info);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public interface MergeStrategy : GLib.Object {
		public abstract unowned Dee.ModelIter? merge_result (Dee.Model target, GLib.Variant[] row);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "com.canonical.Unity.Scope")]
	internal interface ScopeService : GLib.Object {
		public abstract async void info_request () throws GLib.IOError;
		public abstract async Unity.ActivationReplyRaw activate (string uri, uint action_type) throws GLib.IOError;
		public abstract async GLib.HashTable<string,GLib.Variant> search (string search_string, GLib.HashTable<string,GLib.Variant> hints) throws GLib.IOError, Unity.ScopeError;
		public abstract async GLib.HashTable<string,GLib.Variant> global_search (string search_string, GLib.HashTable<string,GLib.Variant> hints) throws GLib.IOError, Unity.ScopeError;
		public abstract async Unity.PreviewReplyRaw preview (string uri) throws GLib.IOError;
		public abstract async void set_view_type (uint view_type) throws GLib.IOError;
		public abstract async void set_active_sources (string[] sources) throws GLib.IOError;
		public signal void changed (Unity.ScopeInfo lens_info);
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal interface ScopeProxy : GLib.Object {
		public abstract async Unity.ActivationReplyRaw activate (string uri, uint action_type);
		public abstract async GLib.HashTable<string,GLib.Variant> search (string search_string, GLib.HashTable<string,GLib.Variant> hints);
		public abstract async GLib.HashTable<string,GLib.Variant> global_search (string search_string, GLib.HashTable<string,GLib.Variant> hints);
		public abstract async Unity.PreviewReplyRaw preview (string uri);
		public abstract async void set_active_sources (string[] sources);
		public abstract Unity.OptionsFilter sources { get; set; }
		public abstract bool search_in_global { get; set; }
		public abstract Unity.ViewType view_type { get; set; }
		public abstract Dee.SerializableModel results_model { get; set; }
		public abstract Dee.SerializableModel global_results_model { get; set; }
		public abstract Dee.SerializableModel filters_model { get; set; }
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "com.canonical.indicators.sound")]
	internal interface SoundServiceInterface : GLib.Object {
		public abstract async void EnableTrackSpecificItems (GLib.ObjectPath object_path, string desktop_id) throws GLib.IOError;
		public abstract async void EnablePlayerSpecificItems (GLib.ObjectPath object_path, string desktop_id) throws GLib.IOError;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal struct LensInfo {
		public string dbus_path;
		public bool search_in_global;
		public bool visible;
		public string search_hint;
		public string private_connection_name;
		public string results_model_name;
		public string global_results_model_name;
		public string categories_model_name;
		public string filters_model_name;
		public GLib.HashTable<string,GLib.Variant> hints;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal struct ScopeInfo {
		public string dbus_path;
		public GLib.Variant sources;
		public bool search_in_global;
		public string private_connection_name;
		public string results_model_name;
		public string global_results_model_name;
		public string filters_model_name;
		public GLib.HashTable<string,GLib.Variant> hints;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal struct ActivationReplyRaw {
		public string uri;
		public uint handled;
		public GLib.HashTable<string,GLib.Variant> hints;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal struct PreviewReplyRaw {
		public string uri;
		public string renderer_name;
		public GLib.HashTable<string,GLib.Variant> properties;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public struct PlaylistDetails {
		public GLib.ObjectPath id;
		public string name;
		public string icon_name;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public struct ActivePlaylistContainer {
		public bool valid;
		public Unity.PlaylistDetails details;
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public enum HandledType {
		NOT_HANDLED,
		SHOW_DASH,
		HIDE_DASH,
		GOTO_DASH_URI
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public enum CategoryRenderer {
		VERTICAL_TILE,
		HORIZONTAL_TILE,
		LIST_TILE,
		FLOW
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal enum FilterColumn {
		ID,
		NAME,
		ICON_HINT,
		RENDERER_NAME,
		RENDERER_STATE,
		VISIBLE,
		COLLAPSED,
		FILTERING
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public enum FilterRenderer {
		CHECK_OPTIONS,
		RADIO_OPTIONS,
		MULTIRANGE,
		RATINGS,
		CHECK_OPTIONS_COMPACT
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal enum ViewType {
		HIDDEN,
		HOME_VIEW,
		LENS_VIEW
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public enum SearchType {
		DEFAULT,
		GLOBAL,
		N_TYPES
	}
	[CCode (cheader_filename = "unity-internal.h")]
	public enum PlaybackState {
		PLAYING,
		PAUSED
	}
	[CCode (cheader_filename = "unity-internal.h")]
	[DBus (name = "com.canonical.Unity.ScopeError")]
	public errordomain ScopeError {
		SEARCH_CANCELLED,
		UNKNOWN
	}
	[CCode (cheader_filename = "unity-internal.h")]
	internal const string MPRIS_INTERFACE_ROOT_PATH;
	[CCode (cheader_filename = "unity-internal.h")]
	internal const string MPRIS_INTERFACE_ROOT;
	[CCode (cheader_filename = "unity-internal.h")]
	internal const string MPRIS_INTERFACE_PREFIX;
	[CCode (cheader_filename = "unity-internal.h")]
	internal const string MPRIS_INTERFACE_PLAYER;
	[CCode (cheader_filename = "unity-internal.h")]
	internal const string MPRIS_INTERFACE_PLAYLISTS;
	[CCode (cheader_filename = "unity-internal.h")]
	internal static GLib.HashTable<string,GLib.Variant> collect_launcher_entry_properties (Unity.LauncherEntry l);
}
