/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __U1_CODEC_INSTALLER_H__
#define __U1_CODEC_INSTALLER_H__

#include <glib-object.h>
#include <gtk/gtk.h>

#define U1_TYPE_CODEC_INSTALLER            (u1_codec_installer_get_type ())
#define U1_CODEC_INSTALLER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), U1_TYPE_CODEC_INSTALLER, U1CodecInstaller))
#define U1_IS_CODEC_INSTALLER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), U1_TYPE_CODEC_INSTALLER))
#define U1_CODEC_INSTALLER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), U1_TYPE_CODEC_INSTALLER, U1CodecInstaller))
#define U1_IS_CODEC_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), U1_TYPE_CODEC_INSTALLER))
#define U1_CODEC_INSTALLER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), U1_TYPE_CODEC_INSTALLER, U1CodecInstaller))
#define U1_CODEC_INSTALLER_ERROR           (u1_codec_installer_error_quark ())

typedef struct _U1CodecInstaller        U1CodecInstaller;
typedef struct _U1CodecInstallerClass   U1CodecInstallerClass;
typedef struct _U1CodecInstallerPrivate U1CodecInstallerPrivate;
typedef enum   _U1CodecInstallerError   U1CodecInstallerError;

struct _U1CodecInstaller {
	GObject parent;

	U1CodecInstallerPrivate *priv;
};

struct _U1CodecInstallerClass {
	GObjectClass parent_class;

	void (* started)  (U1CodecInstaller *installer);
	void (* finished) (U1CodecInstaller *installer);
	void (* error)    (U1CodecInstaller *installer, GError *error);
};

enum _U1CodecInstallerError {
	U1_CODEC_INSTALLER_ERROR_UNKNOWN = 0,
	U1_CODEC_INSTALLER_ERROR_UNSUPPORTED
};

GType u1_codec_installer_get_type (void);

U1CodecInstaller *u1_codec_installer_new (void);

void  u1_codec_installer_install_codec (U1CodecInstaller *installer,
					GtkWindow *parent_window);
GtkWidget *u1_codec_installer_get_progress_widget (U1CodecInstaller *installer);

GQuark u1_codec_installer_error_quark (void);

#endif
