/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationOOoTaskIdErrorFilter
implements SAXParseExceptionFilter {
    private static final String FILTER_ENTRY = "filter-entry";
    private static final String TASK_ID = "task-id";
    private static final String RESOLVED_IN = "resolved-in";
    int m_nBuildId = 0;
    private HashMap<String, FilterEntry> m_aFilterEntries = new HashMap();
    private HashSet<String> m_aTaskIdsReported = new HashSet();

    public ValidationOOoTaskIdErrorFilter(File aFilterFile, PrintStream aOut) throws ODFValidatorException {
        SAXParser aParser = null;
        Logger aLogger = new Logger(aFilterFile.getAbsolutePath(), "", aOut, Logger.LogLevel.ERROR);
        try {
            SAXParserFactory aParserFactory = SAXParserFactory.newInstance();
            aParserFactory.setNamespaceAware(false);
            aParser = aParserFactory.newSAXParser();
            aParser.parse(aFilterFile, (DefaultHandler)new Handler(this.m_aFilterEntries));
        }
        catch (ParserConfigurationException e) {
            throw new ODFValidatorException(e);
        }
        catch (SAXParseException e) {
            aLogger.logError(e);
            throw new ODFValidatorException(e);
        }
        catch (SAXException e) {
            aLogger.logError(e.getMessage());
            throw new ODFValidatorException(e);
        }
        catch (IOException e) {
            throw new ODFValidatorException(e);
        }
    }

    public SAXParseException filterException(SAXParseException aExc) {
        FilterEntry aEntry;
        if (this.m_nBuildId > 0 && (aEntry = this.m_aFilterEntries.get(aExc.getMessage())) != null && (aEntry.m_nBuildId == 0 || this.m_nBuildId <= aEntry.m_nBuildId)) {
            String aTaskId = aEntry.m_aTaskId;
            if (!this.m_aTaskIdsReported.contains(aTaskId)) {
                this.m_aTaskIdsReported.add(aTaskId);
                return new SAXParseException("Issue " + aTaskId + " found.", aExc.getPublicId(), aExc.getSystemId(), aExc.getLineNumber(), aExc.getColumnNumber(), aExc);
            }
            return null;
        }
        return aExc;
    }

    public void startPackage(String aGenerator) {
        this.m_nBuildId = aGenerator.length() > 0 ? ValidationOOoTaskIdErrorFilter.getBuildId(aGenerator) : 0;
    }

    public void startSubFile() {
        this.m_aTaskIdsReported = new HashSet();
    }

    public void setGenerator(String aGenerator) {
        this.m_nBuildId = aGenerator.length() > 0 ? ValidationOOoTaskIdErrorFilter.getBuildId(aGenerator) : 0;
    }

    public static int getBuildId(String aGenerator) {
        int nBuildId = 0;
        int nPos = aGenerator.indexOf("OpenOffice.org_project/");
        if (nPos > 0 && (nPos = aGenerator.indexOf("Build-", nPos)) > 0) {
            int nStart = nPos + 6;
            nBuildId = Integer.valueOf((nPos = aGenerator.indexOf("$", nStart)) > 0 ? aGenerator.substring(nStart, nPos) : aGenerator.substring(nStart));
        }
        return nBuildId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Handler
    extends DefaultHandler {
        HashMap<String, FilterEntry> m_aFilterEntries;
        Entry m_aEntry = null;

        Handler(HashMap<String, FilterEntry> aFilterEntries) {
            this.m_aFilterEntries = aFilterEntries;
        }

        @Override
        public void characters(char[] aCh, int nStart, int nLength) throws SAXException {
            if (this.m_aEntry != null) {
                this.m_aEntry.m_aMessage = this.m_aEntry.m_aMessage + new String(aCh, nStart, nLength);
            }
        }

        @Override
        public void startElement(String aUri, String aLocalName, String aQName, Attributes aAttributes) throws SAXException {
            String aTaskId;
            if (aQName.equals(ValidationOOoTaskIdErrorFilter.FILTER_ENTRY) && (aTaskId = aAttributes.getValue(ValidationOOoTaskIdErrorFilter.TASK_ID)) != null) {
                this.m_aEntry = new Entry(aTaskId);
                String aBuildId = aAttributes.getValue(ValidationOOoTaskIdErrorFilter.RESOLVED_IN);
                if (aBuildId != null && aBuildId.length() > 0) {
                    this.m_aEntry.m_nBuildId = Integer.valueOf(aBuildId);
                }
            }
        }

        @Override
        public void endElement(String aUri, String aLocalName, String aQName) throws SAXException {
            if (aQName.equals(ValidationOOoTaskIdErrorFilter.FILTER_ENTRY) && this.m_aEntry != null) {
                this.m_aFilterEntries.put(this.m_aEntry.m_aMessage, new FilterEntry(this.m_aEntry.m_aTask, this.m_aEntry.m_nBuildId));
            }
        }

        class Entry {
            String m_aMessage = "";
            String m_aTask = "";
            int m_nBuildId = 0;

            Entry(String aTask) {
                this.m_aTask = aTask;
            }
        }
    }

    class FilterEntry {
        String m_aTaskId;
        int m_nBuildId;

        FilterEntry(String aTaskId, int nBuildId) {
            this.m_aTaskId = aTaskId;
            this.m_nBuildId = nBuildId;
        }
    }
}

