/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.IOException;
import java.io.StringReader;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ManifestEntry;
import org.odftoolkit.odfvalidator.ManifestEntryListener;
import org.odftoolkit.odfvalidator.ManifestListener;
import org.odftoolkit.odfvalidator.NamespaceFilter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ManifestFilter
extends NamespaceFilter {
    private static final String OOO_MANIFEST_PUBLIC_ID = "-//OpenOffice.org//DTD Manifest 1.0//EN";
    private static final String OOO_MANIFEST_NAMESPACE_URI = "http://openoffice.org/2001/manifest";
    private static final String MANIFEST_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
    private static final String FILE_ENTRY = "file-entry";
    private static final String FULL_PATH = "full-path";
    private static final String MEDIA_TYPE = "media-type";
    private Logger m_aLogger;
    private ManifestListener m_aManifestListener = null;
    private ManifestEntryListener m_aManifestEntryListener = null;

    ManifestFilter(Logger aLogger, ManifestListener aManifestListener, ManifestEntryListener aManifestEntryListener) {
        this.m_aLogger = aLogger;
        this.m_aManifestListener = aManifestListener;
        this.m_aManifestEntryListener = aManifestEntryListener;
    }

    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        if (aPublicId.equals(OOO_MANIFEST_PUBLIC_ID)) {
            String aMsg = "Ignoring doctype definition '-//OpenOffice.org//DTD Manifest 1.0//EN' (has been stored by old OOo versions)";
            this.m_aLogger.logInfo(aMsg, false);
            return new InputSource(new StringReader(""));
        }
        return super.resolveEntity(aPublicId, aSystemId);
    }

    String adaptNamespaceUri(String aUri, String aPrefix) {
        String aNewUri = null;
        if (aUri.equals(OOO_MANIFEST_NAMESPACE_URI)) {
            aNewUri = MANIFEST_NAMESPACE_URI;
        }
        return aNewUri;
    }

    void namespaceUriAdapted(String aUri, String aNewUri) {
        String aMsg = "Adapting OpenOffice.org namspace'" + aUri + "' (has been stored by old OOo versions)";
        this.m_aLogger.logInfo(aMsg, false);
    }

    public void startElement(String aUri, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        super.startElement(aUri, aLocalName, aQName, aAtts);
        if ((aUri.equals(MANIFEST_NAMESPACE_URI) || aUri.equals(OOO_MANIFEST_NAMESPACE_URI)) && aLocalName.equals(FILE_ENTRY)) {
            String aFullPath = aAtts.getValue(aUri, FULL_PATH);
            String aMediaType = aAtts.getValue(aUri, MEDIA_TYPE);
            if (aFullPath != null) {
                if (aFullPath.equals("/")) {
                    if (this.m_aManifestListener != null) {
                        this.m_aManifestListener.setMediaType(aMediaType);
                    }
                } else if (this.m_aManifestEntryListener != null) {
                    this.m_aManifestEntryListener.foundManifestEntry(new ManifestEntry(aFullPath, aMediaType));
                }
            }
        }
    }
}

