/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef EBOOKBITSTREAMTEST_H_INCLUDED
#define EBOOKBITSTREAMTEST_H_INCLUDED

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

namespace test
{

class EBOOKBitStreamTest : public CPPUNIT_NS::TestFixture
{
public:
  virtual void setUp();
  virtual void tearDown();

private:
  CPPUNIT_TEST_SUITE(EBOOKBitStreamTest);
  CPPUNIT_TEST(testRead1);
  CPPUNIT_TEST(testRead3);
  CPPUNIT_TEST(testRead4);
  CPPUNIT_TEST(testRead8);
  CPPUNIT_TEST(testRead16);
  CPPUNIT_TEST(testRead32);
  CPPUNIT_TEST(testReadVaryingSmall);
  CPPUNIT_TEST(testReadVaryingBig);

  CPPUNIT_TEST(testAtLastByte);
  CPPUNIT_TEST_SUITE_END();

private:
  void testRead1();
  void testRead3();
  void testRead4();
  void testRead8();
  void testRead16();
  void testRead32();
  void testReadVaryingSmall();
  void testReadVaryingBig();

  void testRead1(bool bigEndian);
  void testRead3(bool bigEndian);
  void testRead4(bool bigEndian);
  void testRead8(bool bigEndian);
  void testReadVaryingSmall(bool bigEndian);

  void testAtLastByte();
};

}

#endif // EBOOKBITSTREAMTEST_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
