// Copyright 2014 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#ifndef FXBARCODE_COMMON_REEDSOLOMON_BC_REEDSOLOMON_H_
#define FXBARCODE_COMMON_REEDSOLOMON_BC_REEDSOLOMON_H_

#include <vector>

#include "core/fxcrt/fx_basic.h"

class CBC_ReedSolomonGF256;
class CBC_ReedSolomonGF256Poly;

class CBC_ReedSolomonEncoder {
 public:
  explicit CBC_ReedSolomonEncoder(CBC_ReedSolomonGF256* field);
  virtual ~CBC_ReedSolomonEncoder();

  void Encode(std::vector<int32_t>* toEncode, size_t ecBytes, int32_t& e);
  virtual void Init();

 private:
  CBC_ReedSolomonGF256Poly* BuildGenerator(size_t degree, int32_t& e);

  CBC_ReedSolomonGF256* m_field;
  std::vector<CBC_ReedSolomonGF256Poly*> m_cachedGenerators;
};

#endif  // FXBARCODE_COMMON_REEDSOLOMON_BC_REEDSOLOMON_H_
