/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

/**
 * Rule :
 * Hangule johap code => unicode
 * Hanja johap code => ks code => unicode
 * Special johap code => ks code => unicode
 */
#include "precompile.h"
#include <sal/types.h>
#include <sal/macros.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#ifdef WIN32
#include <float.h>
#define isnan _isnan
#endif
#include "hcode.h"
#include "ksc5601.h"

#define PI 3.14159265358979323846

static hchar jaso2ks(hchar hh);

/* Conversion table.  */
#define KSC5601_HANJA  4888
#define KSC5601_SYMBOL  986

// ccvHH2ASC    code convert HWP20 to ASC(KSSM)

#define HCA_HALFCH      0x3000
#define HCA_KSS         0x3400
#define HCA_TG          0x37C0
#define none            0x3401                    /* 2.0 null code - space */
#define noneha          0x00A0
#define noneks          0xA1A1
#define none1x          0x2402

#define UNI_HANGUL_FIRST        0xac00
#define UNI_COMP_JAMO_FIRST	  0x3131

#define NUM_CHOSEONG            19
#define NUM_JOONGSEONG          21
#define NUM_JONGSEONG           28


#define IDX_INVALID     0xFF

/**
 * kssm code table matching with ks index
 */
static hchar ksTbl[2350] =
{
    0x8861, 0x8862, 0x8865, 0x8868, 0x8869, 0x886A, 0x886B, 0x8871,
    0x8873, 0x8874, 0x8875, 0x8876, 0x8877, 0x8878, 0x8879, 0x887B,
    0x887C, 0x887D, 0x8881, 0x8882, 0x8885, 0x8889, 0x8891, 0x8893,
    0x8895, 0x8896, 0x8897, 0x88A1, 0x88A2, 0x88A5, 0x88A9, 0x88B5,
    0x88B7, 0x88C1, 0x88C5, 0x88C9, 0x88E1, 0x88E2, 0x88E5, 0x88E8,
    0x88E9, 0x88EB, 0x88F1, 0x88F3, 0x88F5, 0x88F6, 0x88F7, 0x88F8,
    0x88FB, 0x88FC, 0x88FD, 0x8941, 0x8945, 0x8949, 0x8951, 0x8953,
    0x8955, 0x8956, 0x8957, 0x8961, 0x8962, 0x8963, 0x8965, 0x8968,
    0x8969, 0x8971, 0x8973, 0x8975, 0x8976, 0x8977, 0x897B, 0x8981,
    0x8985, 0x8989, 0x8993, 0x8995, 0x89A1, 0x89A2, 0x89A5, 0x89A8,
    0x89A9, 0x89AB, 0x89AD, 0x89B0, 0x89B1, 0x89B3, 0x89B5, 0x89B7,
    0x89B8, 0x89C1, 0x89C2, 0x89C5, 0x89C9, 0x89CB, 0x89D1, 0x89D3,
    0x89D5, 0x89D7, 0x89E1, 0x89E5, 0x89E9, 0x89F3, 0x89F6, 0x89F7,
    0x8A41, 0x8A42, 0x8A45, 0x8A49, 0x8A51, 0x8A53, 0x8A55, 0x8A57,
    0x8A61, 0x8A65, 0x8A69, 0x8A73, 0x8A75, 0x8A81, 0x8A82, 0x8A85,
    0x8A88, 0x8A89, 0x8A8A, 0x8A8B, 0x8A90, 0x8A91, 0x8A93, 0x8A95,
    0x8A97, 0x8A98, 0x8AA1, 0x8AA2, 0x8AA5, 0x8AA9, 0x8AB6, 0x8AB7,
    0x8AC1, 0x8AD5, 0x8AE1, 0x8AE2, 0x8AE5, 0x8AE9, 0x8AF1, 0x8AF3,
    0x8AF5, 0x8B41, 0x8B45, 0x8B49, 0x8B61, 0x8B62, 0x8B65, 0x8B68,
    0x8B69, 0x8B6A, 0x8B71, 0x8B73, 0x8B75, 0x8B77, 0x8B81, 0x8BA1,
    0x8BA2, 0x8BA5, 0x8BA8, 0x8BA9, 0x8BAB, 0x8BB1, 0x8BB3, 0x8BB5,
    0x8BB7, 0x8BB8, 0x8BBC, 0x8C61, 0x8C62, 0x8C63, 0x8C65, 0x8C69,
    0x8C6B, 0x8C71, 0x8C73, 0x8C75, 0x8C76, 0x8C77, 0x8C7B, 0x8C81,
    0x8C82, 0x8C85, 0x8C89, 0x8C91, 0x8C93, 0x8C95, 0x8C96, 0x8C97,
    0x8CA1, 0x8CA2, 0x8CA9, 0x8CE1, 0x8CE2, 0x8CE3, 0x8CE5, 0x8CE9,
    0x8CF1, 0x8CF3, 0x8CF5, 0x8CF6, 0x8CF7, 0x8D41, 0x8D42, 0x8D45,
    0x8D51, 0x8D55, 0x8D57, 0x8D61, 0x8D65, 0x8D69, 0x8D75, 0x8D76,
    0x8D7B, 0x8D81, 0x8DA1, 0x8DA2, 0x8DA5, 0x8DA7, 0x8DA9, 0x8DB1,
    0x8DB3, 0x8DB5, 0x8DB7, 0x8DB8, 0x8DB9, 0x8DC1, 0x8DC2, 0x8DC9,
    0x8DD6, 0x8DD7, 0x8DE1, 0x8DE2, 0x8DF7, 0x8E41, 0x8E45, 0x8E49,
    0x8E51, 0x8E53, 0x8E57, 0x8E61, 0x8E81, 0x8E82, 0x8E85, 0x8E89,
    0x8E90, 0x8E91, 0x8E93, 0x8E95, 0x8E97, 0x8E98, 0x8EA1, 0x8EA9,
    0x8EB6, 0x8EB7, 0x8EC1, 0x8EC2, 0x8EC5, 0x8EC9, 0x8ED1, 0x8ED3,
    0x8ED6, 0x8EE1, 0x8EE5, 0x8EE9, 0x8EF1, 0x8EF3, 0x8F41, 0x8F61,
    0x8F62, 0x8F65, 0x8F67, 0x8F69, 0x8F6B, 0x8F70, 0x8F71, 0x8F73,
    0x8F75, 0x8F77, 0x8F7B, 0x8FA1, 0x8FA2, 0x8FA5, 0x8FA9, 0x8FB1,
    0x8FB3, 0x8FB5, 0x8FB7, 0x9061, 0x9062, 0x9063, 0x9065, 0x9068,
    0x9069, 0x906A, 0x906B, 0x9071, 0x9073, 0x9075, 0x9076, 0x9077,
    0x9078, 0x9079, 0x907B, 0x907D, 0x9081, 0x9082, 0x9085, 0x9089,
    0x9091, 0x9093, 0x9095, 0x9096, 0x9097, 0x90A1, 0x90A2, 0x90A5,
    0x90A9, 0x90B1, 0x90B7, 0x90E1, 0x90E2, 0x90E4, 0x90E5, 0x90E9,
    0x90EB, 0x90EC, 0x90F1, 0x90F3, 0x90F5, 0x90F6, 0x90F7, 0x90FD,
    0x9141, 0x9142, 0x9145, 0x9149, 0x9151, 0x9153, 0x9155, 0x9156,
    0x9157, 0x9161, 0x9162, 0x9165, 0x9169, 0x9171, 0x9173, 0x9176,
    0x9177, 0x917A, 0x9181, 0x9185, 0x91A1, 0x91A2, 0x91A5, 0x91A9,
    0x91AB, 0x91B1, 0x91B3, 0x91B5, 0x91B7, 0x91BC, 0x91BD, 0x91C1,
    0x91C5, 0x91C9, 0x91D6, 0x9241, 0x9245, 0x9249, 0x9251, 0x9253,
    0x9255, 0x9261, 0x9262, 0x9265, 0x9269, 0x9273, 0x9275, 0x9277,
    0x9281, 0x9282, 0x9285, 0x9288, 0x9289, 0x9291, 0x9293, 0x9295,
    0x9297, 0x92A1, 0x92B6, 0x92C1, 0x92E1, 0x92E5, 0x92E9, 0x92F1,
    0x92F3, 0x9341, 0x9342, 0x9349, 0x9351, 0x9353, 0x9357, 0x9361,
    0x9362, 0x9365, 0x9369, 0x936A, 0x936B, 0x9371, 0x9373, 0x9375,
    0x9377, 0x9378, 0x937C, 0x9381, 0x9385, 0x9389, 0x93A1, 0x93A2,
    0x93A5, 0x93A9, 0x93AF, 0x93B1, 0x93B3, 0x93B5, 0x93B7, 0x93BC,
    0x9461, 0x9462, 0x9463, 0x9465, 0x9468, 0x9469, 0x946A, 0x946B,
    0x946C, 0x9470, 0x9471, 0x9473, 0x9475, 0x9476, 0x9477, 0x9478,
    0x9479, 0x947D, 0x9481, 0x9482, 0x9485, 0x9489, 0x9491, 0x9493,
    0x9495, 0x9496, 0x9497, 0x94A1, 0x94E1, 0x94E2, 0x94E3, 0x94E5,
    0x94E8, 0x94E9, 0x94EB, 0x94EC, 0x94F1, 0x94F3, 0x94F5, 0x94F7,
    0x94F9, 0x94FC, 0x9541, 0x9542, 0x9545, 0x9549, 0x9551, 0x9553,
    0x9555, 0x9556, 0x9557, 0x9561, 0x9565, 0x9569, 0x9576, 0x9577,
    0x9581, 0x9585, 0x95A1, 0x95A2, 0x95A5, 0x95A8, 0x95A9, 0x95AB,
    0x95AD, 0x95B1, 0x95B3, 0x95B5, 0x95B7, 0x95B9, 0x95BB, 0x95C1,
    0x95C5, 0x95C9, 0x95E1, 0x95F6, 0x9641, 0x9645, 0x9649, 0x9651,
    0x9653, 0x9655, 0x9661, 0x9681, 0x9682, 0x9685, 0x9689, 0x9691,
    0x9693, 0x9695, 0x9697, 0x96A1, 0x96B6, 0x96C1, 0x96D7, 0x96E1,
    0x96E5, 0x96E9, 0x96F3, 0x96F5, 0x96F7, 0x9741, 0x9745, 0x9749,
    0x9751, 0x9757, 0x9761, 0x9762, 0x9765, 0x9768, 0x9769, 0x976B,
    0x9771, 0x9773, 0x9775, 0x9777, 0x9781, 0x97A1, 0x97A2, 0x97A5,
    0x97A8, 0x97A9, 0x97B1, 0x97B3, 0x97B5, 0x97B6, 0x97B7, 0x97B8,
    0x9861, 0x9862, 0x9865, 0x9869, 0x9871, 0x9873, 0x9875, 0x9876,
    0x9877, 0x987D, 0x9881, 0x9882, 0x9885, 0x9889, 0x9891, 0x9893,
    0x9895, 0x9896, 0x9897, 0x98E1, 0x98E2, 0x98E5, 0x98E9, 0x98EB,
    0x98EC, 0x98F1, 0x98F3, 0x98F5, 0x98F6, 0x98F7, 0x98FD, 0x9941,
    0x9942, 0x9945, 0x9949, 0x9951, 0x9953, 0x9955, 0x9956, 0x9957,
    0x9961, 0x9976, 0x99A1, 0x99A2, 0x99A5, 0x99A9, 0x99B7, 0x99C1,
    0x99C9, 0x99E1, 0x9A41, 0x9A45, 0x9A81, 0x9A82, 0x9A85, 0x9A89,
    0x9A90, 0x9A91, 0x9A97, 0x9AC1, 0x9AE1, 0x9AE5, 0x9AE9, 0x9AF1,
    0x9AF3, 0x9AF7, 0x9B61, 0x9B62, 0x9B65, 0x9B68, 0x9B69, 0x9B71,
    0x9B73, 0x9B75, 0x9B81, 0x9B85, 0x9B89, 0x9B91, 0x9B93, 0x9BA1,
    0x9BA5, 0x9BA9, 0x9BB1, 0x9BB3, 0x9BB5, 0x9BB7, 0x9C61, 0x9C62,
    0x9C65, 0x9C69, 0x9C71, 0x9C73, 0x9C75, 0x9C76, 0x9C77, 0x9C78,
    0x9C7C, 0x9C7D, 0x9C81, 0x9C82, 0x9C85, 0x9C89, 0x9C91, 0x9C93,
    0x9C95, 0x9C96, 0x9C97, 0x9CA1, 0x9CA2, 0x9CA5, 0x9CB5, 0x9CB7,
    0x9CE1, 0x9CE2, 0x9CE5, 0x9CE9, 0x9CF1, 0x9CF3, 0x9CF5, 0x9CF6,
    0x9CF7, 0x9CFD, 0x9D41, 0x9D42, 0x9D45, 0x9D49, 0x9D51, 0x9D53,
    0x9D55, 0x9D57, 0x9D61, 0x9D62, 0x9D65, 0x9D69, 0x9D71, 0x9D73,
    0x9D75, 0x9D76, 0x9D77, 0x9D81, 0x9D85, 0x9D93, 0x9D95, 0x9DA1,
    0x9DA2, 0x9DA5, 0x9DA9, 0x9DB1, 0x9DB3, 0x9DB5, 0x9DB7, 0x9DC1,
    0x9DC5, 0x9DD7, 0x9DF6, 0x9E41, 0x9E45, 0x9E49, 0x9E51, 0x9E53,
    0x9E55, 0x9E57, 0x9E61, 0x9E65, 0x9E69, 0x9E73, 0x9E75, 0x9E77,
    0x9E81, 0x9E82, 0x9E85, 0x9E89, 0x9E91, 0x9E93, 0x9E95, 0x9E97,
    0x9EA1, 0x9EB6, 0x9EC1, 0x9EE1, 0x9EE2, 0x9EE5, 0x9EE9, 0x9EF1,
    0x9EF5, 0x9EF7, 0x9F41, 0x9F42, 0x9F45, 0x9F49, 0x9F51, 0x9F53,
    0x9F55, 0x9F57, 0x9F61, 0x9F62, 0x9F65, 0x9F69, 0x9F71, 0x9F73,
    0x9F75, 0x9F77, 0x9F78, 0x9F7B, 0x9F7C, 0x9FA1, 0x9FA2, 0x9FA5,
    0x9FA9, 0x9FB1, 0x9FB3, 0x9FB5, 0x9FB7, 0xA061, 0xA062, 0xA065,
    0xA067, 0xA068, 0xA069, 0xA06A, 0xA06B, 0xA071, 0xA073, 0xA075,
    0xA077, 0xA078, 0xA07B, 0xA07D, 0xA081, 0xA082, 0xA085, 0xA089,
    0xA091, 0xA093, 0xA095, 0xA096, 0xA097, 0xA098, 0xA0A1, 0xA0A2,
    0xA0A9, 0xA0B7, 0xA0E1, 0xA0E2, 0xA0E5, 0xA0E9, 0xA0EB, 0xA0F1,
    0xA0F3, 0xA0F5, 0xA0F7, 0xA0F8, 0xA0FD, 0xA141, 0xA142, 0xA145,
    0xA149, 0xA151, 0xA153, 0xA155, 0xA156, 0xA157, 0xA161, 0xA162,
    0xA165, 0xA169, 0xA175, 0xA176, 0xA177, 0xA179, 0xA181, 0xA1A1,
    0xA1A2, 0xA1A4, 0xA1A5, 0xA1A9, 0xA1AB, 0xA1B1, 0xA1B3, 0xA1B5,
    0xA1B7, 0xA1C1, 0xA1C5, 0xA1D6, 0xA1D7, 0xA241, 0xA245, 0xA249,
    0xA253, 0xA255, 0xA257, 0xA261, 0xA265, 0xA269, 0xA273, 0xA275,
    0xA281, 0xA282, 0xA283, 0xA285, 0xA288, 0xA289, 0xA28A, 0xA28B,
    0xA291, 0xA293, 0xA295, 0xA297, 0xA29B, 0xA29D, 0xA2A1, 0xA2A5,
    0xA2A9, 0xA2B3, 0xA2B5, 0xA2C1, 0xA2E1, 0xA2E5, 0xA2E9, 0xA341,
    0xA345, 0xA349, 0xA351, 0xA355, 0xA361, 0xA365, 0xA369, 0xA371,
    0xA375, 0xA3A1, 0xA3A2, 0xA3A5, 0xA3A8, 0xA3A9, 0xA3AB, 0xA3B1,
    0xA3B3, 0xA3B5, 0xA3B6, 0xA3B7, 0xA3B9, 0xA3BB, 0xA461, 0xA462,
    0xA463, 0xA464, 0xA465, 0xA468, 0xA469, 0xA46A, 0xA46B, 0xA46C,
    0xA471, 0xA473, 0xA475, 0xA477, 0xA47B, 0xA481, 0xA482, 0xA485,
    0xA489, 0xA491, 0xA493, 0xA495, 0xA496, 0xA497, 0xA49B, 0xA4A1,
    0xA4A2, 0xA4A5, 0xA4B3, 0xA4E1, 0xA4E2, 0xA4E5, 0xA4E8, 0xA4E9,
    0xA4EB, 0xA4F1, 0xA4F3, 0xA4F5, 0xA4F7, 0xA4F8, 0xA541, 0xA542,
    0xA545, 0xA548, 0xA549, 0xA551, 0xA553, 0xA555, 0xA556, 0xA557,
    0xA561, 0xA562, 0xA565, 0xA569, 0xA573, 0xA575, 0xA576, 0xA577,
    0xA57B, 0xA581, 0xA585, 0xA5A1, 0xA5A2, 0xA5A3, 0xA5A5, 0xA5A9,
    0xA5B1, 0xA5B3, 0xA5B5, 0xA5B7, 0xA5C1, 0xA5C5, 0xA5D6, 0xA5E1,
    0xA5F6, 0xA641, 0xA642, 0xA645, 0xA649, 0xA651, 0xA653, 0xA661,
    0xA665, 0xA681, 0xA682, 0xA685, 0xA688, 0xA689, 0xA68A, 0xA68B,
    0xA691, 0xA693, 0xA695, 0xA697, 0xA69B, 0xA69C, 0xA6A1, 0xA6A9,
    0xA6B6, 0xA6C1, 0xA6E1, 0xA6E2, 0xA6E5, 0xA6E9, 0xA6F7, 0xA741,
    0xA745, 0xA749, 0xA751, 0xA755, 0xA757, 0xA761, 0xA762, 0xA765,
    0xA769, 0xA771, 0xA773, 0xA775, 0xA7A1, 0xA7A2, 0xA7A5, 0xA7A9,
    0xA7AB, 0xA7B1, 0xA7B3, 0xA7B5, 0xA7B7, 0xA7B8, 0xA7B9, 0xA861,
    0xA862, 0xA865, 0xA869, 0xA86B, 0xA871, 0xA873, 0xA875, 0xA876,
    0xA877, 0xA87D, 0xA881, 0xA882, 0xA885, 0xA889, 0xA891, 0xA893,
    0xA895, 0xA896, 0xA897, 0xA8A1, 0xA8A2, 0xA8B1, 0xA8E1, 0xA8E2,
    0xA8E5, 0xA8E8, 0xA8E9, 0xA8F1, 0xA8F5, 0xA8F6, 0xA8F7, 0xA941,
    0xA957, 0xA961, 0xA962, 0xA971, 0xA973, 0xA975, 0xA976, 0xA977,
    0xA9A1, 0xA9A2, 0xA9A5, 0xA9A9, 0xA9B1, 0xA9B3, 0xA9B7, 0xAA41,
    0xAA61, 0xAA77, 0xAA81, 0xAA82, 0xAA85, 0xAA89, 0xAA91, 0xAA95,
    0xAA97, 0xAB41, 0xAB57, 0xAB61, 0xAB65, 0xAB69, 0xAB71, 0xAB73,
    0xABA1, 0xABA2, 0xABA5, 0xABA9, 0xABB1, 0xABB3, 0xABB5, 0xABB7,
    0xAC61, 0xAC62, 0xAC64, 0xAC65, 0xAC68, 0xAC69, 0xAC6A, 0xAC6B,
    0xAC71, 0xAC73, 0xAC75, 0xAC76, 0xAC77, 0xAC7B, 0xAC81, 0xAC82,
    0xAC85, 0xAC89, 0xAC91, 0xAC93, 0xAC95, 0xAC96, 0xAC97, 0xACA1,
    0xACA2, 0xACA5, 0xACA9, 0xACB1, 0xACB3, 0xACB5, 0xACB7, 0xACC1,
    0xACC5, 0xACC9, 0xACD1, 0xACD7, 0xACE1, 0xACE2, 0xACE3, 0xACE4,
    0xACE5, 0xACE8, 0xACE9, 0xACEB, 0xACEC, 0xACF1, 0xACF3, 0xACF5,
    0xACF6, 0xACF7, 0xACFC, 0xAD41, 0xAD42, 0xAD45, 0xAD49, 0xAD51,
    0xAD53, 0xAD55, 0xAD56, 0xAD57, 0xAD61, 0xAD62, 0xAD65, 0xAD69,
    0xAD71, 0xAD73, 0xAD75, 0xAD76, 0xAD77, 0xAD81, 0xAD85, 0xAD89,
    0xAD97, 0xADA1, 0xADA2, 0xADA3, 0xADA5, 0xADA9, 0xADAB, 0xADB1,
    0xADB3, 0xADB5, 0xADB7, 0xADBB, 0xADC1, 0xADC2, 0xADC5, 0xADC9,
    0xADD7, 0xADE1, 0xADE5, 0xADE9, 0xADF1, 0xADF5, 0xADF6, 0xAE41,
    0xAE45, 0xAE49, 0xAE51, 0xAE53, 0xAE55, 0xAE61, 0xAE62, 0xAE65,
    0xAE69, 0xAE71, 0xAE73, 0xAE75, 0xAE77, 0xAE81, 0xAE82, 0xAE85,
    0xAE88, 0xAE89, 0xAE91, 0xAE93, 0xAE95, 0xAE97, 0xAE99, 0xAE9B,
    0xAE9C, 0xAEA1, 0xAEB6, 0xAEC1, 0xAEC2, 0xAEC5, 0xAEC9, 0xAED1,
    0xAED7, 0xAEE1, 0xAEE2, 0xAEE5, 0xAEE9, 0xAEF1, 0xAEF3, 0xAEF5,
    0xAEF7, 0xAF41, 0xAF42, 0xAF49, 0xAF51, 0xAF55, 0xAF57, 0xAF61,
    0xAF62, 0xAF65, 0xAF69, 0xAF6A, 0xAF71, 0xAF73, 0xAF75, 0xAF77,
    0xAFA1, 0xAFA2, 0xAFA5, 0xAFA8, 0xAFA9, 0xAFB0, 0xAFB1, 0xAFB3,
    0xAFB5, 0xAFB7, 0xAFBC, 0xB061, 0xB062, 0xB064, 0xB065, 0xB069,
    0xB071, 0xB073, 0xB076, 0xB077, 0xB07D, 0xB081, 0xB082, 0xB085,
    0xB089, 0xB091, 0xB093, 0xB096, 0xB097, 0xB0B7, 0xB0E1, 0xB0E2,
    0xB0E5, 0xB0E9, 0xB0EB, 0xB0F1, 0xB0F3, 0xB0F6, 0xB0F7, 0xB141,
    0xB145, 0xB149, 0xB185, 0xB1A1, 0xB1A2, 0xB1A5, 0xB1A8, 0xB1A9,
    0xB1AB, 0xB1B1, 0xB1B3, 0xB1B7, 0xB1C1, 0xB1C2, 0xB1C5, 0xB1D6,
    0xB1E1, 0xB1F6, 0xB241, 0xB245, 0xB249, 0xB251, 0xB253, 0xB261,
    0xB281, 0xB282, 0xB285, 0xB289, 0xB291, 0xB293, 0xB297, 0xB2A1,
    0xB2B6, 0xB2C1, 0xB2E1, 0xB2E5, 0xB357, 0xB361, 0xB362, 0xB365,
    0xB369, 0xB36B, 0xB370, 0xB371, 0xB373, 0xB381, 0xB385, 0xB389,
    0xB391, 0xB3A1, 0xB3A2, 0xB3A5, 0xB3A9, 0xB3B1, 0xB3B3, 0xB3B5,
    0xB3B7, 0xB461, 0xB462, 0xB465, 0xB466, 0xB467, 0xB469, 0xB46A,
    0xB46B, 0xB470, 0xB471, 0xB473, 0xB475, 0xB476, 0xB477, 0xB47B,
    0xB47C, 0xB481, 0xB482, 0xB485, 0xB489, 0xB491, 0xB493, 0xB495,
    0xB496, 0xB497, 0xB4A1, 0xB4A2, 0xB4A5, 0xB4A9, 0xB4AC, 0xB4B1,
    0xB4B3, 0xB4B5, 0xB4B7, 0xB4BB, 0xB4BD, 0xB4C1, 0xB4C5, 0xB4C9,
    0xB4D3, 0xB4E1, 0xB4E2, 0xB4E5, 0xB4E6, 0xB4E8, 0xB4E9, 0xB4EA,
    0xB4EB, 0xB4F1, 0xB4F3, 0xB4F4, 0xB4F5, 0xB4F6, 0xB4F7, 0xB4F8,
    0xB4FA, 0xB4FC, 0xB541, 0xB542, 0xB545, 0xB549, 0xB551, 0xB553,
    0xB555, 0xB557, 0xB561, 0xB562, 0xB563, 0xB565, 0xB569, 0xB56B,
    0xB56C, 0xB571, 0xB573, 0xB574, 0xB575, 0xB576, 0xB577, 0xB57B,
    0xB57C, 0xB57D, 0xB581, 0xB585, 0xB589, 0xB591, 0xB593, 0xB595,
    0xB596, 0xB5A1, 0xB5A2, 0xB5A5, 0xB5A9, 0xB5AA, 0xB5AB, 0xB5AD,
    0xB5B0, 0xB5B1, 0xB5B3, 0xB5B5, 0xB5B7, 0xB5B9, 0xB5C1, 0xB5C2,
    0xB5C5, 0xB5C9, 0xB5D1, 0xB5D3, 0xB5D5, 0xB5D6, 0xB5D7, 0xB5E1,
    0xB5E2, 0xB5E5, 0xB5F1, 0xB5F5, 0xB5F7, 0xB641, 0xB642, 0xB645,
    0xB649, 0xB651, 0xB653, 0xB655, 0xB657, 0xB661, 0xB662, 0xB665,
    0xB669, 0xB671, 0xB673, 0xB675, 0xB677, 0xB681, 0xB682, 0xB685,
    0xB689, 0xB68A, 0xB68B, 0xB691, 0xB693, 0xB695, 0xB697, 0xB6A1,
    0xB6A2, 0xB6A5, 0xB6A9, 0xB6B1, 0xB6B3, 0xB6B6, 0xB6B7, 0xB6C1,
    0xB6C2, 0xB6C5, 0xB6C9, 0xB6D1, 0xB6D3, 0xB6D7, 0xB6E1, 0xB6E2,
    0xB6E5, 0xB6E9, 0xB6F1, 0xB6F3, 0xB6F5, 0xB6F7, 0xB741, 0xB742,
    0xB745, 0xB749, 0xB751, 0xB753, 0xB755, 0xB757, 0xB759, 0xB761,
    0xB762, 0xB765, 0xB769, 0xB76F, 0xB771, 0xB773, 0xB775, 0xB777,
    0xB778, 0xB779, 0xB77A, 0xB77B, 0xB77C, 0xB77D, 0xB781, 0xB785,
    0xB789, 0xB791, 0xB795, 0xB7A1, 0xB7A2, 0xB7A5, 0xB7A9, 0xB7AA,
    0xB7AB, 0xB7B0, 0xB7B1, 0xB7B3, 0xB7B5, 0xB7B6, 0xB7B7, 0xB7B8,
    0xB7BC, 0xB861, 0xB862, 0xB865, 0xB867, 0xB868, 0xB869, 0xB86B,
    0xB871, 0xB873, 0xB875, 0xB876, 0xB877, 0xB878, 0xB881, 0xB882,
    0xB885, 0xB889, 0xB891, 0xB893, 0xB895, 0xB896, 0xB897, 0xB8A1,
    0xB8A2, 0xB8A5, 0xB8A7, 0xB8A9, 0xB8B1, 0xB8B7, 0xB8C1, 0xB8C5,
    0xB8C9, 0xB8E1, 0xB8E2, 0xB8E5, 0xB8E9, 0xB8EB, 0xB8F1, 0xB8F3,
    0xB8F5, 0xB8F7, 0xB8F8, 0xB941, 0xB942, 0xB945, 0xB949, 0xB951,
    0xB953, 0xB955, 0xB957, 0xB961, 0xB965, 0xB969, 0xB971, 0xB973,
    0xB976, 0xB977, 0xB981, 0xB9A1, 0xB9A2, 0xB9A5, 0xB9A9, 0xB9AB,
    0xB9B1, 0xB9B3, 0xB9B5, 0xB9B7, 0xB9B8, 0xB9B9, 0xB9BD, 0xB9C1,
    0xB9C2, 0xB9C9, 0xB9D3, 0xB9D5, 0xB9D7, 0xB9E1, 0xB9F6, 0xB9F7,
    0xBA41, 0xBA45, 0xBA49, 0xBA51, 0xBA53, 0xBA55, 0xBA57, 0xBA61,
    0xBA62, 0xBA65, 0xBA77, 0xBA81, 0xBA82, 0xBA85, 0xBA89, 0xBA8A,
    0xBA8B, 0xBA91, 0xBA93, 0xBA95, 0xBA97, 0xBAA1, 0xBAB6, 0xBAC1,
    0xBAE1, 0xBAE2, 0xBAE5, 0xBAE9, 0xBAF1, 0xBAF3, 0xBAF5, 0xBB41,
    0xBB45, 0xBB49, 0xBB51, 0xBB61, 0xBB62, 0xBB65, 0xBB69, 0xBB71,
    0xBB73, 0xBB75, 0xBB77, 0xBBA1, 0xBBA2, 0xBBA5, 0xBBA8, 0xBBA9,
    0xBBAB, 0xBBB1, 0xBBB3, 0xBBB5, 0xBBB7, 0xBBB8, 0xBBBB, 0xBBBC,
    0xBC61, 0xBC62, 0xBC65, 0xBC67, 0xBC69, 0xBC6C, 0xBC71, 0xBC73,
    0xBC75, 0xBC76, 0xBC77, 0xBC81, 0xBC82, 0xBC85, 0xBC89, 0xBC91,
    0xBC93, 0xBC95, 0xBC96, 0xBC97, 0xBCA1, 0xBCA5, 0xBCB7, 0xBCE1,
    0xBCE2, 0xBCE5, 0xBCE9, 0xBCF1, 0xBCF3, 0xBCF5, 0xBCF6, 0xBCF7,
    0xBD41, 0xBD57, 0xBD61, 0xBD76, 0xBDA1, 0xBDA2, 0xBDA5, 0xBDA9,
    0xBDB1, 0xBDB3, 0xBDB5, 0xBDB7, 0xBDB9, 0xBDC1, 0xBDC2, 0xBDC9,
    0xBDD6, 0xBDE1, 0xBDF6, 0xBE41, 0xBE45, 0xBE49, 0xBE51, 0xBE53,
    0xBE77, 0xBE81, 0xBE82, 0xBE85, 0xBE89, 0xBE91, 0xBE93, 0xBE97,
    0xBEA1, 0xBEB6, 0xBEB7, 0xBEE1, 0xBF41, 0xBF61, 0xBF71, 0xBF75,
    0xBF77, 0xBFA1, 0xBFA2, 0xBFA5, 0xBFA9, 0xBFB1, 0xBFB3, 0xBFB7,
    0xBFB8, 0xBFBD, 0xC061, 0xC062, 0xC065, 0xC067, 0xC069, 0xC071,
    0xC073, 0xC075, 0xC076, 0xC077, 0xC078, 0xC081, 0xC082, 0xC085,
    0xC089, 0xC091, 0xC093, 0xC095, 0xC096, 0xC097, 0xC0A1, 0xC0A5,
    0xC0A7, 0xC0A9, 0xC0B1, 0xC0B7, 0xC0E1, 0xC0E2, 0xC0E5, 0xC0E9,
    0xC0F1, 0xC0F3, 0xC0F5, 0xC0F6, 0xC0F7, 0xC141, 0xC142, 0xC145,
    0xC149, 0xC151, 0xC153, 0xC155, 0xC157, 0xC161, 0xC165, 0xC176,
    0xC181, 0xC185, 0xC197, 0xC1A1, 0xC1A2, 0xC1A5, 0xC1A9, 0xC1B1,
    0xC1B3, 0xC1B5, 0xC1B7, 0xC1C1, 0xC1C5, 0xC1C9, 0xC1D7, 0xC241,
    0xC245, 0xC249, 0xC251, 0xC253, 0xC255, 0xC257, 0xC261, 0xC271,
    0xC281, 0xC282, 0xC285, 0xC289, 0xC291, 0xC293, 0xC295, 0xC297,
    0xC2A1, 0xC2B6, 0xC2C1, 0xC2C5, 0xC2E1, 0xC2E5, 0xC2E9, 0xC2F1,
    0xC2F3, 0xC2F5, 0xC2F7, 0xC341, 0xC345, 0xC349, 0xC351, 0xC357,
    0xC361, 0xC362, 0xC365, 0xC369, 0xC371, 0xC373, 0xC375, 0xC377,
    0xC3A1, 0xC3A2, 0xC3A5, 0xC3A8, 0xC3A9, 0xC3AA, 0xC3B1, 0xC3B3,
    0xC3B5, 0xC3B7, 0xC461, 0xC462, 0xC465, 0xC469, 0xC471, 0xC473,
    0xC475, 0xC477, 0xC481, 0xC482, 0xC485, 0xC489, 0xC491, 0xC493,
    0xC495, 0xC496, 0xC497, 0xC4A1, 0xC4A2, 0xC4B7, 0xC4E1, 0xC4E2,
    0xC4E5, 0xC4E8, 0xC4E9, 0xC4F1, 0xC4F3, 0xC4F5, 0xC4F6, 0xC4F7,
    0xC541, 0xC542, 0xC545, 0xC549, 0xC551, 0xC553, 0xC555, 0xC557,
    0xC561, 0xC565, 0xC569, 0xC571, 0xC573, 0xC575, 0xC576, 0xC577,
    0xC581, 0xC5A1, 0xC5A2, 0xC5A5, 0xC5A9, 0xC5B1, 0xC5B3, 0xC5B5,
    0xC5B7, 0xC5C1, 0xC5C2, 0xC5C5, 0xC5C9, 0xC5D1, 0xC5D7, 0xC5E1,
    0xC5F7, 0xC641, 0xC649, 0xC661, 0xC681, 0xC682, 0xC685, 0xC689,
    0xC691, 0xC693, 0xC695, 0xC697, 0xC6A1, 0xC6A5, 0xC6A9, 0xC6B7,
    0xC6C1, 0xC6D7, 0xC6E1, 0xC6E2, 0xC6E5, 0xC6E9, 0xC6F1, 0xC6F3,
    0xC6F5, 0xC6F7, 0xC741, 0xC745, 0xC749, 0xC751, 0xC761, 0xC762,
    0xC765, 0xC769, 0xC771, 0xC773, 0xC777, 0xC7A1, 0xC7A2, 0xC7A5,
    0xC7A9, 0xC7B1, 0xC7B3, 0xC7B5, 0xC7B7, 0xC861, 0xC862, 0xC865,
    0xC869, 0xC86A, 0xC871, 0xC873, 0xC875, 0xC876, 0xC877, 0xC881,
    0xC882, 0xC885, 0xC889, 0xC891, 0xC893, 0xC895, 0xC896, 0xC897,
    0xC8A1, 0xC8B7, 0xC8E1, 0xC8E2, 0xC8E5, 0xC8E9, 0xC8EB, 0xC8F1,
    0xC8F3, 0xC8F5, 0xC8F6, 0xC8F7, 0xC941, 0xC942, 0xC945, 0xC949,
    0xC951, 0xC953, 0xC955, 0xC957, 0xC961, 0xC965, 0xC976, 0xC981,
    0xC985, 0xC9A1, 0xC9A2, 0xC9A5, 0xC9A9, 0xC9B1, 0xC9B3, 0xC9B5,
    0xC9B7, 0xC9BC, 0xC9C1, 0xC9C5, 0xC9E1, 0xCA41, 0xCA45, 0xCA55,
    0xCA57, 0xCA61, 0xCA81, 0xCA82, 0xCA85, 0xCA89, 0xCA91, 0xCA93,
    0xCA95, 0xCA97, 0xCAA1, 0xCAB6, 0xCAC1, 0xCAE1, 0xCAE2, 0xCAE5,
    0xCAE9, 0xCAF1, 0xCAF3, 0xCAF7, 0xCB41, 0xCB45, 0xCB49, 0xCB51,
    0xCB57, 0xCB61, 0xCB62, 0xCB65, 0xCB68, 0xCB69, 0xCB6B, 0xCB71,
    0xCB73, 0xCB75, 0xCB81, 0xCB85, 0xCB89, 0xCB91, 0xCB93, 0xCBA1,
    0xCBA2, 0xCBA5, 0xCBA9, 0xCBB1, 0xCBB3, 0xCBB5, 0xCBB7, 0xCC61,
    0xCC62, 0xCC63, 0xCC65, 0xCC69, 0xCC6B, 0xCC71, 0xCC73, 0xCC75,
    0xCC76, 0xCC77, 0xCC7B, 0xCC81, 0xCC82, 0xCC85, 0xCC89, 0xCC91,
    0xCC93, 0xCC95, 0xCC96, 0xCC97, 0xCCA1, 0xCCA2, 0xCCE1, 0xCCE2,
    0xCCE5, 0xCCE9, 0xCCF1, 0xCCF3, 0xCCF5, 0xCCF6, 0xCCF7, 0xCD41,
    0xCD42, 0xCD45, 0xCD49, 0xCD51, 0xCD53, 0xCD55, 0xCD57, 0xCD61,
    0xCD65, 0xCD69, 0xCD71, 0xCD73, 0xCD76, 0xCD77, 0xCD81, 0xCD89,
    0xCD93, 0xCD95, 0xCDA1, 0xCDA2, 0xCDA5, 0xCDA9, 0xCDB1, 0xCDB3,
    0xCDB5, 0xCDB7, 0xCDC1, 0xCDD7, 0xCE41, 0xCE45, 0xCE61, 0xCE65,
    0xCE69, 0xCE73, 0xCE75, 0xCE81, 0xCE82, 0xCE85, 0xCE88, 0xCE89,
    0xCE8B, 0xCE91, 0xCE93, 0xCE95, 0xCE97, 0xCEA1, 0xCEB7, 0xCEE1,
    0xCEE5, 0xCEE9, 0xCEF1, 0xCEF5, 0xCF41, 0xCF45, 0xCF49, 0xCF51,
    0xCF55, 0xCF57, 0xCF61, 0xCF65, 0xCF69, 0xCF71, 0xCF73, 0xCF75,
    0xCFA1, 0xCFA2, 0xCFA5, 0xCFA9, 0xCFB1, 0xCFB3, 0xCFB5, 0xCFB7,
    0xD061, 0xD062, 0xD065, 0xD069, 0xD06E, 0xD071, 0xD073, 0xD075,
    0xD077, 0xD081, 0xD082, 0xD085, 0xD089, 0xD091, 0xD093, 0xD095,
    0xD096, 0xD097, 0xD0A1, 0xD0B7, 0xD0E1, 0xD0E2, 0xD0E5, 0xD0E9,
    0xD0EB, 0xD0F1, 0xD0F3, 0xD0F5, 0xD0F7, 0xD141, 0xD142, 0xD145,
    0xD149, 0xD151, 0xD153, 0xD155, 0xD157, 0xD161, 0xD162, 0xD165,
    0xD169, 0xD171, 0xD173, 0xD175, 0xD176, 0xD177, 0xD181, 0xD185,
    0xD189, 0xD193, 0xD1A1, 0xD1A2, 0xD1A5, 0xD1A9, 0xD1AE, 0xD1B1,
    0xD1B3, 0xD1B5, 0xD1B7, 0xD1BB, 0xD1C1, 0xD1C2, 0xD1C5, 0xD1C9,
    0xD1D5, 0xD1D7, 0xD1E1, 0xD1E2, 0xD1E5, 0xD1F5, 0xD1F7, 0xD241,
    0xD242, 0xD245, 0xD249, 0xD253, 0xD255, 0xD257, 0xD261, 0xD265,
    0xD269, 0xD273, 0xD275, 0xD281, 0xD282, 0xD285, 0xD289, 0xD28E,
    0xD291, 0xD295, 0xD297, 0xD2A1, 0xD2A5, 0xD2A9, 0xD2B1, 0xD2B7,
    0xD2C1, 0xD2C2, 0xD2C5, 0xD2C9, 0xD2D7, 0xD2E1, 0xD2E2, 0xD2E5,
    0xD2E9, 0xD2F1, 0xD2F3, 0xD2F5, 0xD2F7, 0xD341, 0xD342, 0xD345,
    0xD349, 0xD351, 0xD355, 0xD357, 0xD361, 0xD362, 0xD365, 0xD367,
    0xD368, 0xD369, 0xD36A, 0xD371, 0xD373, 0xD375, 0xD377, 0xD37B,
    0xD381, 0xD385, 0xD389, 0xD391, 0xD393, 0xD397, 0xD3A1, 0xD3A2,
    0xD3A5, 0xD3A9, 0xD3B1, 0xD3B3, 0xD3B5, 0xD3B7
};

/**
 * ks symbols
 */
static unsigned tblhhtg_ks[] =
{
    0xC7D1, 0xB1DB, 0xB0FA, 0xC4C4, 0xC7BB, 0xC5CD, noneks, noneks,
    0xA2B1, 0xA3DF, 0xA2D5, 0xA6B1, 0xA1B8, 0xA1B9, 0xA3DF, 0xA1DA,
    0xA2C6, 0xA2CC, 0xA2CB, noneks, noneks, 0xA6BE, 0xA6B9, 0xA6C1,
    0xA6C2, 0xA6B4, 0xA6AD, 0xA6AF, 0xA6B0, 0xA6C3, 0xA6C4, noneks,
    0xA6AE, 0xA6B0, 0xA2D7, 0xA1E1, 0xA1D6, noneks, 0xA6BC, 0xA6B7,
    0xA6B1, 0xA6AE, 0xA6B5, 0xA6B3, 0xA6B2, 0xA6AC, 0xA6B6, 0xA6BA,
    0xA6BF, 0xA6B8, 0xA6BD, 0xA6C5, 0xA6C6, 0xA6C8, 0xA6C7, 0xA6C0,
    0xA6BB, noneks, noneks, noneks, 0xA1E1, 0xA1E1, 0xA1E1, 0xA1E1
};

/**
 * kssm symbols
 */
static unsigned hhtg_tg[] =
{
    0xD065, 0x8B69, 0x89C1, 0xC4F1, 0xCF41, 0xC8E1, 0xD3C5, 0xD931,
    0xD931, 0xD481, 0xD482, 0xD488, 0xD48A, 0xD48F, 0xD493, 0xD494,
    0xD4B0, 0xD4B1, 0xD4B2, 0xD931, 0xD931, 0xD4B5, 0xD4B6, 0xD4B7,
    0xD4B8, 0xD4B9, 0xD4BA, 0xD4BB, 0xD4BC, 0xD4BD, 0xD4BE, 0xD496,
    0xD497, 0xD49C, 0xD4A9, 0xD4AF, 0xD4F4, 0xD4F5, 0xD4C6, 0xD4C7,
    0xD4C8, 0xD4C9, 0xD4CA, 0xD4CB, 0xD4CC, 0xD4CD, 0xD4CE, 0xD4CF,
    0xD4D0, 0xD4D1, 0xD4D2, 0xD4D3, 0xD4D4, 0xD4D5, 0xD4D6, 0xD4D7,
    0xD4D8, 0xD4F7, 0xD4FA, 0xD4FE, 0xD4DC, 0xD4DD, 0xD4DE, 0xD4DF
};

/* os: unused 
static unsigned compatible_jamo[] =
{
     0x8000, 0x8001, 0x8002, 0x8003, 0x8004, 0x8005, 0x8006, 0x8007,
     0x8008, 0x8009, 0x800a, 0x800b, 0x800c, 0x800d, 0x800e, 0x800f,
     0x8010, 0x8011, 0x8012, 0x8013, 0x8014, 0x8015, 0x8016, 0x8017,
     0x8018, 0x8019, 0x801a, 0x801b, 0x801c, 0x801d, 0x0000, 0x0000,
     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
     0x0000, 0x0000, 0x0000, 0x0000, 0x8441, 0x840d, 0x840e, 0x8410,
     0x8411, 0x8415, 0x8417, 0x841c, 0x8800, 0x8409, 0x8805, 0x8806,
     0x8808, 0x880b, 0x801e, 0x801f, 0x880e, 0x880f, 0x8400, 0x8814,
     0x8406, 0x8817, 0x8401, 0x8818, 0x8402, 0x8403, 0x8404, 0x8407,
     0x8c0e, 0x8408, 0x8c14, 0x8c15, 0x9000, 0x8405, 0x9005, 0x9014,
     0x9015, 0x8621, 0x8701, 0x9400, 0x8721, 0x87c1, 0x87e1
};*/

#define LINEBASE    0x3013

// ?
static char LineCharDir(hchar ch)
{
    static char index2dir[] = { 10, 11, 9, 14, 15, 13, 6, 7, 5, 3, 12 };

    return (LINEBASE <= ch && ch < LINEBASE + 11 * 7) ?
        index2dir[(ch - LINEBASE) % 11] : 0;
}


/**
 * Convert hwp's special character to ks
 */
static hchar s_hh2ks(hchar hh)
{
    hchar i, idx = hh >> 8;

    if (hh == 0x81 || hh == 0x82)
        return '\"';
    else if (hh == 0x83 || hh == 0x84)
        return '\'';
    if (idx == 0x1F)
    {
        idx = 170;
        i = hh & 0xff;
        if (i >= 0x60)
        {
            idx++;
            i -= 0x60;
        }
        return (idx << 8) | (i + 160);
    }
    if ((idx == 0x1F && (hh & 0xff) >= 0xC0) || (hh == 0x1F00))
        return 0;
    if (idx < 0x34 || idx >= 0x38)
        return 0x2020;
    if (hh >= HCA_TG)
    {
        return sal::static_int_cast<hchar>((tblhhtg_ks[hh - HCA_TG]));
    }
    hh -= HCA_KSS;
    idx = hh / 0x60 + 161;
    i = hh % 0x60 + 160;
    if (idx == 170)
        idx += 2;
    return (idx << 8) | i;
}


/**
 * Convert hwp's special character to kssm
 */
static hchar s_hh2kssm(hchar hh)
{
    hchar i, idx = hh >> 8;

    if ((idx < 0x34 || idx >= 0x38) && idx != 0x1F)
        return 0;
    if (hh >= HCA_TG)
        return sal::static_int_cast<hchar>((hhtg_tg[hh - HCA_TG]));
    if (idx == 0x1F)
        hh = hh - 0x1F00 + 0x360;
    else
    {
        hh -= HCA_KSS;
        if (hh >= 0x360)
            hh += 0xC0;
    }
    idx = hh / 0xC0 + 217;
    i = hh % 0xC0;
    if (i >= 95)
        i -= 2;
    i += 48;
    if (i >= 127)
        i += 18;
    return (idx << 8) | i;
}


static hchar lineCharConv(hchar ch)
{
    int flag;

    switch (ch)
    {
        case 0x3060 + '\'' - 31:
        case 0x3060 + '\"' - 31:
            ch--;

        case 0x3060 + '\'' - 32:
        case 0x3060 + '\"' - 32:
        case 0x3060 + '{' - 32:
        case 0x3060 + '[' - 32:
        case 0x3060 + ']' - 32:
        case 0x3060 + '}' - 32:
            return ch - (0x3060 - 32);
    }
    flag = LineCharDir(ch);
    switch (flag)
    {
        case 3:
            return '-';
        case 12:
            return '|';
        default:
            return '+';
    }
}


static int KsSearch(hchar c)
{
    int lo, hi, mid;
    hchar c2;

    lo = mid = 0;
    hi = 2350 - 1;

    while (lo <= hi)
    {
        mid = (lo + hi) >> 1;
        c2 = ksTbl[mid];
        if (c == c2)
            break;
        if (c < c2)
            hi = mid - 1;
        else
            lo = mid + 1;
    }
    return mid;
}


static hchar cdkssm2ks_han(hchar kssm)
{
    unsigned int index;
    unsigned char lo, hi;

/* "" */
    if (kssm == 0xd3c5)
        return 0xc7d1;

    index = KsSearch(kssm);
    if (kssm != ksTbl[index])
        return jaso2ks(kssm);
    hi = sal::static_int_cast<char>(index / (0xFE - 0xA1 + 1) + 0xB0);
    lo = sal::static_int_cast<unsigned char>(index % (0xFE - 0xA1 + 1) + 0xA1);
    return lo | (hi << 8);
}


#define IsHangul(c) ((c) & 0x8000)
#define IsHanja(c)  (((c) & 0x4000)==0x4000)
#define IsJapan(c)  (((c) > 0x1f00 && (c) < 0x1fb7))

static const hchar jaso_hh_code[] =
{
    34881, 35905, 33860, 36929, 33862, 33863, 37953, 38977, 40001, 33866,
    33867,
    33868, 33869, 33870, 33871, 33872, 41025, 42049, 43073, 33876, 44097,
    45121,
    46145, 47169, 48193, 49217, 50241, 51265, 52289, 53313, 33889, 33921,
    33953,
    33985, 34017, 34113, 34145, 34177, 34209, 34241, 34273, 34369, 34401,
    34433,
    34465, 34497, 34529, 34625, 34657, 34689, 34721
};

/* os: unused 
static int is_jaso(hchar hh)
{
    unsigned int i;

    for (i = 0; i < SAL_N_ELEMENTS(jaso_hh_code); i++)
        if (hh == jaso_hh_code[i])
            return 1;
    return 0;
}*/


static hchar jaso2ks(hchar hh)
{
    unsigned int i;

    for (i = 0; i < SAL_N_ELEMENTS(jaso_hh_code); i++)
        if (hh == jaso_hh_code[i])
    {
        return sal::static_int_cast<hchar>(0xa4a1 + i);
    }
    return 0;
}


//1 00011 00 001 00011
static hchar choseong_to_unicode[] =
{
    0x111e,  0,  0x1100, 0x1101, 0x1102, 0x1103, 0x1104, 0x1105,
    0x1106, 0x1107, 0x1108, 0x1109, 0x110a, 0x110b, 0x110c, 0x110d,
    0x110e, 0x110f, 0x1110, 0x1111, 0x1112, 0x1120, 0x1121, 0x1127,
    0x112b, 0x112d, 0x112f, 0x1132, 0x1136, 0x1140, 0x114c, 0x1158
};
/* ߼ 0 1  ٸ ڵ  ִ. ̺κп  Ģ ̾ƶ. */
static hchar joongseong_to_unicode[] =
{
    0, 		0, 	0, 0x1161, 0x1162, 0x1163, 0x1164, 0x1165,
    0, 		0, 0x1166, 0x1167, 0x1168, 0x1169, 0x116a, 0x116b,
    0, 	0x1188, 0x116c, 0x116d, 0x116e, 0x116f, 0x1170, 0x1171,
    0x1191, 0x1194, 0x1172, 0x1173, 0x1174, 0x1175, 0x119e, 0x11a1
};

static hchar jongseong_to_unicode[] =
{
    0x11d9,	0  , 0x11a8, 0x11a9, 0x11aa, 0x11ab, 0x11ac, 0x11ad,
    0x11ae, 0x11af, 0x11b0, 0x11b1, 0x11b2, 0x11b3, 0x11b4, 0x11b5,
    0x11b6, 0x11b7, 0x11e6, 0x11b8, 0x11b9, 0x11ba, 0x11bb, 0x11bc,
    0x11bd, 0x11be, 0x11bf, 0x11c0, 0x11c1, 0x11c2, 0x11eb, 0x11f0
};

/* ߼ 0 1ΰ */
/* ó 32 ڸ,  32  .
 * 0x8000 ~ 0xa413 32 , 0x0400 0x8400 ٽ 32   ȴ.
 * ڸ𿵿 Ϲ ̺  ü ̺ .
 */
/* 308.. 1152 308   844 ڸ̴. */
static hchar jamo_to_unicode[] =
{
    0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138,
    0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e, 0x313f, 0x3140,
    0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148,
    0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e, 0x3172, 0x3173,

    0x3176, 0x317a, 0x317c, 0x317d, 0x317e, 0x3185, 0x3178, 0x317f,
     0x3181, 0x316d, 0x11c3, 0x11c4, 0x1113, 0x1114, 0x1115, 0x1116,
    0x11c7, 0x11c8, 0x11c9, 0x11ca, 0x11cb, 0x11cc, 0x11cd, 0x11ce,
    0x11cf, 0x11d0, 0x11d1, 0x11d2, 0x11d3, 0x11d4, 0x11d5, 0x11d6,

    0x11d7, 0x11d8, 0x111b, 0x11da, 0x11db, 0x11dc, 0x11dd, 0x11de,
    0x11df, 0x11e0, 0x11e1, 0x11e2, 0x111f, 0x11e3, 0x1122, 0x1123,
    0x1124, 0x1125, 0x1126, 0x1128, 0x1129, 0x112a, 0x11e5, 0x112c,
    0x112e, 0x1130, 0x1131, 0x1133, 0x1134, 0x1135, 0x1137, 0x1138,

    0x1139, 0x113a, 0x113b, 0x113c, 0x113d, 0x113e, 0x113f, 0x1141,
    0x11ed, 0x1142, 0x1143, 0x1144, 0x1145, 0x1146, 0x1147, 0x1148,
    0x1149, 0x11ef, 0x114a, 0x114b, 0x11f1, 0x11f2, 0x114d, 0x114e,
    0x114f, 0x1150, 0x1151, 0x1152, 0x1153, 0x1154, 0x1155, 0x1156,

    0x1157, 0x11f5, 0x11f6, 0x11f7, 0x11f8, 0x11f9, 0x1176, 0x1177,
    0x1178, 0x1179, 0x117a, 0x117b, 0x117c, 0x117d, 0x117e, 0x117f,
    0x1180, 0x1181, 0x1182, 0x1183, 0x1184, 0x1185, 0x1186, 0x1187,
    0x1189, 0x118a, 0x118b, 0x118c, 0x118d, 0x118e, 0x118f, 0x1190,

    0x1192, 0x1193, 0x1195, 0x1196, 0x1197, 0x1198, 0x1199, 0x119a,
    0x119b, 0x119c, 0x119d, 0x119f, 0x11a0, 0x11a2, 0x11a8, 0x11a9,
    0x11aa, 0x11ab, 0x11ac, 0x11ad, 0x11ae, 0x1104, 0x11af, 0x11b0,
    0x11b1, 0x11b2, 0x11b3, 0x11b4, 0x11b5, 0x11b6, 0x11b7, 0x11b8,

    0x1108, 0x11b9, 0x11ba, 0x11bb, 0x11bc, 0x11bd, 0x3149, 0x11be,
    0x11bf, 0x11c0, 0x11c1, 0x11c2, 0x111e, 0x1120, 0x1127, 0x11e7,
    0x11e8, 0x11ea, 0x1136, 0x1158, 0x11e6, 0x11eb, 0x11f0, 0x11d9,
    0x11c3, 0x11c4, 0x11c5, 0x1114, 0x11c6, 0x1116, 0x11c7, 0x11c8,

    0x11c9, 0x11ca, 0x11cb, 0x3169, 0x11cd, 0x11ce, 0x11cf, 0x1119,
    0x11d1, 0x11d2, 0x11d3, 0x11d4, 0x11d5, 0x11d6, 0x11d7, 0x11d8,
    0x111b, 0x11da, 0x11db, 0x11dc, 0x11dd, 0x11de, 0x11df, 0x11e0,
    0x11e1, 0x11e2, 0x111f, 0x11e3, 0x1122, 0x1123, 0x1124, 0x1125,

    0x1126, 0x1128, 0x1129, 0x11e4, 0x11e5, 0x112c, 0x112e, 0x1130,
    0x1131, 0x1133, 0x1134, 0x1135, 0x1137, 0x1138, 0x1139, 0x113a,
    0x113b, 0x113c, 0x113d, 0x113e, 0x113f, 0x11ec, 0x11ed, 0x1142,
    0x1143, 0x1144, 0x1145, 0x1146, 0x1147, 0x1148, 0x1149, 0x11ef,

    0x114a, 0x114b, 0x11f1, 0x11f2, 0x114d, 0x114e, 0x114f, 0x1150,
    0x1151, 0x1152, 0x1153, 0x1154, 0x1155, 0x1156, 0x1157, 0x11f5,
    0x11f6, 0x11f7, 0x11f8, 0x11f9
};

struct JamoComp{
    int size;
    hchar v1;
    hchar v2;
    hchar v3;
};
/* 704 + 12 = 706   */
static JamoComp jamocomp1_to_unicode[] =
{
    {3, 0x1100, 0x1161, 0x11e7}, {3, 0x1100, 0x1161, 0x3167},
    {3, 0x1100, 0x1161, 0x11dd}, {3, 0x1100, 0x1161, 0x11e2},
    {3, 0x1100, 0x1161, 0x11e5}, {3, 0x1100, 0x1161, 0x11f1},
    {3, 0x1100, 0x1163, 0x11e2}, {3, 0x1100, 0x1163, 0x11f9},
    {3, 0x1100, 0x1165, 0x11e7}, {3, 0x1100, 0x1165, 0x11c7},
    {3, 0x1100, 0x1165, 0x11dd}, {3, 0x1100, 0x1165, 0x11e2},

    {3, 0x1100, 0x1165, 0x11e3}, {3, 0x1100, 0x1167, 0x11e7},
    {3, 0x1100, 0x1167, 0x11f1}, {3, 0x1100, 0x1167, 0x11f9},
    {3, 0x1100, 0x1169, 0x11d6}, {3, 0x1100, 0x1169, 0x11dd},
    {3, 0x1100, 0x1169, 0x11e2}, {3, 0x1100, 0x1169, 0x11f1},
    {3, 0x1100, 0x1169, 0x11f7}, {3, 0x1100, 0x1169, 0x11f8},
    {3, 0x1100, 0x116a, 0x11f9}, {3, 0x1100, 0x116d, 0x11e2},
    {3, 0x1100, 0x116e, 0x11c7}, {3, 0x1100, 0x116e, 0x11cd},
    {3, 0x1100, 0x116e, 0x11da}, {3, 0x1100, 0x116e, 0x11dd},

    {3, 0x1100, 0x116e, 0x11e2}, {3, 0x1100, 0x116e, 0x11f6},
    {3, 0x1100, 0x116e, 0x11f9}, {3, 0x1100, 0x116f, 0x11c7},
    {3, 0x1100, 0x116f, 0x11f9}, {3, 0x1100, 0x1172, 0x11e2},
    {3, 0x1100, 0x1172, 0x11f9}, {3, 0x1100, 0x1173, 0x11c7},
    {3, 0x1100, 0x1173, 0x11dd}, {3, 0x1100, 0x1173, 0x11df},
    {3, 0x1100, 0x1173, 0x11e2}, {3, 0x1100, 0x1173, 0x11f9},
    {3, 0x1100, 0x1174, 0x11f9}, {3, 0x1100, 0x1175, 0x11e7},
    {3, 0x1100, 0x1175, 0x11cd}, {3, 0x1100, 0x1175, 0x11e2},

    {3, 0x1100, 0x1175, 0x11f9}, {3, 0x1100, 0x1191, 0x11f9},
    {3, 0x1100, 0x119e, 0x11e7}, {3, 0x1100, 0x119e, 0x11d3},
    {3, 0x1100, 0x119e, 0x11d5}, {3, 0x1100, 0x119e, 0x11e3},
    {3, 0x1100, 0x11a1, 0x11f1}, {2, 0x1100, 0x1176, 0x0000},
    {2, 0x1100, 0x1178, 0x0000}, {2, 0x1100, 0x117c, 0x0000},
    {3, 0x1100, 0x117c, 0x11ab}, {3, 0x1100, 0x117c, 0x11af},
    {3, 0x1100, 0x117c, 0x11b7}, {2, 0x1100, 0x1189, 0x0000},
    {3, 0x1100, 0x1189, 0x11ab}, {3, 0x1100, 0x1189, 0x11bc},

    {2, 0x1100, 0x118b, 0x0000}, {3, 0x1100, 0x118b, 0x11ab},
    {2, 0x1100, 0x118c, 0x0000}, {2, 0x1100, 0x118d, 0x0000},
    {2, 0x1100, 0x1192, 0x0000}, {3, 0x1100, 0x1192, 0x11bc},
    {2, 0x1100, 0x1195, 0x0000}, {2, 0x1100, 0x1196, 0x0000},
    {2, 0x1100, 0x1198, 0x0000}, {2, 0x1100, 0x119b, 0x0000},
    {2, 0x1100, 0x119c, 0x0000}, {2, 0x1100, 0x119d, 0x0000},
    {2, 0x1100, 0x119f, 0x0000}, {3, 0x1100, 0x119f, 0x11bc},
    {3, 0x1101, 0x1163, 0x11e2}, {3, 0x1101, 0x1165, 0x11ec},

    {3, 0x1101, 0x1165, 0x11ed}, {3, 0x1101, 0x116e, 0x11e2},
    {3, 0x1101, 0x1172, 0x11e2}, {3, 0x1101, 0x1175, 0x11e2},
    {3, 0x1101, 0x1175, 0x11f9}, {3, 0x1101, 0x1191, 0x11bc},
    {2, 0x1101, 0x1176, 0x0000}, {2, 0x1101, 0x117b, 0x0000},
    {2, 0x1101, 0x1189, 0x0000}, {2, 0x1101, 0x118c, 0x0000},
    {2, 0x1101, 0x1198, 0x0000}, {3, 0x1102, 0x1161, 0x11e7},
    {3, 0x1102, 0x1161, 0x11c4}, {3, 0x1102, 0x1161, 0x11da},
    {3, 0x1102, 0x1161, 0x11dd}, {3, 0x1102, 0x1161, 0x11e2},

    {3, 0x1102, 0x1161, 0x11f9}, {3, 0x1102, 0x1165, 0x11db},
    {3, 0x1102, 0x1165, 0x11dd}, {3, 0x1102, 0x1165, 0x11e3},
    {3, 0x1102, 0x1167, 0x11c5}, {3, 0x1102, 0x1167, 0x11c7},
    {3, 0x1102, 0x1167, 0x11f9}, {3, 0x1102, 0x1169, 0x11e2},
    {3, 0x1102, 0x1169, 0x11e4}, {3, 0x1102, 0x1169, 0x11f3},
    {3, 0x1102, 0x116e, 0x11c6}, {3, 0x1102, 0x116e, 0x11c7},
    {3, 0x1102, 0x116e, 0x11c8}, {3, 0x1102, 0x116e, 0x11dd},
    {3, 0x1102, 0x116e, 0x11e2}, {3, 0x1102, 0x116e, 0x11f5},

    {3, 0x1102, 0x1172, 0x11e2}, {3, 0x1102, 0x1173, 0x11c3},
    {3, 0x1102, 0x1175, 0x11c3}, {3, 0x1102, 0x1175, 0x11dd},
    {3, 0x1102, 0x1175, 0x11e2}, {3, 0x1102, 0x119e, 0x11d7},
    {2, 0x1102, 0x1176, 0x0000}, {2, 0x1102, 0x117c, 0x0000},
    {3, 0x1102, 0x117c, 0x11a8}, {2, 0x1102, 0x118c, 0x0000},
    {2, 0x1102, 0x1196, 0x0000}, {2, 0x1102, 0x1197, 0x0000},
    {2, 0x1102, 0x1198, 0x0000}, {2, 0x1102, 0x119b, 0x0000},
    {3, 0x1103, 0x1161, 0x11e7}, {3, 0x1103, 0x1161, 0x11c7},

    {3, 0x1103, 0x1161, 0x1119}, {3, 0x1103, 0x1161, 0x11db},
    {3, 0x1103, 0x1161, 0x11dd}, {3, 0x1103, 0x1161, 0x11e2},
    {3, 0x1103, 0x1161, 0x11f1}, {3, 0x1103, 0x1161, 0x11f9},
    {3, 0x1103, 0x1163, 0x11e2}, {3, 0x1103, 0x1163, 0x11f1},
    {3, 0x1103, 0x1165, 0x11dd}, {3, 0x1103, 0x1167, 0x11f9},
    {3, 0x1103, 0x1169, 0x11e7}, {3, 0x1103, 0x1169, 0x11d6},
    {3, 0x1103, 0x1169, 0x11e2}, {3, 0x1103, 0x1169, 0x11f1},
    {3, 0x1103, 0x116d, 0x11e2}, {3, 0x1103, 0x116e, 0x11ce},

    {3, 0x1103, 0x116e, 0x1119}, {3, 0x1103, 0x116e, 0x11da},
    {3, 0x1103, 0x116e, 0x11e2}, {3, 0x1103, 0x1172, 0x11e2},
    {3, 0x1103, 0x1173, 0x11cd}, {3, 0x1103, 0x1173, 0x11ce},
    {3, 0x1103, 0x1173, 0x11e2}, {3, 0x1103, 0x1173, 0x11e3},
    {3, 0x1103, 0x1173, 0x11f1}, {3, 0x1103, 0x1174, 0x11f9},
    {3, 0x1103, 0x1175, 0x11f9}, {3, 0x1103, 0x119e, 0x11e7},
    {3, 0x1103, 0x119e, 0x11e8}, {3, 0x1103, 0x119e, 0x11ea},
    {3, 0x1103, 0x119e, 0x11c3}, {3, 0x1103, 0x119e, 0x11cc},

    {3, 0x1103, 0x119e, 0x11e3}, {3, 0x1103, 0x119e, 0x11e9},
    {2, 0x1103, 0x1176, 0x0000}, {2, 0x1103, 0x1178, 0x0000},
    {2, 0x1103, 0x117c, 0x0000}, {3, 0x1103, 0x117c, 0x11b7},
    {2, 0x1103, 0x1189, 0x0000}, {3, 0x1103, 0x1189, 0x11ab},
    {2, 0x1103, 0x118c, 0x0000}, {2, 0x1103, 0x1195, 0x0000},
    {2, 0x1103, 0x1196, 0x0000}, {2, 0x1103, 0x1198, 0x0000},
    {2, 0x1103, 0x1199, 0x0000}, {3, 0x1103, 0x1199, 0x11ab},
    {3, 0x1103, 0x1199, 0x11bc}, {3, 0x1104, 0x1161, 0x11d8},

    {3, 0x1104, 0x1161, 0x11e2}, {3, 0x1104, 0x1161, 0x11f9},
    {3, 0x1104, 0x1163, 0x11e2}, {3, 0x1104, 0x1169, 0x11e2},
    {3, 0x1104, 0x1169, 0x11f9}, {3, 0x1104, 0x116d, 0x11e2},
    {3, 0x1104, 0x116e, 0x11e2}, {3, 0x1104, 0x116e, 0x11f9},
    {3, 0x1104, 0x1172, 0x11e2}, {3, 0x1104, 0x1173, 0x11e2},
    {3, 0x1104, 0x1175, 0x11f9}, {2, 0x1104, 0x117b, 0x0000},
    {2, 0x1104, 0x118c, 0x0000}, {2, 0x1104, 0x1198, 0x0000},
    {3, 0x1105, 0x1161, 0x11e7}, {3, 0x1105, 0x1161, 0x11dd},

    {3, 0x1105, 0x1161, 0x11e2}, {3, 0x1105, 0x1161, 0x11f5},
    {3, 0x1105, 0x1161, 0x11f9}, {3, 0x1105, 0x1163, 0x11e2},
    {3, 0x1105, 0x1167, 0x11c7}, {3, 0x1105, 0x1167, 0x11e2},
    {3, 0x1105, 0x1167, 0x11f9}, {3, 0x1105, 0x1169, 0x11dd},
    {3, 0x1105, 0x1169, 0x11e2}, {3, 0x1105, 0x1169, 0x11f1},
    {3, 0x1105, 0x116d, 0x11dd}, {3, 0x1105, 0x116d, 0x11e2},
    {3, 0x1105, 0x116e, 0x11dd}, {3, 0x1105, 0x116e, 0x11e2},
    {3, 0x1105, 0x1172, 0x11e2}, {3, 0x1105, 0x1173, 0x11dd},

    {3, 0x1105, 0x1173, 0x11e2}, {3, 0x1105, 0x1175, 0x11dd},
    {3, 0x1105, 0x1175, 0x11e2}, {3, 0x1105, 0x1175, 0x11f9},
    {3, 0x1105, 0x119e, 0x11d7}, {3, 0x1105, 0x119e, 0x11dc},
    {3, 0x1105, 0x119e, 0x11dd}, {2, 0x1105, 0x1176, 0x0000},

/* --   ȹٲ , 3 2 ٲپ ־ . */
    {2, 0x1105, 0x1178, 0x0000}, {2, 0x1105, 0x117a, 0x0000},
    {2, 0x1105, 0x117b, 0x0000}, {2, 0x1105, 0x1186, 0x0000},
    {2, 0x1105, 0x1187, 0x0000}, {2, 0x1105, 0x118c, 0x0000},
    {2, 0x1105, 0x1195, 0x0000}, {2, 0x1105, 0x1196, 0x0000},

    {2, 0x1105, 0x1198, 0x0000}, {2, 0x1105, 0x1199, 0x0000},
    {3, 0x1105, 0x1199, 0x11bc}, {2, 0x1105, 0x119b, 0x0000},
    {2, 0x111a, 0x1163, 0x0000}, {3, 0x111a, 0x1163, 0x11bc},
    {3, 0x1106, 0x1161, 0x11e8}, {3, 0x1106, 0x1161, 0x11c7},
    {3, 0x1106, 0x1161, 0x11cd}, {3, 0x1106, 0x1161, 0x1119},
    {3, 0x1106, 0x1161, 0x11d8}, {3, 0x1106, 0x1161, 0x11e2},
    {3, 0x1106, 0x1163, 0x11e2}, {3, 0x1106, 0x1165, 0x11c6},
    {3, 0x1106, 0x1165, 0x11f9}, {3, 0x1106, 0x1169, 0x11c6},

    {3, 0x1106, 0x1169, 0x11dd}, {3, 0x1106, 0x1169, 0x11e2},
    {3, 0x1106, 0x116d, 0x11e2}, {3, 0x1106, 0x116e, 0x11e7},
    {3, 0x1106, 0x116e, 0x11c7}, {3, 0x1106, 0x116e, 0x11e2},
    {3, 0x1106, 0x116e, 0x11ec}, {3, 0x1106, 0x116e, 0x11ed},
    {3, 0x1106, 0x116e, 0x11f9}, {3, 0x1106, 0x116f, 0x11f9},
    {3, 0x1106, 0x1173, 0x11e7}, {3, 0x1106, 0x1174, 0x11f9},
    {3, 0x1106, 0x1175, 0x11e7}, {3, 0x1106, 0x1175, 0x11f6},
    {3, 0x1106, 0x1175, 0x11f9}, {3, 0x1106, 0x119e, 0x11c3},

    {2, 0x1106, 0x1176, 0x0000}, {2, 0x1106, 0x1178, 0x0000},
    {2, 0x1106, 0x117c, 0x0000}, {3, 0x1106, 0x117c, 0x11af},
    {2, 0x1106, 0x1182, 0x0000}, {2, 0x1106, 0x1183, 0x0000},
    {2, 0x1106, 0x118c, 0x0000}, {2, 0x1106, 0x1196, 0x0000},
    {3, 0x1106, 0x1196, 0x11b7}, {2, 0x1106, 0x1198, 0x0000},
    {2, 0x1106, 0x119f, 0x0000}, {3, 0x1106, 0x119f, 0x11ab},
    {3, 0x1106, 0x119f, 0x11bc}, {3, 0x1107, 0x1161, 0x11e7},
    {3, 0x1107, 0x1161, 0x11c9}, {3, 0x1107, 0x1161, 0x11dd},

    {3, 0x1107, 0x1161, 0x11e2}, {3, 0x1107, 0x1161, 0x11e3},
    {3, 0x1107, 0x1161, 0x11f1}, {3, 0x1107, 0x1161, 0x11f6},
    {3, 0x1107, 0x1161, 0x11f9}, {3, 0x1107, 0x1165, 0x11c7},
    {3, 0x1107, 0x1167, 0x11f1}, {3, 0x1107, 0x1169, 0x11e7},
    {3, 0x1107, 0x1169, 0x11dd}, {3, 0x1107, 0x1169, 0x11e2},
    {3, 0x1107, 0x116d, 0x11e2}, {3, 0x1107, 0x116e, 0x11e7},
    {3, 0x1107, 0x116e, 0x11c7}, {3, 0x1107, 0x116e, 0x1119},
    {3, 0x1107, 0x116e, 0x11d1}, {3, 0x1107, 0x116e, 0x11d2},

    {3, 0x1107, 0x116e, 0x11e2}, {3, 0x1107, 0x116e, 0x11ef},
    {3, 0x1107, 0x116e, 0x11f9}, {3, 0x1107, 0x116f, 0x11f9},
    {3, 0x1107, 0x1173, 0x11e7}, {3, 0x1107, 0x1173, 0x11c3},
    {3, 0x1107, 0x1175, 0x11e7}, {3, 0x1107, 0x1175, 0x11e2},
    {3, 0x1107, 0x1175, 0x11f1}, {3, 0x1107, 0x1175, 0x11f9},
    {3, 0x1107, 0x119e, 0x11c3}, {3, 0x1107, 0x119e, 0x11d5},
    {3, 0x1107, 0x119e, 0x11e3}, {3, 0x1107, 0x11a1, 0x11f1},
    {2, 0x1107, 0x1176, 0x0000}, {2, 0x1107, 0x1177, 0x0000},

    {2, 0x1107, 0x1178, 0x0000}, {2, 0x1107, 0x117c, 0x0000},
    {3, 0x1107, 0x117c, 0x11a8}, {3, 0x1107, 0x117c, 0x11af},
    {3, 0x1107, 0x117c, 0x11b7}, {3, 0x1107, 0x117c, 0x11bc},
    {2, 0x1107, 0x1182, 0x0000}, {2, 0x1107, 0x118c, 0x0000},
    {2, 0x1107, 0x1196, 0x0000}, {2, 0x1107, 0x1198, 0x0000},
    {2, 0x1107, 0x119a, 0x0000}, {2, 0x1107, 0x119f, 0x0000},
    {3, 0x1107, 0x119f, 0x11ab}, {3, 0x1107, 0x119f, 0x11bc},
    {3, 0x1108, 0x1161, 0x11e2}, {3, 0x1108, 0x1167, 0x11f9},

    {3, 0x1108, 0x1169, 0x11e2}, {3, 0x1108, 0x116e, 0x11e2},
    {3, 0x1108, 0x1174, 0x11f9}, {3, 0x1108, 0x1175, 0x11f9},
    {3, 0x1121, 0x116a, 0x11f9}, {3, 0x1121, 0x119e, 0x114d},
    {2, 0x1121, 0x118c, 0x0000}, {2, 0x1121, 0x1198, 0x0000},
    {3, 0x1109, 0x1161, 0x11ca}, {3, 0x1109, 0x1161, 0x11dd},
    {3, 0x1109, 0x1161, 0x11e2}, {3, 0x1109, 0x1161, 0x11f1},
    {3, 0x1109, 0x1161, 0x11f9}, {3, 0x1109, 0x1163, 0x11e2},
    {3, 0x1109, 0x1163, 0x11f1}, {3, 0x1109, 0x1165, 0x11e7},

    {3, 0x1109, 0x1165, 0x11c3}, {3, 0x1109, 0x1165, 0x11ec},
    {3, 0x1109, 0x1165, 0x11ed}, {3, 0x1109, 0x1167, 0x11e7},
    {3, 0x1109, 0x1167, 0x11d5}, {3, 0x1109, 0x1167, 0x11dd},
    {3, 0x1109, 0x1167, 0x11e3}, {3, 0x1109, 0x1167, 0x11f1},
    {3, 0x1109, 0x1167, 0x11f9}, {3, 0x1109, 0x1169, 0x11c7},
    {3, 0x1109, 0x1169, 0x11e2}, {3, 0x1109, 0x116a, 0x11f9},
    {3, 0x1109, 0x116b, 0x11f9}, {3, 0x1109, 0x116d, 0x11e2},
    {3, 0x1109, 0x116d, 0x11f1}, {3, 0x1109, 0x116e, 0x11e7},

    {3, 0x1109, 0x116e, 0x11e2}, {3, 0x1109, 0x116e, 0x11f9},
    {3, 0x1109, 0x1172, 0x11e2}, {3, 0x1109, 0x1173, 0x11e2},
    {3, 0x1109, 0x1173, 0x11e3}, {3, 0x1109, 0x1173, 0x11f1},
    {3, 0x1109, 0x1174, 0x11f9}, {3, 0x1109, 0x1175, 0x11c7},
    {3, 0x1109, 0x1175, 0x11ce}, {3, 0x1109, 0x1175, 0x11da},
    {3, 0x1109, 0x1175, 0x11e2}, {3, 0x1109, 0x1175, 0x11f9},
    {3, 0x1109, 0x1191, 0x11f9}, {3, 0x1109, 0x119e, 0x11ca},
    {3, 0x1109, 0x119e, 0x11d6}, {3, 0x1109, 0x119e, 0x11f1},

    {3, 0x1109, 0x119e, 0x11e3}, {3, 0x1109, 0x11a1, 0x11dd},
    {3, 0x1109, 0x11a1, 0x11f1}, {2, 0x1109, 0x1176, 0x0000},
    {2, 0x1109, 0x1177, 0x0000}, {2, 0x1109, 0x1178, 0x0000},
    {2, 0x1109, 0x117c, 0x0000}, {3, 0x1109, 0x117c, 0x11a8},
    {3, 0x1109, 0x117c, 0x11af}, {3, 0x1109, 0x117c, 0x11b7},
    {3, 0x1109, 0x117c, 0x11bc}, {2, 0x1109, 0x117e, 0x0000},
    {2, 0x1109, 0x1189, 0x0000}, {3, 0x1109, 0x1189, 0x11ab},
    {2, 0x1109, 0x118c, 0x0000}, {2, 0x1109, 0x1190, 0x0000},

    {2, 0x1109, 0x1192, 0x0000}, {3, 0x1109, 0x1192, 0x11bc}
};

//#define IS_OLD_HAN(x)	(((x) >= 0x8020 && (x) <= 0x83ff ) || ( (x) >= 0x8420 && (x) <= 0x843f )) // beside these, there are very much characters in the hangul.
int hcharconv(hchar ch, hchar *dest, int codeType)
{
    unsigned int index;
    unsigned char lo, hi;
     int res;
     //printf("hcharconv[%04x]\n",ch);
    if (ch < 128){
         dest[0] = ch;
        return 1;
     }
    if (IsHangul(ch))
    {
          hchar ch2 = ch;
        if (codeType == KS)
            ch = cdkssm2ks_han(ch);
          else if( codeType == UNICODE ){
                if( ch2 == 0xd3c5 ){
                    dest[0] = 0xd55c;
                    return 1 ;
                }
                res = kssm_hangul_to_ucs2(ch, dest);
               //printf("hcharconv Hangul[%04x]\n",dest[0]);
                return res;
          }
          dest[0] = ch;
        return 1;
    }
      /* ڴ 0x4000 4888  . */
    else if (IsHanja(ch))
    {
        /*  4888̿  Ʒѱۿ  Ȯ̴. ̰Ϳ ؼ
            ڵ峪 ϼڵ ȯ  ̺  ̴.
         */
        if ((index = ch - 0x4000) >= 4888)
        {
                if( codeType == UNICODE )
                     dest[0]= 0x25A1;
                else
                     dest[0]= 0xA1E0;
            return 1;
        }
        if (codeType == KS)
        {
            /*  ڵ ڵ ڵ  ڵ 0xA1 - 0xFE   .
                 ڵ忡 üִ  0xFE - 0xA1 +1 ̴.
             */
            hi = sal::static_int_cast<unsigned char>(index / (0xFE - 0xA1 + 1) + 0xCA);
            lo = sal::static_int_cast<unsigned char>(index % (0xFE - 0xA1 + 1) + 0xA1);
            ch = (hi << 8) | lo;
        }
          else if(codeType == UNICODE){
                hi = sal::static_int_cast<unsigned char>(index / (0xFE - 0xA1 + 1) + 0xCA);
                lo = sal::static_int_cast<unsigned char>(index % (0xFE - 0xA1 + 1) + 0xA1);
                ch = (hi << 8) | lo;
                ch = ksc5601_han_to_ucs2(ch);
          }
        else
        {
            hi = sal::static_int_cast<unsigned char>(index / (0x100 - 0x31 - 0x11 - 2) + 0xE0);
            lo = sal::static_int_cast<unsigned char>(index % (0x100 - 0x31 - 0x11 - 2) + 0x31);
            if (lo >= 0x7F)
                lo += 0x12;
            ch = (hi << 8) | lo;
        }
          //printf("hcharconv Hanja[%04x]\n",ch);
          dest[0] = ch;
        return 1;
    }
    if (LineCharDir(ch))
    {
         dest[0] = lineCharConv(ch);
        return 1;
    }
    else if (0x2f00 <= ch && ch <= 0x2f6f && (ch & 0x0f) < 9)
    {
// bullet
        lo = sal::static_int_cast<unsigned char>(ch & 0x0f);

        if( codeType != KSSM )
        {
            if (ch < 0x2f10) ch = 0xa1e0;
            else if (ch < 0x2f20) ch = 0xa1db;
            else if (ch < 0x2f30) ch = 0xa1de;
            else if (ch < 0x2f40) ch = 0xa1e2;
            else if (ch < 0x2f50) ch = 0xa1e4;
            else if (ch < 0x2f60) ch = 0xa2b7;
            else ch = 0xa2b9;

            ch = (lo < 6) ? ch : ch + 1;
                if( codeType == UNICODE)
                     ch = ksc5601_sym_to_ucs2(ch);
        }
        else
        {
            if (ch < 0x2f10) ch = 0xd970;
            else if (ch < 0x2f20) ch = 0xd96b;
            else if (ch < 0x2f30) ch = 0xd96e;
            else if (ch < 0x2f40) ch = 0xd972;
            else if (ch < 0x2f50) ch = 0xd974;
            else if (ch < 0x2f60) ch = 0xd9b7;
            else ch = 0xd9b9;
            ch = (lo < 6) ? ch : ch + 1;
        }
          //printf("hcharconv Bullet[%04x]\n",ch);
          dest[0] = ch;
        return 1 ;
    }
/**
 * Ư ڵ
 * Ʒѱۿ 0x3400 Ưڰ ۵ȴ.  0xA1A0
 */
    else
    {
        if( codeType != KSSM )
        {
               //printf("code[0x%04x]\n",ch);
                hchar ch2 = ch;
            ch = s_hh2ks(ch);
                //printf("code ks[0x%04x]\n",ch);
                if( codeType == UNICODE ){
                     if (ch < 128){
                         dest[0] = ch;
                          return 1;
                     }
                     /* ѱ۰ǻ : 0x37c0 ~ 0x37c5 */
                     if( ch2 >= 0x37c0 && ch2 <= 0x37c5 ){
                         if( ch2 == 0x37c0 ) dest[0] = 0xd55c;
                         else if( ch2 == 0x37c1 ) dest[0] = 0xae00;
                         else if( ch2 == 0x37c2 ) dest[0] = 0xacfc;
                         else if( ch2 == 0x37c3 ) dest[0] = 0xcef4;
                         else if( ch2 == 0x37c4 ) dest[0] = 0xd4e8;
                         else if( ch2 == 0x37c5 ) dest[0] = 0xd130;
                         return 1;
                     }
                     if( ch == 0x2020 ){
                          switch( ch2 ){
                                case 0x309b :
                                     ch = 0xff62;
                                     break;
                                case 0x309d :
                                     ch = 0xff63;
                                     break;
                                default:
                                     ch = 0x25a1;
                                     break;
                          }
                     }
                     else{
                          ch = ksc5601_sym_to_ucs2(ch);
                     }
                     //printf("code ucs2[0x%04x]\n",ch);
                }
        }
        else{
            ch = s_hh2kssm(ch);
          }

        if (ch == 0){ // not '?', but square mark
                if( codeType == UNICODE )
                     dest[0] =  0x25A1;
                else
                     dest[0] =  0xA1E0;
                return 1;
          }
          //printf("hcharconv Special[%04x]\n",ch);
          dest[0] = ch;
        return 1;
    }
}

/* ѱ . */
int kssm_hangul_to_ucs2(hchar ch, hchar *dest)
{
    hchar choseong, joongseong, jongseong;

    choseong = ((ch >> 10) & 0x1f);
    joongseong = ((ch >> 5) & 0x1f);
    jongseong = (ch & 0x1f) ;

     //printf("kssm_hangul_to_ucs2 : [%d,%d,%d]\n", choseong,joongseong,jongseong);

     if( joongseong < 2 ){ /* յ   ߼=0,1 */
         if( joongseong == 0 && ch < 0xa414 ){ /*  ڸ */
             int index = choseong * 32 + jongseong;
             dest[0] = jamo_to_unicode[index];
             return 1;
         }
         else{ /*  ڸ : ̺ ̿ϼ */
             unsigned int index = choseong * 32 + jongseong - 308;
             if( index < SAL_N_ELEMENTS(jamocomp1_to_unicode) ){
                 dest[0] = jamocomp1_to_unicode[index].v1;
                 dest[1] = jamocomp1_to_unicode[index].v2;
                 dest[2] = jamocomp1_to_unicode[index].v3;
                 return jamocomp1_to_unicode[index].size;
             }
             dest[0] = 0x25a1; // empty square.
             return 1;
         }
     }
     else if ( choseong == 1 && jongseong == 1 ){ /*  */
         dest[0] = joongseong_to_unicode[joongseong];
         return 1;
     }
     else if ( joongseong == 2 && jongseong == 1 ){  /*  */
         dest[0] = choseong_to_unicode[choseong];
       return 1;
    }
     else if( choseong > 20 || choseong == 0 ||
             joongseong == 17 || joongseong == 24 ||
             joongseong == 25 || joongseong > 29 ||
             jongseong == 0 || jongseong == 18 ||
             jongseong > 29 ||
             choseong == 1 || joongseong == 2  /* ϼ  ѱ */
             ) { /*  */
         int count = 0;
         if( choseong != 1 ){
             dest[count] = choseong_to_unicode[choseong];
             count++;
         }
         if( joongseong > 2 ){
             dest[count] = joongseong_to_unicode[joongseong];
             count++;
         }
         if( jongseong != 1 ){
             dest[count] = jongseong_to_unicode[jongseong];
             count++;
         }
         return count;
    }

    choseong -= 2;
    if( joongseong < 0x8 )
         joongseong -= 3;
    else if( joongseong < 0x10 )
         joongseong -= 5;
    else if( joongseong < 0x18 )
         joongseong -= 7;
    else
         joongseong -= 9;

    choseong *= (NUM_JOONGSEONG * NUM_JONGSEONG);
    joongseong *= NUM_JONGSEONG;
    jongseong -= jongseong > 0x12 ?  2 : 1;

     dest[0] = UNI_HANGUL_FIRST + choseong + joongseong + jongseong;
    return 1;
}

hchar ksc5601_sym_to_ucs2 (hchar input)
{
    unsigned char ch = sal::static_int_cast<unsigned char>(input >> 8);
    unsigned char ch2;
    int idx;

    ch2 = sal::static_int_cast<unsigned char>(input & 0xff);
    idx = (ch - 0xA1) * 94 + (ch2 - 0xA1);
    if (idx <= 1114 && idx >= 0){
    hchar value = ksc5601_sym_to_ucs[idx];
    return value ? value :  0x25a1;
    }
    return 0x25a1;
}

hchar ksc5601_han_to_ucs2 (hchar input)
{
    unsigned char ch = sal::static_int_cast<unsigned char>(input >> 8);
    unsigned char ch2;
    int idx;

    ch2 = sal::static_int_cast<unsigned char>(input & 0xff);
    idx = (ch - 0xA1) * 94 + (ch2 - 0xA1);
    if (idx >= 3854){
    // Hanja : row 42 - row 93 : 3854 = 94 * (42-1)
    hchar value = ksc5601_hanja_to_ucs[idx - 3854];
    return value ? value : '?';
    }
    return '?';
}

hchar* hstr2ucsstr(hchar* hstr, hchar* ubuf)
{
  int i = 0, j;
  int res;
  hchar dest[3];
  hchar *tmp = ubuf;
  for( ; *hstr ; ){
      res = hcharconv(*hstr++, dest, UNICODE);
      for( j = 0 ; j < res ; j++)
            tmp[i++] = dest[j];
  }

  tmp[i]= '\0';
  return ubuf;
}
/**
 * ĽƮ ϼƮ ȯѴ
 */
int hstr2ksstr(hchar* hstr, char* buf)
{

    int i = 0, res, j;
    int c;
     hchar dest[3];
    char *tmp = buf;
    for( ; *hstr ; )
    {
        res = hcharconv(*hstr++, dest, KS);
          for( j = 0 ; j < res ; j++ ){
              c = dest[j];
              if( c < 32 ) c = ' ';
              else if( c < 256 ) 
                    tmp[i++] = sal::static_int_cast<char>(c);
              else
              {
                    tmp[i++] = sal::static_int_cast<char>((c >> 8 ) & 0xff);
                    tmp[i++] = sal::static_int_cast<char>(c & 0xff);
              }
          }
    }
    tmp[i]= '\0';

    return i;
}


/*
 * ѱۿ  ڱ   ִ kcharŸ ڿ
 * ѱۿ ϴ hcharŸ ڿ ȯѴ.
 */
unsigned short *kstr2hstr( unsigned char *src, unsigned short *dest )
{
    int i=0, ii;
    unsigned short* tmp = dest;

    for(i=0,ii=0 ; src[i] != '\0' ; i++,ii++ )
    {
        if ( src[i] < 127 )
        {
            tmp[ii] = src[i];
        }
        else
        {
            tmp[ii] = src[i] << 8 | src[i+1];
            i++;
        }
    }
    tmp[ii] = '\0';
    return dest;
}


/**
 * Transfer interger to string following format
 */
char* Int2Str(int value, const char *format, char *buf)
{
    sprintf(buf,format,value);
    return buf;
}


/* colorε   Ͽ Ÿǽ color ȯ */
char *hcolor2str(uchar color, uchar shade, char *buf, bool bIsChar)
{
    unsigned short red,green,blue;

    switch( (int)color )
    {
        case 0 :                                  // black
            red =  0xff * (100 - shade ) /100;
            green =  0xff * (100 - shade ) /100;
            blue =  0xff * (100 - shade ) /100;
            break;
        case 1:                                   // blue
            red =  0xff * (100 - shade ) /100;
            green =  0xff * (100 - shade ) /100;
            blue = 0xff;
            break;
        case 2:                                   // green
            red =  0xff * (100 - shade ) /100;
                if( bIsChar )
                     green = 0x80;
                else
                     green = 0xff;
            blue =  0xff * (100 - shade ) /100;
            break;
        case 3:                                   // cyan
            red =  0xff * (100 - shade ) /100;
            green = 0xff;
            blue = 0xff;
            break;
        case 4:                                   // red
            red = 0xff;
            green =  0xff * (100 - shade ) /100;
            blue =  0xff * (100 - shade ) /100;
            break;
        case 5:                                   // magenta
            red = 0xff;
            green =  0xff * (100 - shade ) /100;
            blue = 0xff;
            break;
        case 6:                                   //yellow
            red = 0xff;
            green = 0xff;
            blue =  0xff * (100 - shade ) /100;
            break;
        case 7:                                   //white
        default:
            red = 0xff;
            green = 0xff;
            blue = 0xff;
            break;
    }

    sprintf(buf,"#%02x%02x%02x", red, green, blue);
    return buf;
}


char *urltounix(const char *src, char *dest )
{
    if( src[0] == 'C' && src[1] == ':' && src[2] == '\\' ) // Home Dir
    {
        unsigned int i, len;
        sprintf(dest,"file://%s/", getenv("HOME") );
        len = strlen( dest );

        for( i = 0 ; i + 3 < strlen(src) ; i++ )
        {
            if( src[i + 3] == '\\')
                dest[i + len] = '/';
            else
                dest[i + len] = src[ i +3];
        }
        dest[i + len] = '\0';
        return dest;
    }
    else if( src[0] == 'D' && src[1] == ':' && src[2] == '\\' ) // Root Dir
    {
        unsigned int i, len;
        sprintf(dest,"file:///");
        len = strlen( dest );
        for( i = 0 ; i + 3 < strlen(src) ; i++ )
        {
            if( src[i + 3] == '\\')
                dest[i + len] = '/';
            else
                dest[i + len] = src[i+3];
        }
        dest[i + len] = '\0';
        return dest;
    }
    else if( !strncmp(src,"http",4)  ) // Start from "http"
     {
        unsigned int i;
        for( i = 0 ; i < strlen(src) ; i++ )
        {
            if( src[i] == '\\')
                dest[i] = '/';
            else
                dest[i] = src[i];
        }
        dest[i] = '\0';
        return dest;
    }
     else
    {
        unsigned int i, len, srclen;
          srclen = strlen(src);
          char ext[4];
          strncpy(ext,src + srclen - 3,3);
          ext[3]=0;
#ifdef _WIN32
          if( _strnicmp(ext,"HWP",3) && _strnicmp(ext,"HWT",3))
#else
          if( strcasecmp(ext,"HWP") && strcasecmp(ext,"HWT"))
#endif
              sprintf(dest, "http://");
          len = strlen(dest);
        for( i = 0 ; i < strlen(src) ; i++ )
        {
            if( src[i] == '\\')
                dest[i+len] = '/';
            else
                dest[i+len] = src[i];
        }
        dest[i+len] = '\0';
        return dest;
     }
}

#ifdef _WIN32
char *urltowin(const char *src, char *dest )
{
    if( !_strnicmp(src, "http", 4))
     {
        int i;
        for( i = 0 ; i < sal::static_int_cast<int>(strlen(src)) ; i++ )
        {
            if( src[i] == '\\')
                dest[i] = '/';
            else
                dest[i] = src[i];
        }
        dest[i] = '\0';
        return dest;
    }
     else
    {
        int i, len, srclen;
          srclen = strlen(src);
          char ext[4];
          strncpy(ext,src + srclen - 3,3);
          ext[3]=0;
          //printf("hcode.cpp : ext = %s\n",ext);

          if( !_strnicmp(ext,"HWP",3) || !_strnicmp(ext,"HWT",3)){
                strcpy(dest,src);
                return dest;
          }
          sprintf(dest, "http://");
          len = strlen(dest);
        for( i = 0 ; i < sal::static_int_cast<int>(strlen(src)) ; i++ )
        {
            if( src[i] == '\\')
                dest[i+len] = '/';
            else
                dest[i+len] = src[i];
        }
        dest[i+len] = '\0';
        return dest;
     }
}
#endif

char* base64_encode_string( const uchar *buf, unsigned int len )
{
    char basis_64[] =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    char * out;
    int inPos  = 0;
    int outPos = 0;
    int c1, c2, c3;
    unsigned int i;

    out=(char *)malloc( (len*4/3)+8 );

/* Get three characters at a time and encode them. */
    for (i=0; i < len/3; ++i)
    {
        c1 = buf[inPos++] & 0xFF;
        c2 = buf[inPos++] & 0xFF;
        c3 = buf[inPos++] & 0xFF;
        out[outPos++] = basis_64[(c1 & 0xFC) >> 2];
        out[outPos++] = basis_64[((c1 & 0x03) << 4) | ((c2 & 0xF0) >> 4)];
        out[outPos++] = basis_64[((c2 & 0x0F) << 2) | ((c3 & 0xC0) >> 6)];
        out[outPos++] = basis_64[c3 & 0x3F];
    }

/* Encode the remaining one or two characters. */

    switch (len % 3)
    {
        case 0:
            break;
        case 1:
            c1 = buf[inPos] & 0xFF;
            out[outPos++] = basis_64[(c1 & 0xFC) >> 2];
            out[outPos++] = basis_64[((c1 & 0x03) << 4)];
            out[outPos++] = '=';
            out[outPos++] = '=';
            break;
        case 2:
            c1 = buf[inPos++] & 0xFF;
            c2 = buf[inPos] & 0xFF;
            out[outPos++] = basis_64[(c1 & 0xFC) >> 2];
            out[outPos++] = basis_64[((c1 & 0x03) << 4) | ((c2 & 0xF0) >> 4)];
            out[outPos++] = basis_64[((c2 & 0x0F) << 2)];
            out[outPos++] = '=';
            break;
    }
    out[outPos] = 0;
    return out;
}

double calcAngle(int x1, int y1, int x2, int y2)
{
     y1 = -y1;
     y2 = -y2;
     if( x2 == x1 ){
          if( y2 >= y1 )
                return 0.;
          else
                return 270.;
     }
     double angle;
     angle = (180 / PI) * atan( ( y2 - y1 ) * 1.0 / ( x2 - x1 ));
     if( y2 >= y1 ){ /* 1,2и */
          if( angle < 0. )
                angle += 180.;
     }
     else{ /* 3, 4 и */
          if( angle > 0 )
                angle += 180.;
          else
                angle += 360.;
     }
     return angle;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
