/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.testng.IInvokedMethodListener;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.TestResult;
import org.testng.junit.IJUnitTestRunner;
import org.testng.junit.JUnit4TestClass;
import org.testng.junit.JUnit4TestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestRunner
implements IJUnitTestRunner {
    private ITestResultNotifier m_parentRunner;
    private List<ITestNGMethod> m_methods = Lists.newArrayList();
    private List<ITestListener> m_listeners = Lists.newArrayList();
    private List<IInvokedMethodListener> m_invokeListeners = Lists.newArrayList();

    public JUnit4TestRunner() {
    }

    public JUnit4TestRunner(ITestResultNotifier tr) {
        this.m_parentRunner = tr;
        this.m_listeners = this.m_parentRunner.getTestListeners();
    }

    @Override
    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    @Override
    public void setTestResultNotifier(ITestResultNotifier notifier) {
        this.m_parentRunner = notifier;
        this.m_listeners = this.m_parentRunner.getTestListeners();
    }

    @Override
    public void setInvokedMethodListeners(List<IInvokedMethodListener> listeners) {
        this.m_invokeListeners = listeners;
    }

    @Override
    public void run(Class testClass, String ... methods) {
        this.start(testClass, methods);
    }

    public Result start(Class testCase, final String ... methods) {
        try {
            JUnitCore core = new JUnitCore();
            core.addListener((RunListener)new RL());
            Request r = Request.aClass((Class)testCase);
            return core.run(r.filterWith(new Filter(){

                public boolean shouldRun(Description description) {
                    if (description == null) {
                        return false;
                    }
                    if (methods.length == 0) {
                        return true;
                    }
                    int i$ = 0;
                    String[] arr$ = methods;
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        String m = arr$[i$];
                        Pattern p = Pattern.compile(m);
                        return p.matcher(description.getMethodName()).matches();
                    }
                    return false;
                }

                public String describe() {
                    return "TestNG method filter";
                }
            }));
        }
        catch (Throwable t) {
            throw new TestNGException("Failure in JUnit mode for class " + testCase.getName(), t);
        }
    }

    private class RL
    extends RunListener {
        private Map<Description, ITestResult> runs = new WeakHashMap<Description, ITestResult>();
        private List<Description> failures = new LinkedList<Description>();

        private RL() {
        }

        public void testAssumptionFailure(Failure failure) {
            super.testAssumptionFailure(failure);
            ITestResult tr = this.runs.get(failure.getDescription());
            tr.setStatus(2);
            tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
            tr.setThrowable(failure.getException());
            JUnit4TestRunner.this.m_parentRunner.addFailedTest(tr.getMethod(), tr);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestFailure(tr);
            }
        }

        public void testFailure(Failure failure) throws Exception {
            super.testFailure(failure);
            this.failures.add(failure.getDescription());
            ITestResult tr = this.runs.get(failure.getDescription());
            tr.setStatus(2);
            tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
            tr.setThrowable(failure.getException());
            JUnit4TestRunner.this.m_parentRunner.addFailedTest(tr.getMethod(), tr);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestFailure(tr);
            }
        }

        public void testFinished(Description description) throws Exception {
            super.testFinished(description);
            ITestResult tr = this.runs.get(description);
            if (!this.failures.contains(description)) {
                tr.setStatus(1);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                JUnit4TestRunner.this.m_parentRunner.addPassedTest(tr.getMethod(), tr);
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestSuccess(tr);
                }
            }
            JUnit4TestRunner.this.m_methods.add(tr.getMethod());
        }

        public void testIgnored(Description description) throws Exception {
            super.testIgnored(description);
            ITestResult tr = this.createTestResult(description);
            tr.setStatus(3);
            tr.setEndMillis(tr.getStartMillis());
            JUnit4TestRunner.this.m_parentRunner.addSkippedTest(tr.getMethod(), tr);
            JUnit4TestRunner.this.m_methods.add(tr.getMethod());
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestSkipped(tr);
            }
        }

        public void testRunFinished(Result result) throws Exception {
            super.testRunFinished(result);
        }

        public void testRunStarted(Description description) throws Exception {
            super.testRunStarted(description);
        }

        public void testStarted(Description description) throws Exception {
            super.testStarted(description);
            ITestResult tr = this.createTestResult(description);
            this.runs.put(description, tr);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestStart(tr);
            }
        }

        private ITestResult createTestResult(Description test) {
            JUnit4TestClass tc = new JUnit4TestClass(test);
            JUnit4TestMethod tm = new JUnit4TestMethod(tc, test);
            TestResult tr = new TestResult(tc, test, tm, null, Calendar.getInstance().getTimeInMillis(), 0L, null);
            InvokedMethod im = new InvokedMethod(tr.getTestClass(), tr.getMethod(), new Object[0], true, false, tr.getStartMillis(), tr);
            JUnit4TestRunner.this.m_parentRunner.addInvokedMethod(im);
            for (IInvokedMethodListener l : JUnit4TestRunner.this.m_invokeListeners) {
                l.beforeInvocation(im, tr);
            }
            return tr;
        }
    }
}

