/* gphoto2-library.h:
 * 
 * Copyright  2000 Scott Fritzinger
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details. 
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GPHOTO2_LIBRARY_H__
#define __GPHOTO2_LIBRARY_H__

#include <gphoto2-abilities-list.h>
#include <gphoto2-camera.h>
#include <gphoto2-context.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * CameraLibraryIdFunc:
 * @id: a #CameraText
 *
 * Returns a unique @id for the camera driver.
 *
 * Return value: a gphoto2 error code
 **/
typedef int (* CameraLibraryIdFunc)        (CameraText *id);

/**
 * CameraLibraryAbilitiesFunc:
 * @list: a #CameraAbilitiesList
 *
 * Adds the abilities of the supported models to the supplied @list.
 *
 * Return value: a gphoto2 error code
 **/
typedef int (* CameraLibraryAbilitiesFunc) (CameraAbilitiesList *list);

/**
 * CameraLibraryInitFunc:
 * @camera: a #Camera
 * @context: a #GPContext
 *
 * Initializes the camera. The camera driver will establish a first connection
 * to the camera and configure the @camera variable (i.e. using 
 * #gp_filesystem_set_list_funcs or #gp_port_get_settings).
 *
 * Return value: a gphoto2 error code
 **/
typedef int (* CameraLibraryInitFunc)      (Camera *camera, GPContext *context);

/*
 * If you want to write a camera library, you need to implement 
 * the following three functions. Everything else should be declared
 * as static.
 */
int camera_id		(CameraText *id);
int camera_abilities 	(CameraAbilitiesList *list);
int camera_init 	(Camera *camera, GPContext *context);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GPHOTO2_LIBRARY_H__ */
