/*
 * Copyright (C) 2006 Novell, Inc (http://www.novell.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *          Sebastien Pouliot  <sebastien@ximian.com>
 */

#ifndef _REGION_BITMAP_H_
#define _REGION_BITMAP_H_

#include "gdip.h"

/* internal (private) API for regions bitmaps */

/*
 * REGION_MAX_BITMAP_SIZE defines the size limit of the region bitmap we keep
 * in memory. The current value is 2 megabits which should be enough for any 
 * on-screen region. Before changing this value remember that a "real", but 
 * temporary, ARGB32 bitmap (32 times bigger, i.e. 8MB) may be allocated when 
 * converting the path into the region bitmap.
 */
#define REGION_MAX_BITMAP_SIZE		(2 * 1024 * 1024 >> 3)

#define SHAPE_SIZE(shape)		(((shape)->Width * (shape)->Height) >> 3)

/* bitmap creation */
void gdip_region_bitmap_ensure (GpRegion *region);
GpRegionBitmap* gdip_region_bitmap_from_path (GpPath *path);
GpRegionBitmap* gdip_region_bitmap_clone (GpRegionBitmap *bitmap);

void gdip_region_bitmap_free (GpRegionBitmap *bitmap);
void gdip_region_bitmap_invalidate (GpRegion *region);

BOOL gdip_region_bitmap_compare (GpRegionBitmap *shape1, GpRegionBitmap *shape2);
BOOL gdip_region_bitmap_is_point_visible (GpRegionBitmap *bitmap, int x, int y);
BOOL gdip_region_bitmap_is_rect_visible (GpRegionBitmap *bitmap, GpRect *rect);

int gdip_region_bitmap_get_scans (GpRegionBitmap *bitmap, GpRectF *rect, int count);

void gdip_region_bitmap_get_smallest_rect (GpRegionBitmap *bitmap, GpRect *rect);
void gdip_region_bitmap_shrink (GpRegionBitmap *bitmap, BOOL always_shrink);

void gdip_region_bitmap_apply_alpha (GpBitmap *bitmap, GpRegionBitmap *alpha);

GpRegionBitmap* gdip_region_bitmap_combine (GpRegionBitmap *bitmap1, GpRegionBitmap* bitmap2, CombineMode combineMode);

#endif /* _REGION_BITMAP_H_ */
