#include <ept/tests/test-utils.h>
#include <apt-pkg/configuration.h>
#include <apt-pkg/error.h>
#include <apt-pkg/pkgsystem.h>
#include <apt-pkg/init.h>

#include <ept/cache/cache.h>
#include <ept/cache/debtags/update.h>
#include <ept/init.h>
#include <ept/path.h>
// #include <ept/cache/component/debtags/update.h>

namespace tut {

#define TEST_CACHE_DIR TEST_DIR

void aptInit () {
    static bool done = false;
    if (done)
        return;
    done = true;
    pkgInitConfig (*_config);
    _config->Set("Dir", TEST_CACHE_DIR);
    _config->Set("Dir::Cache", "cache");
    _config->Set("Dir::State", "state");
    _config->Set("Dir::Etc", "etc");
    _config->Set("Dir::State::status", TEST_CACHE_DIR "dpkg-status");
    pkgInitSystem (*_config, _system);
    ept::Path::setDebtagsSourceDir( TEST_CACHE_DIR "debtags/" );
    ept::Path::setDebtagsIndexDir( TEST_CACHE_DIR "debtags/" );
    ept::Path::setDebtagsUserSourceDir( TEST_CACHE_DIR "debtags/user/" );
    ept::Path::setDebtagsUserIndexDir( TEST_CACHE_DIR "debtags/user/" );
    ept::Init::s_globalDone = true;
    ept::init();
    debtagsInit();
    // _config -> Set ("Capture::Cache::UseExtState", extstate);
}

void debtagsInit() {
    static bool done = false;
    if (done)
        return;
    done = true;
    //ept::t::cache::debtags::source< ept::configuration::Apt >::regenerateTags();
}

std::string common::testCacheDir = TEST_CACHE_DIR;
std::string common::testDebtagsCacheDir = TEST_CACHE_DIR "debtags/";

}
