/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ReverseArrayIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.xpath.XPathException;

public final class SequenceExtent
extends SequenceValue {
    private Item[] value;
    private int start = 0;
    private int end;
    private ItemType itemType = null;

    public SequenceExtent(Item[] itemArray) {
        this.value = itemArray;
        this.end = itemArray.length;
    }

    public SequenceExtent(SequenceExtent sequenceExtent, int n, int n2) {
        this.value = sequenceExtent.value;
        this.start = sequenceExtent.start + n;
        this.end = this.start + n2;
    }

    public SequenceExtent(List list) {
        this.value = new Item[list.size()];
        int n = 0;
        while (n < list.size()) {
            this.value[n] = (Item)list.get(n);
            ++n;
        }
        this.end = list.size();
    }

    public SequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        Item item;
        int n = 20;
        this.value = new Item[n];
        int n2 = 0;
        while ((item = sequenceIterator.next()) != null) {
            if (n2 >= n) {
                Item[] itemArray = new Item[n *= 2];
                System.arraycopy(this.value, 0, itemArray, 0, n2);
                this.value = itemArray;
            }
            this.value[n2++] = item;
        }
        this.end = n2;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int getCardinality() {
        switch (this.end - this.start) {
            case 0: {
                return 256;
            }
            case 1: {
                return 512;
            }
        }
        return 1536;
    }

    public ItemType getItemType() {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == this.start) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = SequenceExtent.computeItemType(this.value[this.start]);
            int n = this.start + 1;
            while (n < this.end) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, SequenceExtent.computeItemType(this.value[n]));
                ++n;
            }
        }
        return this.itemType;
    }

    private static ItemType computeItemType(Item item) {
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType();
        }
        return NodeKindTest.makeNodeKindTest(((NodeInfo)item).getNodeKind());
    }

    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return this.value[this.start + n];
    }

    public void swap(int n, int n2) {
        Item item = this.value[this.start + n];
        this.value[this.start + n] = this.value[this.start + n2];
        this.value[this.start + n2] = item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) {
        return new ArrayIterator(this.value, this.start, this.end);
    }

    public AxisIterator reverseIterate() {
        return new ReverseArrayIterator(this.value, this.start, this.end);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        int n = this.getLength();
        if (n == 0) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        Item item = this.value[0];
        if (item instanceof NodeInfo) {
            return true;
        }
        return ((AtomicValue)item).effectiveBooleanValue(xPathContext);
    }
}

