/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.ProxyReceiver;

public final class XMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameline = false;
    private boolean afterTag = true;
    private boolean allWhite = true;
    private int line = 0;
    private int column = 0;
    private int suppressedAtLevel = -1;
    private int xmlspace;

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.indentSpaces = 3;
            }
        }
        String string2 = properties.getProperty("omit-xml-declaration");
        this.afterTag = string2 == null || !string2.equals("yes") || properties.getProperty("doctype-system") != null;
    }

    public void startDocument() throws TransformerException {
        super.startDocument();
        this.xmlspace = this.getNamePool().allocate("xml", "http://www.w3.org/XML/1998/namespace", "space") & 0xFFFFF;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.afterTag) {
            this.indent();
        }
        super.startElement(n, n2, n3);
        ++this.level;
        this.sameline = true;
        this.afterTag = true;
        this.allWhite = true;
        this.line = 0;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        if ((n & 0xFFFFF) == this.xmlspace && charSequence.equals("preserve") && this.suppressedAtLevel < 0) {
            this.suppressedAtLevel = this.level;
        }
        super.attribute(n, n2, charSequence, n3);
    }

    public void endElement() throws TransformerException {
        --this.level;
        if (this.afterTag && !this.sameline) {
            this.indent();
        }
        super.endElement();
        this.sameline = false;
        this.afterTag = true;
        this.allWhite = true;
        this.line = 0;
        if (this.level == this.suppressedAtLevel - 1) {
            this.suppressedAtLevel = -1;
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        super.processingInstruction(string, charSequence, n);
        this.afterTag = true;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c = charSequence.charAt(n2);
            if (c == '\n') {
                this.sameline = false;
                ++this.line;
                this.column = 0;
            }
            if (!Character.isWhitespace(c)) {
                this.allWhite = false;
            }
            ++this.column;
            ++n2;
        }
        super.characters(charSequence, n);
        if (!this.allWhite) {
            this.afterTag = false;
        }
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        super.comment(charSequence, n);
        this.afterTag = true;
    }

    /*
     * Unable to fully structure code
     */
    private void indent() throws TransformerException {
        if (this.suppressedAtLevel >= 0) {
            return;
        }
        var1_1 = this.level * this.indentSpaces;
        if (this.line <= 0 || this.column <= var1_1) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.indentChars = this.indentChars + this.indentChars;
lbl7:
            // 2 sources

            ** while (var1_1 > this.indentChars.length())
        }
lbl8:
        // 1 sources

        super.characters("\n", 0);
        super.characters(this.indentChars.subSequence(0, var1_1), 0);
        this.sameline = false;
    }
}

