#ifndef __SPEAKUP_H
#define __SPEAKUP_H

#include <linux/version.h>

struct kbd_struct;
struct vc_data;

/* how about some prototypes! */

#if defined(CONFIG_SPEAKUP)
extern void speakup_init(struct vc_data *);
extern int speakup_dev_init(void);
extern void speakup_allocate(struct vc_data *);
extern void speakup_bs(struct vc_data *);
extern void speakup_con_write(struct vc_data *, const char *, int);
extern void speakup_con_update(struct vc_data *);
extern int speakup_key(struct vc_data*, int, int, u_short, int, struct pt_regs *);
#elif defined(CONFIG_SPEAKUP_MODULE)
typedef void (*spk_con_func)(struct vc_data * );
typedef void (*spk_write_func)(struct vc_data *, const char *, int);
typedef int (*spk_key_func)(struct vc_data*, int, int, u_short, int, struct pt_regs *);
extern void spk_set_addresses( spk_con_func allocate, spk_con_func bs,
	spk_write_func con_write, spk_con_func con_update, spk_key_func key );
#define speakup_init(vc)
extern int speakup_dev_init(void);
#else
#define speakup_allocate(vc)
#define speakup_bs(vc)
#define speakup_con_write(vc, str, len)
#define speakup_con_update(vc)
#define speakup_init(currcons)
#define speakup_dev_init()
#endif
#endif
