/*************************************************************************** 
 * RT2x00 SourceForge Project - http://rt2x00.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2004.           * 
 ***************************************************************************/

/*************************************************************************** 
 *	Module Name:	rtusb_io.c
 *
 *	Abstract:
 *
 *	Revision History:
 *	Who		When		What
 *	--------	----------	-------------------------------
 *	Name		Date		Modification logs
 *	Jan Lee		2005-06-01	Release
 ***************************************************************************/

#include	"rt_config.h"
/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBSingleRead(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUSHORT			pValue)
{
	NTSTATUS	Status;

	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_IN,
		0x3,
		0,
		Offset,
		pValue,
		2);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBSingleWrite(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	USHORT			Value)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_OUT,
		0x2,
		Value,
		Offset,
		NULL,
		0);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBMultiRead(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_IN,
		0x7,
		0,
		Offset,
		pData,
		length);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBMultiWrite(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_OUT,
		0x6,
		0,
		Offset,
		pData,
		length);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBReadMACRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUSHORT			pValue)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_IN,
		0x3,
		0,
		Offset + 0x400,
		pValue,
		2);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBWriteMACRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	USHORT			Value)
{
	NTSTATUS	Status;
	if (Offset == TXRX_CSR2)
     		DBGPRINT(RT_DEBUG_ERROR, " !!!!!set Rx control = %x\n", Value);
     
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_OUT,
		0x2,
		Value,
		Offset + 0x400,
		NULL,
		0);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBMultiReadMAC(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_IN,
		0x7,
		0,
		Offset + 0x400,
		pData,
		length);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBMultiWriteMAC(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_OUT,
		0x6,
		0,
		Offset + 0x400,
		pData,
		length);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBReadBBPRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR			Id,
	IN	PUCHAR			pValue)
{
	PHY_CSR7_STRUC	PhyCsr7;
	USHORT			temp;
	UINT			i = 0;

	if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS))
	{
		DBGPRINT(RT_DEBUG_ERROR,"device connected\n");
		return -1;
	}

	PhyCsr7.value				= 0;
	PhyCsr7.field.WriteControl	= 1;
	PhyCsr7.field.RegID 		= Id;
	RTUSBWriteMACRegister(pAdapter, PHY_CSR7, PhyCsr7.value);
	
	do
	{
		RTUSBReadMACRegister(pAdapter, PHY_CSR8, &temp);
		if (!(temp & BUSY))
			break;
		i++;
	}
	while ((i < RETRY_LIMIT) && (!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS)));

	if ((i == RETRY_LIMIT) || (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS)))
	{
		DBGPRINT_RAW(RT_DEBUG_ERROR, "Retry count exhausted or device removed!!!\n");
		return STATUS_UNSUCCESSFUL;
	}

	RTUSBReadMACRegister(pAdapter, PHY_CSR7, (PUSHORT)&PhyCsr7);
	*pValue = (UCHAR)PhyCsr7.field.Data;
	
	return STATUS_SUCCESS;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBWriteBBPRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR			Id,
	IN	UCHAR			Value)
{
	PHY_CSR7_STRUC	PhyCsr7;
	USHORT			temp;
	UINT			i = 0;

	if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS))
	{
		DBGPRINT(RT_DEBUG_ERROR,"device connected\n");
		return -1;
	}
	do
	{
		RTUSBReadMACRegister(pAdapter, PHY_CSR8, &temp);
		if (!(temp & BUSY))
			break;
		i++;
	}
	while ((i < RETRY_LIMIT) && (!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS)));

	if ((i == RETRY_LIMIT) || (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS)))
	{
		DBGPRINT_RAW(RT_DEBUG_ERROR, "Retry count exhausted or device removed!!!\n");
		return STATUS_UNSUCCESSFUL;
	}

	PhyCsr7.value				= 0;
	PhyCsr7.field.WriteControl	= 0;
	PhyCsr7.field.RegID 		= Id;
	PhyCsr7.field.Data			= Value;
	RTUSBWriteMACRegister(pAdapter, PHY_CSR7, PhyCsr7.value);
	pAdapter->PortCfg.BbpWriteLatch[Id] = Value;
	
	return STATUS_SUCCESS;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBWriteRFRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	ULONG			Value)
{
	PHY_CSR10_STRUC	PhyCsr10;
	UINT			i = 0;

	do
	{
		RTUSBReadMACRegister(pAdapter, PHY_CSR10, (PUSHORT)&PhyCsr10);
		if (!(PhyCsr10.field.Busy))
			break;
		i++;
	}
	while ((i < RETRY_LIMIT) && (!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS)));

	if ((i == RETRY_LIMIT) || (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS)))
	{
		DBGPRINT_RAW(RT_DEBUG_ERROR, "Retry count exhausted or device removed!!!\n");
		return STATUS_UNSUCCESSFUL;
	}

	RTUSBWriteMACRegister(pAdapter, PHY_CSR9, (USHORT)(Value & 0x0000ffff));
	
	PhyCsr10.value = (USHORT)(Value >> 16);
	RTUSBWriteMACRegister(pAdapter, PHY_CSR10, PhyCsr10.value);
	
	return STATUS_SUCCESS;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBReadEEPROM(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_IN,
		0x9,
		0,
		Offset,
		pData,
		length);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSBWriteEEPROM(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length)
{
	NTSTATUS	Status;
	
	Status = RTUSB_VendorRequest(
		pAdapter,
		0,
		DEVICE_VENDOR_REQUEST_OUT,
		0x8,
		0,
		Offset,
		pData,
		length);
	
	return Status;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
VOID	RTUSBDequeueCmd(
	IN	PCmdQ		cmdq,
	OUT	PCmdQElmt	*pcmdqelmt)
{
	*pcmdqelmt = cmdq->head;
	
	if (*pcmdqelmt != NULL)
	{
		cmdq->head = cmdq->head->next;
		cmdq->size--;
		if (cmdq->size == 0)
			cmdq->tail = NULL;
	}
}
/*
	  usb_control_msg - Builds a control urb, sends it off and waits for completion
	  @dev: pointer to the usb device to send the message to
	  @pipe: endpoint "pipe" to send the message to
	  @request: USB message request value
	  @requesttype: USB message request type value
	  @value: USB message value
	  @index: USB message index value
	  @data: pointer to the data to send
	  @size: length in bytes of the data to send
	  @timeout: time in jiffies to wait for the message to complete before
			  timing out (if 0 the wait is forever)
	  Context: !in_interrupt ()

	  This function sends a simple control message to a specified endpoint
	  and waits for the message to complete, or timeout.
	  If successful, it returns the number of bytes transferred, otherwise a negative error number.

	 Don't use this function from within an interrupt context, like a
	  bottom half handler.	If you need an asynchronous message, or need to send
	  a message from within interrupt context, use usb_submit_urb()
	  If a thread in your driver uses this call, make sure your disconnect()
	  method can wait for it to complete.  Since you don't have a handle on
	  the URB used, you can't cancel the request.
  
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
INT	RTUSB_VendorRequest(
	IN	PRT2570ADAPTER	pAdapter,
	IN	ULONG			TransferFlags,
	IN	UCHAR			RequestType,
	IN	UCHAR			Request,
	IN	USHORT			Value,
	IN	USHORT			Index,
	IN	PVOID			TransferBuffer,
	IN	ULONG			TransferBufferLength)
{
	int ret;

	if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_REMOVE_IN_PROGRESS))
	{
		DBGPRINT(RT_DEBUG_ERROR,"device connected\n");
		return -1;
	}
	else if (in_interrupt())	
	{
		DBGPRINT(RT_DEBUG_ERROR,"in_interrupt, return RTUSB_VendorRequest\n");

		return -1;
	}
	else
	{
	
		if( RequestType == DEVICE_VENDOR_REQUEST_OUT)
			ret=usb_control_msg(pAdapter->usb, usb_sndctrlpipe( pAdapter->usb, 0 ), Request, RequestType, Value,Index, TransferBuffer, TransferBufferLength, CONTROL_TIMEOUT_JIFFIES);
		else if(RequestType == DEVICE_VENDOR_REQUEST_IN)
			ret=usb_control_msg(pAdapter->usb, usb_rcvctrlpipe( pAdapter->usb, 0 ), Request, RequestType, Value,Index, (PUSHORT)TransferBuffer, TransferBufferLength, CONTROL_TIMEOUT_JIFFIES);
		else
		{
			DBGPRINT(RT_DEBUG_ERROR,"vendor request direction is failed\n");
			ret = -1;
		}

		if((RequestType == DEVICE_VENDOR_REQUEST_OUT) && (ret != 0))
			DBGPRINT(RT_DEBUG_TRACE,"USBVendorRequest  ret=%d,	\n",ret);
	
//	if((RequestType == DEVICE_VENDOR_REQUEST_IN) && (ret != 2))
//		DBGPRINT(RT_DEBUG_TRACE,"USBVendorRequest	read ret=%d,  TransferBuffer = 0x%x\n",ret, *(PUSHORT)TransferBuffer);
//	if((TransferBuffer != NULL) )
//		DBGPRINT(RT_DEBUG_TRACE,"USBVendorRequest	ret=%d, read from = 0x%x TransferBuffer = 0x%x\n",ret,Value, *(PUSHORT)TransferBuffer);

		if (ret <0) {
			int temp_i=0;
			DBGPRINT(RT_DEBUG_ERROR,"USBVendorRequest failed ret=%d, \n",ret);
			ret = 0;
			do
			{
				if( RequestType == DEVICE_VENDOR_REQUEST_OUT)
					ret=usb_control_msg(pAdapter->usb, usb_sndctrlpipe( pAdapter->usb, 0 ), Request, RequestType, Value,Index, TransferBuffer, TransferBufferLength, CONTROL_TIMEOUT_JIFFIES);
				else if(RequestType == DEVICE_VENDOR_REQUEST_IN)
					ret=usb_control_msg(pAdapter->usb, usb_rcvctrlpipe( pAdapter->usb, 0 ), Request, RequestType, Value,Index, (PUSHORT)TransferBuffer, TransferBufferLength, CONTROL_TIMEOUT_JIFFIES);
				temp_i++;
			} while( (ret < 0) && (temp_i <= 1) );

			if( ret >= 0)
				return ret;
			
		}
	}
	return ret;
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
VOID	RTUSBInitializeCmdQ(
	IN	PCmdQ	cmdq)
{
	cmdq->head = NULL;
	cmdq->tail = NULL;
	cmdq->size = 0;
}


/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NDIS_STATUS	RTUSBEnqueueCmdFromNdis(
	IN	PRT2570ADAPTER	pAdapter,
	IN	NDIS_OID		Oid,
	IN	BOOLEAN			SetInformation,
	IN	PVOID			pInformationBuffer,
	IN	ULONG			InformationBufferLength)
{
	PCmdQElmt	cmdqelmt = NULL;
	
	if (pAdapter->RTUSBCmdThr_pid < 0) 
		return NDIS_STATUS_RESOURCES;

	cmdqelmt = (PCmdQElmt) kmalloc(sizeof(CmdQElmt), GFP_KERNEL);
	if (!cmdqelmt) 
	{
		DBGPRINT(RT_DEBUG_ERROR,"Not enough memory\n");
		kfree((PCmdQElmt)cmdqelmt);
		return NDIS_STATUS_RESOURCES;
	}

	if ((Oid == RT_OID_SINGLE_READ_MAC) ||
		(Oid == RT_OID_MULTI_READ_MAC) ||
		(Oid == RT_OID_VENDOR_READ_BBP) ||
		(Oid == RT_OID_USB_VENDOR_EEPROM_READ))
	{
		cmdqelmt->buffer = pInformationBuffer;
	}
	else
	{
		cmdqelmt->buffer = NULL;
		if (pInformationBuffer != NULL)
		{
			cmdqelmt->buffer =	kmalloc(InformationBufferLength, GFP_KERNEL);
			if ((!cmdqelmt->buffer) )
			{
				kfree((PVOID)cmdqelmt->buffer);
				kfree((PCmdQElmt)cmdqelmt);
				return (NDIS_STATUS_RESOURCES);
			}
			else
			{
				memcpy(cmdqelmt->buffer, pInformationBuffer, InformationBufferLength);
				cmdqelmt->bufferlength = InformationBufferLength;
			}
		}
		else
			cmdqelmt->bufferlength = 0;
	}
	
	cmdqelmt->command = Oid;
	cmdqelmt->CmdFromNdis = TRUE;
	if (SetInformation == TRUE)
		cmdqelmt->SetOperation = TRUE;
	else
		cmdqelmt->SetOperation = FALSE;

	NdisAcquireSpinLock(&pAdapter->CmdQLock);
	EnqueueCmd((&pAdapter->CmdQ), cmdqelmt);
	NdisReleaseSpinLock(&pAdapter->CmdQLock);
	
	RTUSBCMDUp(pAdapter, &pAdapter->RTUSBCmd_semaphore);

	if ((Oid == OID_802_11_BSSID_LIST_SCAN) ||
		(Oid == RT_OID_802_11_BSSID) ||
		(Oid == OID_802_11_SSID) ||
		(Oid == OID_802_11_DISASSOCIATE))
	{
		return(NDIS_STATUS_SUCCESS);
	}
	else
	{
		//IncrementIoCount(pAdapter);
		//return(NDIS_STATUS_PENDING);
	}
		return(NDIS_STATUS_SUCCESS);
}

/*
	========================================================================
	
	Routine Description:

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
VOID	RTUSBEnqueueInternalCmd(
	IN	PRT2570ADAPTER	pAdapter,
	IN	NDIS_OID		Oid)
{
	PCmdQElmt	cmdqelmt = NULL;

	if (pAdapter->RTUSBCmdThr_pid < 0) 
		return;
	
	switch (Oid)
	{
		case RT_OID_CHECK_GPIO:
			cmdqelmt = &(pAdapter->CmdQElements[CHECK_GPIO]);
			break;
			
		case RT_OID_PERIODIC_EXECUT:
			cmdqelmt = &(pAdapter->CmdQElements[PERIODIC_EXECUT]);
			break;
			
		//For Alpha only
		case RT_OID_ASICLED_EXECUT:
			cmdqelmt = &(pAdapter->CmdQElements[ASICLED_EXECUT]);
			break;

		case RT_OID_UPDATE_TX_RATE:
			cmdqelmt = &(pAdapter->CmdQElements[UPDATE_TX_RATE]);
			break;
			
		case RT_OID_SET_PSM_BIT_SAVE:
			cmdqelmt = &(pAdapter->CmdQElements[SET_PSM_SAVE]);
			break;
			
		case RT_OID_LINK_DOWN:
			cmdqelmt = &(pAdapter->CmdQElements[LINK_DOWN]);
			break;
			
		case RT_OID_USB_RESET_BULK_IN:
			cmdqelmt = &(pAdapter->CmdQElements[RESET_BULKIN]);
			break;
			
		case RT_OID_USB_RESET_BULK_OUT:
			cmdqelmt = &(pAdapter->CmdQElements[RESET_BULKOUT]);
			break;
			
		case RT_OID_RESET_FROM_ERROR:
			cmdqelmt = &(pAdapter->CmdQElements[RESET_FROM_ERROR]);
			break;
			
		case RT_OID_RESET_FROM_NDIS:
			cmdqelmt = &(pAdapter->CmdQElements[RESET_FROM_NDIS]);
			break;

		default:
			break;
	}

	if ((cmdqelmt != NULL) && (cmdqelmt->InUse == FALSE) && (pAdapter->RTUSBCmdThr_pid > 0))
	{
		cmdqelmt->InUse = TRUE;
		cmdqelmt->command = Oid;

		NdisAcquireSpinLock(&pAdapter->CmdQLock);
		EnqueueCmd((&pAdapter->CmdQ), cmdqelmt);
		NdisReleaseSpinLock(&pAdapter->CmdQLock);
		RTUSBCMDUp(pAdapter, &pAdapter->RTUSBCmd_semaphore);
	}
}

/*
	========================================================================
	
	Routine Description:
	  Creates an IRP to submite an IOCTL_INTERNAL_USB_RESET_PORT
	  synchronously. Callers of this function must be running at
	  PASSIVE LEVEL.

	Arguments:

	Return Value:

	IRQL = 
	
	Note:
	
	========================================================================
*/
NTSTATUS	RTUSB_ResetDevice(
	IN	PRT2570ADAPTER	pAdapter)
{
	NTSTATUS		Status = TRUE;

	DBGPRINT_RAW(RT_DEBUG_TRACE, "--->USB_ResetDevice\n");
	//RTMP_SET_FLAG(pAdapter, fRTMP_ADAPTER_RESET_IN_PROGRESS);
	return Status;
}


