/* $Id: zdbuf.h,v 1.4 2005/03/27 20:47:36 sagamore Exp $
 *
 * Copyright (C) 2004 Zydas Inc.
 * Copyright (C) 2005 Arno WILLIG <akw@users.sourceforge.net>
 * Copyright (C) 2005 Dimitriy KOROVKIN <korovkin@users.sourceforge.net>
 * Copyright (C) 2005 Todor T. ZVISKOV <warderx@users.sourceforge.net>
 * Copyright (C) 2005 Markus KARG <markus-karg@users.sourceforge.net>
 *
 * This file is part of the ZD1211 Wireless USB Driver for Linux.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ZDBUF_H__
#define __ZDBUF_H__

extern SignalQ_t mgtQ, *pMgtQ;
extern SignalQ_t txQ, *pTxQ;	
extern SignalQ_t awakeQ, *pAwakeQ;
extern SignalQ_t psQ[MAX_RECORD], *pPsQ[MAX_RECORD];
extern U32 freeSignalCount;
extern U32 freeFdescCount;

void initSigQue(SignalQ_t *Q);
void sigEnque(SignalQ_t *Q, Signal_t *signal);
void sigEnqueFirst(SignalQ_t *Q, Signal_t *signal);	
Signal_t *sigDeque(SignalQ_t* Q);
void initSignalBuf(void);
void initFdescBuf(void);
void freeFdesc(FrmDesc_t *pfrmDesc);
FrmDesc_t *allocFdesc(void);
extern Signal_t* allocSignal(void);
extern void freeSignal(Signal_t *signal);
void releaseSignalBuf(void);
void releaseFdescBuf(void);
#endif
