import unittest, gettext, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.collector import Collector
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class UDebBinaryCheckUDebTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/udebbinary.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['udeb'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])
    
    def test_control(self):
        "Check check_control() method of UDebBinaryCheck"
        method = getattr(self.instance, 'check_control')
        self.instance.information['control'] = {'self': [{'architecture': \
            'foo', 'description': ['lala,foo']}]}
        method()
        self.assertEqual(self.instance.arch, 'foo')
        self.assert_('comma-in-short-desc' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'comma-in-short-desc'), True)

    def test_dirs(self):
        "Check check_dirs() method of UDebBinaryCheck"
        method = getattr(self.instance, 'check_dirs')
        self.instance.information['collector'] = Collector('bin', '/tmp', '')
        for dir in ('usr/share/doc', 'usr/share/man', 'usr/local'):
            os.makedirs(os.path.join(self.instance.information['dir'], \
                'unpacked', dir))
        method()
        expected_errs = Set(('usr-share-doc-in-udeb', \
            'usr-share-man-in-udeb', 'usr-local-in-udeb'))
        self.assertEqual(expected_errs.intersection(self.instance.err_dict.keys()), expected_errs)
        for key in expected_errs:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)
        shutil.rmtree('%s/unpacked' % self.instance.information['dir'])
        self.instance.arch = 'all'
        self.instance.information['collector'].set('files', 'elf', \
            ['a'])
        method()
        self.assert_('udeb-pkg-should-be-arch-any' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'udeb-pkg-should-be-arch-any'), True)

    def test_files(self):
        "Check check_files() method of UDebBinaryCheck"
        method = getattr(self.instance, 'check_files')
        self.instance.information['collector'] = Collector('bin', '/tmp', '')
        self.instance.information['collector'].set('files', 'files', \
            {'/usr/share/lala': '', '/usr/doc/foo': '', \
            '/usr/bin/CVS/Root': ''})
        method()
        expected_errs = Set(('file-in-u-s', 'usr-doc-in-udeb', \
            'cvs-dir-in-udeb'))
        self.assertEqual(expected_errs.intersection(self.instance.err_dict.keys()), expected_errs)
        for key in expected_errs:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)

