import re

class MenuParser:
    def __init__(self, file):
        self.file = file
        self.menu_file = []
        self.parse()

    def parse(self):
        first_pass = []
        f = open(self.file, 'r')
        for line in f:
            if line.strip() == '':
                continue
            if line.startswith('?package'):
                first_pass.append('')
            first_pass[-1] += line.replace('\n', ' ').replace('\\', ' ')
        f.close()
        for stanza in first_pass:
            self.menu_file.append({'package': '', 'fields': {}})
            self.menu_file[-1]['package'] = \
                stanza[stanza.find('(')+1:stanza.find(')')]
            rest_line = stanza[stanza.find(':')+1:]
            last_field = ''
            for data in re.split(r'\s+', rest_line):
                if not data.strip():
                    continue
                if re.match(r'(needs|section|title|longtitle|icon(|16x16|32x32)|command|hints)=', \
                    data):
                    tmp_line = data.split('=')
                    last_field = tmp_line[0]
                    self.menu_file[-1]['fields'][last_field] = tmp_line[1]
                else:
                    self.menu_file[-1]['fields'][last_field] += " " + data

