#include "librpc/gen_ndr/ndr_srvsvc.h"
#ifndef __CLI_SRVSVC__
#define __CLI_SRVSVC__
NTSTATUS rpccli_srvsvc_NetCharDevEnum(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc,
				      uint32_t *level,
				      union srvsvc_NetCharDevCtr *ctr,
				      uint32_t max_buffer,
				      uint32_t *totalentries,
				      uint32_t *resume_handle,
				      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevGetInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc,
					 const char *device_name,
					 uint32_t level,
					 union srvsvc_NetCharDevInfo *info,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevControl(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc,
					 const char *device_name,
					 uint32_t opcode,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQEnum(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       const char *user,
				       uint32_t *level,
				       union srvsvc_NetCharDevQCtr *ctr,
				       uint32_t max_buffer,
				       uint32_t *totalentries,
				       uint32_t *resume_handle,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQGetInfo(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc,
					  const char *queue_name,
					  const char *user,
					  uint32_t level,
					  union srvsvc_NetCharDevQInfo *info,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQSetInfo(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc,
					  const char *queue_name,
					  uint32_t level,
					  union srvsvc_NetCharDevQInfo info,
					  uint32_t *parm_error,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQPurge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc,
					const char *queue_name,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQPurgeSelf(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_unc,
					    const char *queue_name,
					    const char *computer_name,
					    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetConnEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   const char *path,
				   uint32_t *level,
				   union srvsvc_NetConnCtr *ctr,
				   uint32_t max_buffer,
				   uint32_t *totalentries,
				   uint32_t *resume_handle,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetFileEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   const char *path,
				   const char *user,
				   uint32_t *level,
				   union srvsvc_NetFileCtr *ctr,
				   uint32_t max_buffer,
				   uint32_t *totalentries,
				   uint32_t *resume_handle,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetFileGetInfo(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc,
				      uint32_t fid,
				      uint32_t level,
				      union srvsvc_NetFileInfo *info,
				      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetFileClose(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc,
				    uint32_t fid,
				    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSessEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   const char *client,
				   const char *user,
				   uint32_t *level,
				   union srvsvc_NetSessCtr *ctr,
				   uint32_t max_buffer,
				   uint32_t *totalentries,
				   uint32_t *resume_handle,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSessDel(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc,
				  const char *client,
				  const char *user,
				  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareAdd(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   uint32_t level,
				   union srvsvc_NetShareInfo info,
				   uint32_t *parm_error,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareEnumAll(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       uint32_t *level,
				       union srvsvc_NetShareCtr *ctr,
				       uint32_t max_buffer,
				       uint32_t *totalentries,
				       uint32_t *resume_handle,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareGetInfo(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       const char *share_name,
				       uint32_t level,
				       union srvsvc_NetShareInfo *info,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareSetInfo(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       const char *share_name,
				       uint32_t level,
				       union srvsvc_NetShareInfo info,
				       uint32_t *parm_error,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDel(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   const char *share_name,
				   uint32_t reserved,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDelSticky(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc,
					 const char *share_name,
					 uint32_t reserved,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareCheck(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc,
				     const char *device_name,
				     enum srvsvc_ShareType *type,
				     WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSrvGetInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc,
				     uint32_t level,
				     union srvsvc_NetSrvInfo *info,
				     WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSrvSetInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc,
				     uint32_t level,
				     union srvsvc_NetSrvInfo info,
				     uint32_t *parm_error,
				     WERROR *werror);
NTSTATUS rpccli_srvsvc_NetDiskEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   uint32_t level,
				   struct srvsvc_NetDiskInfo *info,
				   uint32_t maxlen,
				   uint32_t *totalentries,
				   uint32_t *resume_handle,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetServerStatisticsGet(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_unc,
					      const char *service,
					      uint32_t level,
					      uint32_t options,
					      struct srvsvc_Statistics *stats,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetTransportAdd(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       uint32_t level,
				       union srvsvc_NetTransportInfo info,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetTransportEnum(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc,
					uint32_t *level,
					union srvsvc_NetTransportCtr *transports,
					uint32_t max_buffer,
					uint32_t *totalentries,
					uint32_t *resume_handle,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetTransportDel(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       uint32_t unknown,
				       struct srvsvc_NetTransportInfo0 transport,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetRemoteTOD(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc,
				    struct srvsvc_NetRemoteTODInfo *info,
				    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSetServiceBits(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc,
					 const char *transport,
					 uint32_t servicebits,
					 uint32_t updateimmediately,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPathType(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc,
				   const char *path,
				   uint32_t pathflags,
				   uint32_t *pathtype,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPathCanonicalize(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_unc,
					   const char *path,
					   uint8_t *can_path,
					   uint32_t maxbuf,
					   const char *prefix,
					   uint32_t *pathtype,
					   uint32_t pathflags,
					   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPathCompare(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc,
				      const char *path1,
				      const char *path2,
				      uint32_t pathtype,
				      uint32_t pathflags,
				      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetNameValidate(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc,
				       const char *name,
				       uint32_t name_type,
				       uint32_t flags,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRPRNAMECANONICALIZE(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPRNameCompare(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc,
					const char *name1,
					const char *name2,
					uint32_t name_type,
					uint32_t flags,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareEnum(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc,
				    uint32_t *level,
				    union srvsvc_NetShareCtr *ctr,
				    uint32_t max_buffer,
				    uint32_t *totalentries,
				    uint32_t *resume_handle,
				    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDelStart(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc,
					const char *share,
					uint32_t reserved,
					struct policy_handle *hnd,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDelCommit(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *hnd,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetGetFileSecurity(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc,
					  const char *share,
					  const char *file,
					  uint32_t securityinformation,
					  struct sec_desc_buf *sd_buf,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSetFileSecurity(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc,
					  const char *share,
					  const char *file,
					  uint32_t securityinformation,
					  struct sec_desc_buf sd_buf,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetServerTransportAddEx(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_unc,
					       uint32_t level,
					       union srvsvc_NetTransportInfo info,
					       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetServerSetServiceBitsEx(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_unc,
						 const char *emulated_server_unc,
						 const char *transport,
						 uint32_t servicebitsofinterest,
						 uint32_t servicebits,
						 uint32_t updateimmediately,
						 WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSGETVERSION(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSCREATELOCALPARTITION(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSDELETELOCALPARTITION(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSSETSERVERINFO(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSCREATEEXITPOINT(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSDELETEEXITPOINT(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSMODIFYPREFIX(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSFIXLOCALVOLUME(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRSERVERTRANSPORTDELEX(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						WERROR *werror);
#endif /* __CLI_SRVSVC__ */
