/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 *	$Id: ssi_rpi_gm_fast.c,v 1.2 2002/10/09 21:00:22 brbarret Exp $
 *
 *	Function:	- GM low-level routines
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <lamdebug.h>

#include <gm.h>
#include <rpi_gm.h>


/*
 * Do the LAM fastsend of a message -- bypass the queues altogether
 * and do whatever is necessary to send the message now (in a blocking
 * manner).
 */
int 
lam_ssi_rpi_gm_fastsend_low(char *buf, int  size, 
			    struct lam_ssi_rpi_proc *ps, int dest,
			    int tag, MPI_Comm comm)
{
  printf("gm_low.c: lam_ssi_rpi_gm_fastsend not implemented yet");
  lamlog("gm_low.c: lam_ssi_rpi_gm_fastsend not implemented yet");
  return 0;
}


/*
 * Do the LAM fastrecv of a message -- bypass the queues altogether
 * and block while waiting to receive this one specific message from
 * this one specific MPI process.
 */
int
lam_ssi_rpi_gm_fastrecv_low(char *buf, int *size, 
			    struct lam_ssi_rpi_proc *ps, int src, 
			    int *tag, MPI_Comm comm, int *seqnum)
{
  printf("gm_low.c: lam_ssi_rpi_gm_fastrecv not implemented yet");
  lamlog("gm_low.c: lam_ssi_rpi_gm_fastrecv not implemented yet");
  return 0;
}
