/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: rpi_gm.h,v 1.10.2.4 2004/03/12 01:19:10 vsahay Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef LAM_SSI_RPI_GM_H
#define LAM_SSI_RPI_GM_H

#include <lam_config.h>

#include <gm.h>

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>
#include <rpisys.h>

#include <lam-ssi.h>
#include <lam-ssi-rpi.h>
#include <lam-ssi-rpi-gm.h>
#include <rpi_gm_req.h>
#include <rpi_gm_proc.h>


/*
 * If we're using gm 2.x, we need to make a few changes
 */
#if (GM_API_VERSION >= 0x200)
#define LAM_SSI_RPI_GM_2 1
#else
#define LAM_SSI_RPI_GM_2 0
#endif


/* gm priority */
#define LAM_SSI_RPI_GM_PRIORITY  GM_HIGH_PRIORITY

/* mapping */
#define LAM_SSI_RPI_GM_MAP_HASH(id, port) \
   ((id * lam_ssi_rpi_gm_max_port_num) + port) 


/*
 * client-to-client specific process data
 */

typedef struct lam_ssi_rpi_gm_envl {
  struct lam_ssi_rpi_envl ge_env;
  char *ge_target;
} lam_ssi_rpi_gm_envl_t;


/* 
 * List of buffers
 */
struct lam_ssi_rpi_gm_buf_t {
  char *buffer;
  struct lam_ssi_rpi_gm_buf_t *next;
};


/*
 * global variables
 */
extern int lam_ssi_rpi_gm_did;
extern int lam_ssi_rpi_gm_haveadv;
extern int lam_ssi_rpi_gm_flblock;
extern int lam_ssi_rpi_gm_stokens;
extern int lam_ssi_rpi_gm_rtokens;
extern int lam_ssi_rpi_gm_max_port_num;
extern int lam_ssi_rpi_gm_port_num;
extern int lam_ssi_rpi_gm_dma_env_len;
extern int lam_ssi_rpi_gm_dma_short_len;
extern int lam_ssi_rpi_gm_tinymsglen;
extern int lam_ssi_rpi_gm_shortmsglen;
extern int lam_ssi_rpi_gm_can_register_mem;
extern unsigned int lam_ssi_rpi_gm_env_min_size_for_length;
extern unsigned int lam_ssi_rpi_gm_data_min_size_for_length;
extern int lam_ssi_rpi_gm_map_size;
extern struct _proc **lam_ssi_rpi_gm_map;
extern int PUB(req_mid);

#endif	/* LAM_SSI_RPI_GM_H */
