dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_crmpi_blcr_setup.m4,v 1.2.2.1 2003/11/07 22:24:11 jsquyres Exp $
dnl

define([LAM_CRMPI_BLCR_SETUP], [
#
# Arguments: None
#
# Dependencies: None
#
# Defines:
#  LAM_LBNL_LIBCR_PATH
#
# AC_Substs:
#  LAM_BUILD_CRTCP
#  LIBCR_INCLUDE
#  LIBCR_LDFLAGS
#  LIBCR_LIBS
#
# exports:
#  LAM_BUILD_CRTCP
#

LAM_WANT_BLCR=0
LAM_BUILD_CRTCP=0
LIBCR_INCLUDE=""
LIBCR_LDFLAGS=""
LIBCR_LIBS=""

lam_blcr_dir=""


#
# Get all our options out of the way
#
AC_ARG_WITH(blcr,
    AC_HELP_STRING([--with-blcr=DIR],
	[Location of BLCR package (--without-blcr to disable)]),
	    [lam_with_blcr="$withval"])

#
# Get configure templates out of the way...
#
AH_TEMPLATE([LAM_LBNL_LIBCR_PATH],
    [Path to checkpoint/restart library/binaries])

#
# Did user specify blcr?
#
if test -z "$lam_with_blcr"; then
    # Nothing specified - do default
    LAM_WANT_BLCR=-1
else
    # set according to how specified
    if test "$lam_with_blcr" = "yes"; then
	LAM_WANT_BLCR=1
    elif test "$lam_with_blcr" = "no"; then
	LAM_WANT_BLCR=0
    else
	LAM_WANT_BLCR=1
	lam_blcr_dir="$lam_with_blcr"
	LAM_LBNL_LIBCR_PATH="$lam_blcr_dir"
    fi
fi

#
# do we have threads?
#
LAM_CONFIG_THREADS
if test ! "$THREAD_TYPE" = "posix"; then
    AC_MSG_ERROR("*** BLCR requires posix thread support")
fi

#
# Only keep testing if LAM_WANT_BLCR != 0 ('cuz otherwise, user
# don't want it)
#
if test ! "$LAM_WANT_BLCR" = "0"; then

    #
    # Check for libraries
    #
    LIBS_save="$LIBS"
    LDFLAGS_save="$LDFLAGS"
    if test ! "$lam_blcr_dir" = ""; then
	LDFLAGS="$LDFLAGS -L$lam_blcr_dir/lib"
    fi

    AC_CHECK_LIB(cr, cr_register_callback, lam_have_libcr=1, lam_have_libcr=0)
    LIBS="$LIBS_save"
    LDFLAGS="$LDFLAGS_save"

    if test "$lam_have_libcr" = "0" -a "$LAM_WANT_BLCR" = "1"; then
	AC_MSG_WARN([*** Could not find libcr.  Please use --with-blcr=DIR])
	AC_MSG_WARN([*** to specify library location])
	AC_MSG_ERROR([*** Can not continue])
    fi

    # Reset LAM_WANT_BLCR to be 0 / 1 - on by default if possible
    if test "$LAM_WANT_BLCR" = "-1"; then
	if test "$lam_have_libcr" = "1"; then
	    LAM_WANT_BLCR=1
	else
	    LAM_WANT_BLCR=0
	fi
    fi

    # Ok, now set up all the flags...
    if test "$LAM_WANT_BLCR" = "1"; then
	LIBMPI_EXTRA_LIBS="$LIBMPI_EXTRA_LIBS -lcr"
	LIBCR_LIBS="-lcr"
	if test ! "$lam_blcr_lib" = "0"; then
	    LIBCR_INCLUDE="-I$lam_blcr_dir/include"
	    LIBCR_LDFLAGS="-L$lam_blcr_dir/lib"
	    LIBMPI_EXTRA_LDFLAGS="$LIBMPI_EXTRA_LDFLAGS -L$lam_blcr_dir/lib"
	fi
     fi
fi

# And print a final checking message
AC_MSG_CHECKING([if want LBNL checkpoint support])
if test "$LAM_WANT_BLCR" = "0"; then
    AC_MSG_RESULT([no])
    AC_MSG_ERROR([cannot continue])
elif test "$LAM_WANT_BLCR" = "1"; then
    AC_MSG_RESULT([yes])
fi

#
# And store variables where they need to go...
#

# so that it is picked up by the RPI SSI stuffo
export LAM_BUILD_CRTCP

# Most for mpirun - LAM_WANT_BLCR for conditional make
AC_SUBST(LIBCR_INCLUDE)
AC_SUBST(LIBCR_LDFLAGS)
AC_SUBST(LIBCR_LIBS)
AC_SUBST(LAM_BUILD_CRTCP)

# Needed in actual code...
AC_DEFINE_UNQUOTED(LAM_LBNL_LIBCR_PATH, "$LAM_LBNL_LIBCR_PATH") 

])
