/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: ssi_crlam_check_priority.c,v 1.1 2003/04/02 02:41:55 ssankara Exp $
 *
 */

#include <lam_config.h>

#include <stdio.h>
#include <string.h>

#include <etc_misc.h>
#include <lam-ssi-cr.h>


int
lam_ssi_cr_base_check_priority(char *module_name, int base, int want_default,
                                  int *priority)
{
  char *env;
  char name[BUFSIZ];

  *priority = base;
  if (want_default)
    *priority = 75;
  if (module_name != NULL) {
    snprintf(name, BUFSIZ - 1, "LAM_MPI_SSI_cr_%s_priority", module_name);
    name[BUFSIZ - 1] = '\0';
    if ((env = getenv(name)) != NULL)
      *priority = atoi(env);
  }

  if (*priority < 0 && lam_ssi_cr_verbose >= 5)
    lam_debug(lam_ssi_cr_did, "%s: negative priority; exiting", module_name);
  return *priority;
}
