/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: ssi_coll_lam_basic.c,v 1.9 2003/05/28 00:16:28 jsquyres Exp $
 *
 *	Function:	- Basic collective routines
 */

#include <lam_config.h>
#if LAM_WANT_PROFILE
#define LAM_PROFILELIB 1
#endif
#include <lam-ssi-coll-lam-basic-config.h>

#include <lam-ssi-rpi.h>
#include <lam-ssi-coll.h>
#include <lam-ssi-coll-lam-basic.h>
#include <mpisys.h>


/*
 * Linear set of collective algorithms for the other-than-the-lamd RPI
 * (ugh)
 */
static const lam_ssi_coll_actions_1_0_0_t linear = {

  /* Per-communicator initialization and finalization functions */

  lam_ssi_coll_lam_basic_init,
  lam_ssi_coll_lam_basic_finalize,

  /* Checkpoint / restart functions */

  lam_ssi_coll_base_empty_checkpoint,
  lam_ssi_coll_base_empty_continue,
  lam_ssi_coll_base_empty_restart,

  /* Collective function pointers */

  lam_ssi_coll_lam_basic_allgather,
  NULL,

  lam_ssi_coll_lam_basic_allgatherv,
  NULL,

  lam_ssi_coll_lam_basic_allreduce,
  NULL,
  
  lam_ssi_coll_lam_basic_alltoall,
  NULL,

  lam_ssi_coll_lam_basic_alltoallv,
  NULL,

  NULL, /* alltoallw not implemented */
  NULL, /* alltoallw not implemented */

  lam_ssi_coll_lam_basic_barrier_lin,
  NULL,

  1,
  lam_ssi_coll_lam_basic_bcast_lin,
  NULL, 

  NULL, /* exscan not implemented */
  NULL, /* exscan not implemented */

  lam_ssi_coll_lam_basic_gather,
  NULL,

  lam_ssi_coll_lam_basic_gatherv,
  NULL,

  1,
  lam_ssi_coll_lam_basic_reduce_lin,
  NULL,

  lam_ssi_coll_lam_basic_reduce_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scan,
  NULL,

  lam_ssi_coll_lam_basic_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scatterv,
  NULL
};


/*
 * Linear set of collective algorithms for the lamd RPI (ugh)
 */
static const lam_ssi_coll_actions_1_0_0_t linear_lamd = {

  /* Per-communicator initialization and finalization functions */

  lam_ssi_coll_lam_basic_init,
  lam_ssi_coll_lam_basic_finalize,

  /* Checkpoint / restart functions */

  lam_ssi_coll_base_empty_checkpoint,
  lam_ssi_coll_base_empty_continue,
  lam_ssi_coll_base_empty_restart,

  /* Collective function pointers */

  lam_ssi_coll_lam_basic_allgather,
  NULL,

  lam_ssi_coll_lam_basic_allgatherv,
  NULL,

  lam_ssi_coll_lam_basic_allreduce,
  NULL,

  lam_ssi_coll_lam_basic_alltoall_lamd,
  NULL,

  lam_ssi_coll_lam_basic_alltoallv,
  NULL,

  NULL, /* alltoallw not implemented */
  NULL, /* alltoallw not implemented */

  lam_ssi_coll_lam_basic_barrier_lin,
  NULL,

  1,
  lam_ssi_coll_lam_basic_bcast_lin_lamd,
  NULL,

  NULL, /* exscan not implemented */
  NULL, /* exscan not implemented */

  lam_ssi_coll_lam_basic_gather,
  NULL,

  lam_ssi_coll_lam_basic_gatherv,
  NULL,

  1,
  lam_ssi_coll_lam_basic_reduce_lin,
  NULL,

  lam_ssi_coll_lam_basic_reduce_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scan,
  NULL,

  lam_ssi_coll_lam_basic_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scatterv,
  NULL
};


/*
 * Lograthmic set of collective algorithms.  Note that not all
 * collectives have lograthmic algorithms.  For example, scan will use
 * the same algorithm as in the linear set.
 */
static const lam_ssi_coll_actions_1_0_0_t log = {

  /* Per-communicator initialization and finalization functions */

  lam_ssi_coll_lam_basic_init,
  lam_ssi_coll_lam_basic_finalize,

  /* Checkpoint / restart functions */

  lam_ssi_coll_base_empty_checkpoint,
  lam_ssi_coll_base_empty_continue,
  lam_ssi_coll_base_empty_restart,

  /* Collective function pointers */

  lam_ssi_coll_lam_basic_allgather,
  NULL,

  lam_ssi_coll_lam_basic_allgatherv,
  NULL,

  lam_ssi_coll_lam_basic_allreduce,
  NULL,

  lam_ssi_coll_lam_basic_alltoall,
  NULL,

  lam_ssi_coll_lam_basic_alltoallv,
  NULL,

  NULL, /* alltoallw not implemented */
  NULL, /* alltoallw not implemented */

  lam_ssi_coll_lam_basic_barrier_log,
  NULL,

  1,
  lam_ssi_coll_lam_basic_bcast_log,
  NULL,

  NULL, /* exscan not implemented */
  NULL, /* exscan not implemented */

  lam_ssi_coll_lam_basic_gather,
  NULL,

  lam_ssi_coll_lam_basic_gatherv,
  NULL,

  1,
  lam_ssi_coll_lam_basic_reduce_log,
  NULL,

  lam_ssi_coll_lam_basic_reduce_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scan,
  NULL,

  lam_ssi_coll_lam_basic_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scatterv,
  NULL
};


/*
 * Lograthmic set of collective algorithms for the lamd RPI (ugh!)
 * (same disclaimers as above)
 */
static const lam_ssi_coll_actions_1_0_0_t log_lamd = {

  /* Per-communicator initialization and finalization functions */

  lam_ssi_coll_lam_basic_init,
  lam_ssi_coll_lam_basic_finalize,

  /* Checkpoint / restart functions */

  lam_ssi_coll_base_empty_checkpoint,
  lam_ssi_coll_base_empty_continue,
  lam_ssi_coll_base_empty_restart,

  /* Collective function pointers */

  lam_ssi_coll_lam_basic_allgather,
  NULL,

  lam_ssi_coll_lam_basic_allgatherv,
  NULL,

  lam_ssi_coll_lam_basic_allreduce,
  NULL,

  lam_ssi_coll_lam_basic_alltoall_lamd,
  NULL,

  lam_ssi_coll_lam_basic_alltoallv,
  NULL,

  NULL, /* alltoallw not implemented */
  NULL, /* alltoallw not implemented */

  lam_ssi_coll_lam_basic_barrier_log,
  NULL,

  1,
  lam_ssi_coll_lam_basic_bcast_log_lamd,
  NULL,

  NULL, /* exscan not implemented */
  NULL, /* exscan not implemented */

  lam_ssi_coll_lam_basic_gather,
  NULL,

  lam_ssi_coll_lam_basic_gatherv,
  NULL,

  1,
  lam_ssi_coll_lam_basic_reduce_log,
  NULL,

  lam_ssi_coll_lam_basic_reduce_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scan,
  NULL,

  lam_ssi_coll_lam_basic_scatter,
  NULL,

  lam_ssi_coll_lam_basic_scatterv,
  NULL
};


/*
 * Initial query function that is invoked during MPI_INIT, allowing
 * this module to indicate what level of thread support it provides.
 */
int 
lam_ssi_coll_lam_basic_thread_query(int *thread_min, int *thread_max)
{
  *thread_min = MPI_THREAD_SINGLE;
  *thread_max = MPI_THREAD_MULTIPLE;
  
  return 0;
}


/*
 * Invoked when there's a new communicator that has been created.
 * Look at the communicator and decide which set of functions and
 * priority we want to return.
 */
const lam_ssi_coll_actions_t *
lam_ssi_coll_lam_basic_query(MPI_Comm comm, int *priority)
{
  int size;

  /* This module should always have the lowest available priority */

  *priority = 0;

  /* This is horrible, and a break in the abstraction, but we have to
     know whether we're using the lamd RPI or not.  :-( We also get to
     choose whether to use linear or log-based algorithms. */

  MPI_Comm_size(comm, &size);
  if (size <= lam_ssi_coll_base_crossover) {
    if (RPI_IS_LAMD() == 1)
      return &linear_lamd;
    else
      return &linear;
  } else {
    if (RPI_IS_LAMD() == 1)
      return &log_lamd;
    else
      return &log;
  }
}


int
lam_ssi_coll_lam_basic_init(MPI_Comm comm, 
			    const lam_ssi_coll_actions_t **new_actions)
{
  /* Nothing to init on the communicator */

  if (lam_ssi_coll_verbose >= 10)
    lam_debug(lam_ssi_coll_did, "lam_basic: init communicator %s",
	      comm->c_name);
  return 0;
}


int
lam_ssi_coll_lam_basic_finalize(MPI_Comm comm)
{
  /* Nothing to finalize on the communicator */

  if (lam_ssi_coll_verbose >= 10)
    lam_debug(lam_ssi_coll_did, "lam_basic: finalize communicator %s",
	      comm->c_name);
  return 0;
}
