#ifndef RQCACHECONTROL_H
#define RQCACHECONTROL_H

#include <qobject.h>

#include <rqpackagepopup.h>
#include <rqpackageitem.h>

#include <vector>

using std::vector;

class RPackageLister;
class RPackage;

class QWidget;

class RQCacheControl : public QObject
{
   Q_OBJECT

   protected:

   RPackageLister *_lister;

   QWidget *_parent;

   public:

   enum {
      MarkKeep,
      MarkInstall,
      MarkReInstall,
      MarkRemove,
      MarkPurge,
   };

   void markPackage(RPackage *pkg, int mark, bool fix=true);
   void markPackages(vector<RPackage *> packages, int mark, bool fix=true);
   
   RQCacheControl(RPackageLister *lister, QWidget *parent = NULL)
      : _lister(lister), _parent(parent)
   {};

};

class RQListViewControl : public RQCacheControl
{
   Q_OBJECT

   protected:
      
   QListView *_packageListView;

   RQPackagePopup _packagePopup;
   RQPackageTip _packageTip;

   bool _showIcon;

   public:

   vector<RPackage *> getSelected();
   void setClickable(bool flag);
   void setShowIcon(bool flag) { _showIcon = flag; };

   RQListViewControl(RPackageLister *lister, QListView *listView);

   public slots:

   void reloadViewPackages();
   void reloadAllPackages();
   void clearPackages();
   void markPackagesFromPopup(int id);
   void rightClickedOnPackageList(QListViewItem *item,
                                  const QPoint &pos, int col);
   void leftClickedOnPackageList(QListViewItem *item,
                                 const QPoint &pos, int col);
};

#endif

// vim:ts=3:sw=3:et
