#!/bin/sh

ACTION=$1
PKGNAME=$2

TMPDIR=`mktemp -d` || exit 1
TMPFILE=`mktemp` || exit 1
echo "program output" >> $TMPFILE

case $ACTION in
  info)
	dpkg-deb -I "$PKGNAME" > $TMPFILE
	echo " " >> $TMPFILE
	echo "Status: " >> $TMPFILE
	name=`basename "$PKGNAME" | cut -d_ -f1`
	dpkg-query -W --showformat='${Status}' $name >> $TMPFILE
	echo -e '\n----\nPackage contents:\n \n' >> $TMPFILE
	dpkg-deb -c "$PKGNAME" >> $TMPFILE
	kdialog --textbox $TMPFILE 800 600
	rm $TMPFILE
	exit 0
	;;

  *)
	exit 1
	;;
esac