/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include "parsingHelper.h"

QMap<QString, int> ParsingHelper::mapMonths;

QMap<QString, QString> ParsingHelper::mapHTTPResponse;

QDateTime ParsingHelper::parseDateTimeFromHTTP(QString& logLine) {

	//Format example : [22/May/2005:01:50:34 +0200]
		
	QString day=logLine.mid(1,2);
	QString month=logLine.mid(4,3);
	QString year=logLine.mid(8,4);
	
	QDate date(year.toInt(), ParsingHelper::parseMonthNumber(month), day.toInt());
	
	QString hour=logLine.mid(13,2);
	QString min=logLine.mid(16,2);
	QString sec=logLine.mid(19,2);

	QTime time(hour.toInt(), min.toInt(), sec.toInt());
	
	//QString zone=logLine.mid(22,5);
	
	return(QDateTime(date, time));
}


/**
 * Improve speed of this method with a static Map in the class
 */
int ParsingHelper::parseMonthNumber(QString& string) {
	//If this is the first time we call this method, we instanciate the map
	if (ParsingHelper::mapMonths.isEmpty()) {
		ParsingHelper::mapMonths["Jan"]=1;
		ParsingHelper::mapMonths["Feb"]=2;
		ParsingHelper::mapMonths["Mar"]=3;
		ParsingHelper::mapMonths["Apr"]=4;
		ParsingHelper::mapMonths["May"]=5;
		ParsingHelper::mapMonths["Jun"]=6;
		ParsingHelper::mapMonths["Jul"]=7;
		ParsingHelper::mapMonths["Aug"]=8;
		ParsingHelper::mapMonths["Sep"]=9;
		ParsingHelper::mapMonths["Oct"]=10;
		ParsingHelper::mapMonths["Nov"]=11;
		ParsingHelper::mapMonths["Dec"]=12;
	}
	
	QMap<QString, int>::Iterator it;
	
	//Search the month name in the map
	it=ParsingHelper::mapMonths.find(string);
	
	if (it!=ParsingHelper::mapMonths.end())
		return(*it);
	else
		return(1);
	
}

QString ParsingHelper::parseSize(const QString& stringSize) {
	long size=stringSize.toLong();
	
	if (size<1024)
		return(i18n("Size format", "%1 B").arg(size));
	else if (size<1024*1024) {
		double newSize=size / 1024.;
		QString strNewSize;
		strNewSize.sprintf("%0.2f", newSize);
		return(i18n("Size format", "%1 KB").arg(strNewSize));
	}
	else {
		double newSize=size / (1024.*1024.);
		QString strNewSize;
		strNewSize.sprintf("%0.2f", newSize);
		return(i18n("Size format", "%1 MB").arg(strNewSize));
	}
}

QString ParsingHelper::parseHTTPResponse(const QString& response) {
	if (ParsingHelper::mapHTTPResponse.isEmpty()) {
		//1xx Responses
		mapHTTPResponse["100"]="Continue";
		mapHTTPResponse["101"]="Switching Protocols";
	
		//2xx Responses
		mapHTTPResponse["200"]="OK";
		mapHTTPResponse["201"]="Created";
		mapHTTPResponse["202"]="Accepted";
		mapHTTPResponse["203"]="Non-Authoritative Information";
		mapHTTPResponse["204"]="No Content";
		mapHTTPResponse["205"]="Reset Content";
		mapHTTPResponse["206"]="Partial Content";
	
		//3xx Responses
		mapHTTPResponse["300"]="OK";
		mapHTTPResponse["301"]="Moved Permanently";
		mapHTTPResponse["302"]="Found";
		mapHTTPResponse["303"]="See Other";
		mapHTTPResponse["304"]="Not Modified";
		mapHTTPResponse["305"]="Use Proxy";
		mapHTTPResponse["306"]="(Unused)";
		mapHTTPResponse["307"]="Temporary Redirect";
		
		//4xx Responses
		mapHTTPResponse["400"]="Bad Request";
		mapHTTPResponse["401"]="Unauthorized";
		mapHTTPResponse["402"]="Payment Required";
		mapHTTPResponse["403"]="Forbidden";
		mapHTTPResponse["404"]="Not Found";
		mapHTTPResponse["405"]="Method Not Allowed";
		mapHTTPResponse["406"]="Not Acceptable";
		mapHTTPResponse["407"]="Proxy Authentication Required";
		mapHTTPResponse["408"]="Request Timeout";
		mapHTTPResponse["409"]="Conflict";
		mapHTTPResponse["410"]="Gone";
		mapHTTPResponse["411"]="Length Required";
		mapHTTPResponse["412"]="Precondition Failed";
		mapHTTPResponse["413"]="Request Entity Too Large";
		mapHTTPResponse["414"]="Request-URI Too Long";
		mapHTTPResponse["415"]="Unsupported Media Type";
		mapHTTPResponse["416"]="Requested Range Not Satisfiable";
		mapHTTPResponse["417"]="Expectation Failed";
		
		//5xx Responses
		mapHTTPResponse["500"]="Internal Server Error";
		mapHTTPResponse["501"]="Not Implemented";
		mapHTTPResponse["502"]="Bad Gateway";
		mapHTTPResponse["503"]="Service Unavailable";
		mapHTTPResponse["504"]="Gateway Timeout";
		mapHTTPResponse["505"]="HTTP Version Not Supported";
	}
	
	//Search the response string in the map
	QMap<QString, QString>::Iterator it=ParsingHelper::mapHTTPResponse.find(response);
	if (it!=ParsingHelper::mapHTTPResponse.end())
		return(QString("%1 %2").arg(response).arg(*it));
	else
		return(response);

}

QString ParsingHelper::parseAgent(const QString& agent) {
	return(agent);
}

