/***************************************************************************
 *
 * qbidiractionalmap.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef QBIDIRECTIONALMAP_H
#define QBIDIRECTIONALMAP_H

#include <qmap.h>

template<class Key, class T> class QBiDirectionalMap : public QMap<Key, T>
{
	public:
		QMapIterator<Key, T> findData(const T & data)
		{
			for (QMapIterator<Key,T> it = QMap<Key, T>::begin(); it != QMap<Key, T>::end(); ++it)
			{
				if(it.data() == data)
				{
					return it;
				}
			}
			return QMap<Key,T>::end();
		}
};

#endif 

