/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_WIRELESS_DEVICE_TRAY_H
#define KNETWORKMANAGER_WIRELESS_DEVICE_TRAY_H

// KNM includes
#include "knetworkmanager.h"
#include "devicetraycomponent.h"
#include "knetworkmanager-wireless_network.h"

// predefinitions
class WirelessDevice;
class WirelessDeviceTrayPrivate;

namespace ConnectionSettings
{
	class Connection;
	class WirelessConnection;
}

class WirelessDeviceTray : public DeviceTrayComponent
{
	Q_OBJECT

	public:
	  WirelessDeviceTray (WirelessDevice*, KSystemTray * parent = 0, const char * name = 0);
	  ~WirelessDeviceTray ();

		void addMenuItems(KPopupMenu* menu);

	protected:
		/**
		 * Reimplementation
		 */
		QStringList getToolTipText();

	public slots:
		void slotUpdateDeviceState(NMDeviceState);
		void slotCheckActiveAccessPoint();
		void newConnection();
	protected slots:
		void apStrengthChanged(Q_UINT8 strength);
		void slotAccessPointAdded(AccessPoint*);
		void slotAccessPointRemoved(const QString&);

	private:
		void addWirelessNetworks (KPopupMenu* menu);
		QValueList<WirelessNetwork> getWirelessNetworks();
		QValueList<ConnectionSettings::WirelessConnection*> getWirelessConnections();
		ConnectionSettings::WirelessConnection* findMatchingConnection(const WirelessNetwork& net, const QValueList<ConnectionSettings::WirelessConnection*>& connection);
		bool findMatchingNetwork(const ConnectionSettings::WirelessConnection* conn, const QValueList<WirelessNetwork>& nets, WirelessNetwork& net);

		WirelessDeviceTrayPrivate* d;

};

#endif /* KNETWORKMANAGER_WIRELESS_DEVICE_TRAY_H */
