/***************************************************************************
 *
 * knetworkmanager-wired_device_tray.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>

// Qt DBus
#include <dbus/qdbusobjectpath.h>


// KNM includes
#include "knetworkmanager-wired_device_tray.h"
#include "knetworkmanager-wired_device.h"
#include "knetworkmanager-menuitem.h"
#include "knetworkmanager-menu_subhead.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-wired_connection.h"
#include "knetworkmanager-nm_proxy.h"

#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_settings_dialog.h"

using namespace ConnectionSettings;

class WiredDeviceTrayPrivate
{
	public:
		WiredDeviceTrayPrivate() {}
		~WiredDeviceTrayPrivate() {}

		WiredDevice* dev;
};

void WiredDeviceTray::newConnection()
{
	// create a new wired connection
	Connection* conn = new WiredConnection();

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, NULL, tray(), "connect_something", false, Qt::WDestructiveClose);
	dlg->show();
}


void WiredDeviceTray::addMenuItems(KPopupMenu* menu)
{
	ConnectionStore* connectionStore = ConnectionStore::getInstance();

	// device title
	Subhead* subhead = new Subhead (menu, "subhead", d->dev->getInterface(), SmallIcon("wired", QIconSet::Automatic));
	menu->insertItem (subhead, -1, -1);

    // bolding subhead instead
	//menu->insertSeparator();

	if (!d->dev->getCarrier())
	{
		// no carrier -> do not show any connections
		subhead = new Subhead(menu, "subhead2", i18n("No carrier"), SmallIcon("no", QIconSet::Automatic));
		menu->insertItem(subhead, -1, -1);
	}
	else
	{
		NMProxy* nm = NMProxy::getInstance();
		Connection* active_conn = nm->getActiveConnection(d->dev);
		if (active_conn)
			printf("%s\n", active_conn->getObjectPath().data());

		// get all available Connections for wired devices
		QValueList<Connection*> connections = connectionStore->getConnections(NM_SETTING_WIRED_SETTING_NAME);
		int connectionItems = 0;
		for (QValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
		{
			WiredConnection* wiredconn = dynamic_cast<WiredConnection*>(*it);
			if (wiredconn)
			{
				// wired connection found :)
				Info* info = wiredconn->getInfoSetting();
				IPv4* ip = wiredconn->getIPv4Setting();

				// lets create a nice name for this connection
				if (info)
				{
					QString title = info->getName();
					if (ip)
						title += QString(" (%1)").arg(ip->getMethod() == IPv4::METHOD_DHCP ? i18n("DHCP") : i18n("Manual IP config"));
	
					NetworkMenuItem* item = new NetworkMenuItem(d->dev, wiredconn, menu);
					connectionItems += 1;

					int id = menu->insertItem(title, item, SLOT(slotActivate()));
					menu->setItemChecked(id, ((*it) == active_conn));
				}
			}
		}

		if ( connectionItems ) {
			menu->insertSeparator();
		}
		// bring the device down
		KAction* deactivate = tray()->actionCollection()->action("deactivate_device");
		if (deactivate)
			deactivate->plug(menu);

	}
	menu->insertSeparator();
}

WiredDeviceTray::WiredDeviceTray (WiredDevice* dev, KSystemTray * parent, const char * name )
	: DeviceTrayComponent (dev, parent, name)
{
	d = new WiredDeviceTrayPrivate();
	d->dev = dev;

	setPixmapForState(NM_DEVICE_STATE_ACTIVATED, KSystemTray::loadIcon("nm_device_wired"));

}

WiredDeviceTray::~WiredDeviceTray ()
{
	delete d;
}

#include "knetworkmanager-wired_device_tray.moc"
