/***************************************************************************
 *
 * knetworkmanager-vpnservice.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#define SERVICE_DIR "/etc/NetworkManager/VPN"

#include <stdlib.h>
#include <kconfig.h>
#include <qdom.h> 
#include <qdir.h>
#include <klocale.h>
#include <kdebug.h>
#include <kstddirs.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kplugininfo.h>

#include "knetworkmanager-pluginmanager.h"
#include "knetworkmanager-vpnservice.h"
#include "knetworkmanager-vpnplugin.h"

/*
 *  class VPNService
 *
 */

VPNService::VPNService(const QString& serviceName, const QString& service, QObject* parent, const char* name)
	: QObject(parent, name)
{
	_name = serviceName;
	_service = service;
	_vpnPlugin = NULL;

	// query if a plugin for this vpn service is available
	PluginManager* plugMan = PluginManager::getInstance();
	if (plugMan)
	{
		QStringList list = plugMan->getPluginList("KNetworkManager/VPNPlugin", "X-NetworkManager-Services", serviceName);
		if (list.size() > 0)
		{
			// get the first VPN Plugin	handling our VPNService
			VPNPlugin* vpnPlugin = dynamic_cast<VPNPlugin*>( plugMan->getPlugin(list.first()) );
			if (vpnPlugin)
			{
				kdDebug() << k_funcinfo << i18n("Using VPN plugin '%1' for service '%2'").arg(list.first()).arg(serviceName) << endl;
				_vpnPlugin = vpnPlugin;
			}
		}
	}
}

VPNService::~VPNService()
{

}

QString VPNService::getIcon()
{
	if (!_vpnPlugin.isNull())
	{
		PluginManager* plugMan = PluginManager::getInstance();
		if (plugMan)
		{
			const KPluginInfo* info = plugMan->getPluginInfo(_vpnPlugin);
			if (info)
			{
				QString icon = info->icon();
				if (!icon.isEmpty())
					return icon;
			}
		}
	}
	return "encrypted";
}

VPNPlugin* VPNService::getVPNPlugin()
{
	return _vpnPlugin;
}

QString VPNService::getService() const
{
	return _service;
}

QString VPNService::getDisplayName() const
{
	const KPluginInfo* info = NULL;
	PluginManager* plugMan = PluginManager::getInstance();
	if (_vpnPlugin && plugMan)
		if ( (info = plugMan->getPluginInfo(_vpnPlugin)) )
			if (!info->name().isEmpty())
				return info->name();
	return _name;
}

QString VPNService::getName() const
{
	return _name;
}

#include "knetworkmanager-vpnservice.moc"
