/***************************************************************************
 *
 * knetworkmanager-vpnmanager.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#define SERVICE_DIR "/etc/NetworkManager/VPN"

#include <klocale.h>
#include <qdir.h>
#include <kdebug.h>
#include <kconfig.h>

#include "knetworkmanager-vpnmanager.h"
#include "knetworkmanager-vpnservice.h"
#include "knetworkmanager-vpnplugin.h"

/*
 *  class VPNManager
 *
 */
VPNServiceList
VPNManager::getVPNServices ()
{
	bool status = false;
	VPNServiceList list;
	
	QDir serviceDir(SERVICE_DIR, QString::null, QDir::Name|QDir::IgnoreCase, QDir::Files);
	QStringList services = serviceDir.entryList ().grep (".name", true);

	if (services.count () > 0)
	{	
		status = true;
		// read in all available Services
		for (QStringList::Iterator i = services.begin (); i != services.end (); ++i) {
			QString service = SERVICE_DIR + QString ("/") + *i;
			KConfig* kconfig = new KConfig (service, true, true, "config");
			kconfig->setGroup ("VPN Connection");

printf("VPN Service %s\n", kconfig->readEntry ("name", QString::null).ascii());

			// create new VPNService Object
			VPNService* vpnservice = new VPNService(kconfig->readEntry ("name", QString::null), kconfig->readEntry ("service", QString::null), KNetworkManager::getInstance());
			if (!vpnservice->getVPNPlugin())
				delete vpnservice;
			else
				list.push_back(vpnservice);
			delete kconfig;
		}
	}

	return list;
}

VPNService*
VPNManager::getVPNService(QString service_type)
{
	bool status = false;
	VPNServiceList list;
	
	QDir serviceDir(SERVICE_DIR, QString::null, QDir::Name|QDir::IgnoreCase, QDir::Files);
	QStringList services = serviceDir.entryList ().grep (".name", true);

	if (services.count () > 0)
	{	
		status = true;
		// read in all available Services
		for (QStringList::Iterator i = services.begin (); i != services.end (); ++i) {
			QString service = SERVICE_DIR + QString ("/") + *i;
			KConfig* kconfig = new KConfig (service, true, true, "config");
			kconfig->setGroup ("VPN Connection");

			if (kconfig->readEntry ("service", QString::null) == service_type)
			{
				// create new VPNService Object
				VPNService* vpnservice = new VPNService(kconfig->readEntry ("name", QString::null), kconfig->readEntry ("service", QString::null), KNetworkManager::getInstance());
				if (!vpnservice->getVPNPlugin())
					delete vpnservice;
				else
					return vpnservice;
			}
		}
	}
	return NULL;

}

#include "knetworkmanager-vpnmanager.moc"
